<?php

namespace App\Filament\Blocks;

use Filament\Forms\Components\Builder\Block;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;

class CustomFormBlock
{
    public static function make(): Block
    {
        return Block::make('custom_form')
            ->label('نموذج مخصص (Custom Form)')
            ->icon('heroicon-o-document-text')
            ->schema([
                        TextInput::make('title')
                            ->label('عنوان القسم (اختياري)'),
                        TextInput::make('description')
                            ->label('وصف القسم (اختياري)'),
                Select::make('custom_form_id')
                    ->label('النموذج')
                    ->options(function () {
                        return \App\Models\CustomForm::active()->pluck('name', 'id');
                    })
                    ->required()
                    ->searchable()
                    ->preload(),
            ]);
    }
}
