<?php

namespace App\Filament\Blocks;

use Filament\Forms\Components\Builder\Block;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\Toggle;

class HeroSliderBlock
{
    public static function make(): Block
    {
        return Block::make('hero_slider')
            ->label('سلايدر صور (أعلى الصفحة)')
            ->icon('heroicon-o-rectangle-stack')
            ->schema([
                Repeater::make('slides')
                    ->label('Slides')
                    ->schema([
                        FileUpload::make('image')
                            ->label('Background Image')
                            ->image()
                            ->directory('slides')
                            ->required()
                            ->maxSize(5120),
                        
                                TextInput::make('title')
                                    ->label('عنوان الشريحة')
                                    ->required()
                                    ->live(debounce: 700)
                                    ->maxLength(255),
                                
                                Textarea::make('subtitle')
                                    ->label('النص الفرعي')
                                    ->rows(2)
                                    ->live(debounce: 700)
                                    ->maxLength(500),
                                
                                TextInput::make('button_text')
                                    ->label('نص الزر')
                                    ->placeholder('مثال: المزيد')
                                    ->live(debounce: 700)
                                    ->maxLength(100),
                                
                                TextInput::make('button_url')
                                    ->label('رابط الزر')
                                    ->placeholder('مثال: /about أو https://example.com')
                                    ->live(debounce: 700)
                                    ->maxLength(255),
                        
                        Toggle::make('is_active')
                            ->label('Active')
                            ->default(true),
                    ])
                    ->collapsible()
                    ->itemLabel(fn (array $state): ?string => $state['title'] ?? 'New Slide')
                    ->defaultItems(1)
                    ->maxItems(5)
                    ->columnSpanFull(),
            ]);
    }
}
