<?php

namespace App\Filament\Blocks;

use App\Support\IconOptions;
use Filament\Forms\Components\Builder\Block;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Section;

class PrismaCategoriesBlock
{
    public static function make(): Block
    {
        return Block::make('prisma_categories')
            ->label('تصنيفات (Prisma)')
            ->icon('heroicon-o-squares-2x2')
            ->schema([
                Section::make('Display Settings')
                    ->schema([
                        Toggle::make('show_from_database')
                            ->label('Show Categories from Database')
                            ->default(true)
                            ->helperText('Turn off to use custom categories below'),
                        
                        TextInput::make('limit')
                            ->label('Number of Categories')
                            ->numeric()
                            ->default(8)
                            ->live(debounce: 700)
                            ->visible(fn ($get) => $get('show_from_database')),
                        
                        Toggle::make('show_names')
                            ->label('Show Category Names')
                            ->default(true),
                        
                        Toggle::make('card_style')
                            ->label('Use Card Style Background')
                            ->default(true),
                    ]),
                
                Section::make('Custom Categories (optional)')
                    ->schema([
                        Repeater::make('custom_categories')
                            ->label('Categories')
                            ->schema([
                                        TextInput::make('name')
                                            ->label('اسم التصنيف')
                                            ->required()
                                            ->live(debounce: 700),
                                
                                TextInput::make('url')
                                    ->label('Link URL')
                                    ->default('#')
                                    ->live(debounce: 700)
                                    ->columnSpanFull(),
                                
                                Select::make('icon_type')
                                    ->label('Icon source')
                                    ->options([
                                        'library' => 'Icon library (FontAwesome)',
                                        'image'   => 'Custom image upload',
                                    ])
                                    ->default('library')
                                    ->live(),
                                
                                Select::make('icon')
                                    ->label('Icon')
                                    ->options(IconOptions::fontAwesomeOptions())
                                    ->default('fas fa-flask')
                                    ->searchable()
                                    ->visible(fn ($get) => ($get('icon_type') ?? 'library') === 'library'),
                                
                                FileUpload::make('icon_image')
                                    ->label('Icon image')
                                    ->image()
                                    ->directory('block-icons')
                                    ->visibility('public')
                                    ->imageEditor()
                                    ->maxSize(1024)
                                    ->visible(fn ($get) => ($get('icon_type') ?? 'library') === 'image'),
                            ])
                            ->columns(2)
                            ->visible(fn ($get) => !$get('show_from_database')),
                    ])
                    ->collapsed(),
            ]);
    }
}
