<?php

namespace App\Filament\Blocks;

use Filament\Forms\Components\Builder\Block;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\Section;

class PrismaServicesBlock
{
    public static function make(): Block
    {
        return Block::make('prisma_services')
            ->label('خدمات (Prisma)')
            ->icon('heroicon-o-sparkles')
            ->schema([
                        TextInput::make('title')
                            ->label('العنوان الرئيسي')
                            ->default('خدماتنا المميزة')
                            ->live(debounce: 700),
                        
                        Textarea::make('subtitle')
                            ->label('العنوان الفرعي')
                            ->default('نقدم لك مجموعة متكاملة من الخدمات المخبرية بأعلى معايير الجودة')
                            ->rows(2)
                            ->live(debounce: 700),
                Section::make('Services')
                    ->schema([
                        Repeater::make('services')
                            ->label('Services Items')
                            ->schema([
                                        TextInput::make('title')
                                            ->label('عنوان الخدمة')
                                            ->required(),
                                        Textarea::make('description')
                                            ->label('وصف الخدمة')
                                            ->rows(2)
                                            ->required(),
                                
                                Select::make('icon_type')
                                    ->label('Icon source')
                                    ->options([
                                        'library' => 'Icon library (FontAwesome)',
                                        'image'   => 'Custom image upload',
                                    ])
                                    ->default('library')
                                    ->live(),
                                
                                Select::make('icon')
                                    ->label('Icon')
                                    ->options(\App\Support\IconOptions::fontAwesomeOptions())
                                    ->default('fas fa-flask')
                                    ->searchable()
                                    ->visible(fn ($get) => ($get('icon_type') ?? 'library') === 'library'),
                                
                                \Filament\Forms\Components\FileUpload::make('icon_image')
                                    ->label('Icon image')
                                    ->image()
                                    ->directory('block-icons')
                                    ->visibility('public')
                                    ->imageEditor()
                                    ->maxSize(1024)
                                    ->visible(fn ($get) => ($get('icon_type') ?? 'library') === 'image'),
                            ])
                            ->columns(1)
                            ->default([
                                [
                                    'title' => 'تحاليل الدم الشاملة', 
                                    'description' => 'فحوصات دم دقيقة تشمل جميع المؤشرات الحيوية مع تقارير مفصلة', 
                                    'icon' => 'fas fa-flask'
                                ],
                                [
                                    'title' => 'تحاليل البول والبراز', 
                                    'description' => 'تحاليل دقيقة للكشف عن الأمراض والالتهابات والأملاح', 
                                    'icon' => 'fas fa-vial'
                                ],
                                [
                                    'title' => 'تحاليل هرمونية', 
                                    'description' => 'فحص شامل لمناعة الجسم والأجسام المضادة لمختلف الأمراض', 
                                    'icon' => 'fas fa-dna'
                                ],
                                [
                                    'title' => 'سحب منزلي مجاني', 
                                    'description' => 'نأتيك أينما كنت داخل المدينة مع خدمة سحب عينات مجانية', 
                                    'icon' => 'fas fa-home'
                                ],
                            ]),
                    ]),
                
                Section::make('Layout')
                    ->schema([
                        Toggle::make('show_icon_background')
                            ->label('Show Icon Gradient Background')
                            ->default(true),
                        
                        Toggle::make('card_border')
                            ->label('Show Card Border')
                            ->default(true),
                        
                        Toggle::make('center_align')
                            ->label('Center Align Content')
                            ->default(true),
                    ])
                    ->columns(3),
            ]);
    }
}
