<?php

namespace App\Filament\Resources;

use App\Filament\Resources\CustomFormSubmissionResource\Pages;
use App\Filament\Resources\CustomFormSubmissionResource\RelationManagers;
use App\Models\CustomFormSubmission;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class CustomFormSubmissionResource extends Resource
{
    protected static ?string $model = CustomFormSubmission::class;

    protected static ?string $navigationIcon = 'heroicon-o-inbox-arrow-down';
    protected static ?string $navigationLabel = 'الردود المستلمة';
    protected static ?string $modelLabel = 'رد';
    protected static ?string $pluralModelLabel = 'الردود المستلمة';

    public static function canCreate(): bool
    {
        return false;
    }

    public static function canEdit(\Illuminate\Database\Eloquent\Model $record): bool
    {
        return false;
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Section::make('معلومات الرد')
                    ->schema([
                        Forms\Components\Select::make('custom_form_id')
                            ->relationship('form', 'name')
                            ->label('النموذج')
                            ->disabled(),
                        Forms\Components\TextInput::make('ip_address')
                            ->label('عنوان الـ IP')
                            ->disabled(),
                        Forms\Components\DateTimePicker::make('created_at')
                            ->label('تاريخ الإرسال')
                            ->disabled(),
                        Forms\Components\TextInput::make('user_agent')
                            ->label('المتصفح')
                            ->columnSpanFull()
                            ->disabled(),
                    ])->columns(3),

                Forms\Components\Section::make('البيانات المُرسلة')
                    ->schema([
                        Forms\Components\KeyValue::make('data')
                            ->label('تفاصيل البيانات')
                            ->keyLabel('الحقل')
                            ->valueLabel('القيمة')
                            ->disabled()
                            ->columnSpanFull(),
                    ]),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('form.name')
                    ->label('النموذج')
                    ->searchable()
                    ->sortable()
                    ->badge(),
                Tables\Columns\TextColumn::make('ip_address')
                    ->label('الـ IP')
                    ->searchable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->label('تاريخ الإرسال')
                    ->dateTime()
                    ->sortable(),
            ])
            ->defaultSort('created_at', 'desc')
            ->filters([
                Tables\Filters\SelectFilter::make('custom_form_id')
                    ->relationship('form', 'name')
                    ->label('تصفية بالنموذج'),
            ])
            ->actions([
                Tables\Actions\ViewAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListCustomFormSubmissions::route('/'),
            'create' => Pages\CreateCustomFormSubmission::route('/create'),
            'edit' => Pages\EditCustomFormSubmission::route('/{record}/edit'),
        ];
    }
}
