<?php

if (!function_exists('block_trans')) {
    /**
     * Get a block field value with multi-language support.
     * Uses current app locale (e.g. 'ar', 'en'). Prefers {key}_{locale}, falls back to {key}.
     *
     * @param array<string, mixed> $data Block data array
     * @param string $key Base field name (e.g. 'title', 'description')
     * @param string|null $default Default if no value found
     * @return string|null
     */
    function block_trans(mixed $data, string $key, ?string $default = null): ?string
    {
        if (!is_array($data)) {
            return $default;
        }

        $locale = app()->getLocale();
        $localeKey = $key . '_' . $locale;
        if (!empty($data[$localeKey])) {
            return (string) $data[$localeKey];
        }
        if (!empty($data[$key])) {
            return (string) $data[$key];
        }
        return $default;
    }
}
