<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CustomFormSubmission extends Model
{
    protected $fillable = [
        'custom_form_id',
        'data',
        'ip_address',
        'user_agent',
    ];

    protected $casts = [
        'data' => 'array',
    ];

    public function form()
    {
        return $this->belongsTo(CustomForm::class, 'custom_form_id');
    }
}
