# Prisma Live Builder Blueprint

## Overview
Prisma Live Builder is a high-fidelity, real-time editing interface for managing page content. It allows for seamless customization of sections, colors, typography, and specific package details while maintaining a professional medical laboratory aesthetic.

## Implementation Details

### Current State
- **Backend:** Laravel 12 with Filament v3.
- **Frontend:** Blade templates with Alpine.js and Tailwind CSS (or Cairo/Tajawal fonts).
- **Core Models:** `Page`, `Package`, `SiteSettings`.
- **Views:** Dedicated layouts in `resources/views/components/layouts`.

### Live Builder Features
- [ ] Real-time CSS variable manipulation for colors.
- [ ] Text and image live editing.
- [ ] Section reordering and visibility toggles.
- [ ] Responsive preview for mobile, tablet, and desktop.

### Design System (High-Fidelity)
- **Primary Palette:**
    - `Primary Teal`: `#00A0B0` (Action buttons, badges)
    - `Royal Blue`: `#1A365D` (Headings, primary text)
    - `Vibrant Purple`: `#6366F1` (Special accent buttons, carousels)
    - `Surface Gray`: `#F8FAFC` (Section backgrounds)
- **Typography:**
    - `Cairo`: Bold (800+) for headings, Regular (400) for body.
    - `Tajawal`: For secondary UI elements.
- **Visual Effects:**
    - `Soft Glow`: `0 8px 30px rgba(0, 160, 176, 0.15)`
    - `Deep Lift`: `0 20px 50px rgba(0, 0, 0, 0.08)`
    - `Gradient`: `linear-gradient(135deg, #00A0B0 0%, #2D9CDB 100%)`
- **Layout Principles:**
    - `RTL First`: All layout elements must support RTL properly.
    - `Spacing`: Generous 80px-120px vertical padding between main sections.
    - `Cards`: Rounded corners (16px+), subtle borders (`1px solid #E2E8F0`).

### Live Builder Blocks Library
1.  **High-Fidelity Hero**: Large image with gradient overlay, floating category cards.
2.  **Package Carousel**: Segmented prices (99, 199, 299) with horizontal scrolling.
3.  **Service Grid**: Clean icons with soft backgrounds.
4.  **Interactive FAQ**: Minimalist accordion with primary color highlights.
5.  **CTA Banner**: Vibrant gradient background with stark white text.
