<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('packages', function (Blueprint $table) {
            // Bilingual translation columns
            $table->json('name_translations')->nullable()->after('name');
            $table->json('description_translations')->nullable()->after('description');
            $table->json('short_description_translations')->nullable()->after('short_description');
            $table->json('preparation_instructions_translations')->nullable()->after('preparation_instructions');
            $table->json('badge_text_translations')->nullable()->after('badge_text');
            $table->json('meta_title_translations')->nullable()->after('meta_title');
            $table->json('meta_description_translations')->nullable()->after('meta_description');

            // Additional package info
            $table->string('sample_type')->nullable()->after('estimated_time');
            $table->string('collection_method')->nullable()->after('sample_type');
            $table->text('fasting_instructions')->nullable()->after('collection_method');
            $table->json('fasting_instructions_translations')->nullable()->after('fasting_instructions');

            // Draft / Preview
            $table->boolean('is_draft')->default(false)->after('is_featured');
            $table->json('draft_content')->nullable()->after('is_draft');
        });
    }

    public function down(): void
    {
        Schema::table('packages', function (Blueprint $table) {
            $table->dropColumn([
                'name_translations',
                'description_translations',
                'short_description_translations',
                'preparation_instructions_translations',
                'badge_text_translations',
                'meta_title_translations',
                'meta_description_translations',
                'sample_type',
                'collection_method',
                'fasting_instructions',
                'fasting_instructions_translations',
                'is_draft',
                'draft_content',
            ]);
        });
    }
};
