<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('custom_forms', function (Blueprint $table) {
            $table->json('name_translations')->nullable()->after('name');
            $table->json('success_message_translations')->nullable()->after('success_message');
            $table->json('submit_button_text_translations')->nullable()->after('submit_button_text');
            $table->json('fields_translations')->nullable()->after('fields');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('custom_forms', function (Blueprint $table) {
            $table->dropColumn([
                'name_translations',
                'success_message_translations',
                'submit_button_text_translations',
                'fields_translations',
            ]);
        });
    }
};
