<?php

namespace Database\Seeders;

use App\Models\Package;
use App\Models\Test;
use Illuminate\Database\Seeder;

class PackageSeeder extends Seeder
{
    public function run(): void
    {
        // Create some tests
        $tests = [
            ['name' => 'Complete Blood Count (CBC)', 'code' => 'CBC-001', 'price' => 50],
            ['name' => 'Lipid Profile', 'code' => 'LIP-001', 'price' => 80],
            ['name' => 'Liver Function Test', 'code' => 'LFT-001', 'price' => 90],
            ['name' => 'Kidney Function Test', 'code' => 'KFT-001', 'price' => 85],
            ['name' => 'Thyroid Profile', 'code' => 'THY-001', 'price' => 100],
            ['name' => 'Blood Sugar (Fasting)', 'code' => 'GLU-001', 'price' => 30],
            ['name' => 'HbA1c', 'code' => 'HBA-001', 'price' => 60],
            ['name' => 'Vitamin D', 'code' => 'VIT-D-001', 'price' => 120],
            ['name' => 'Vitamin B12', 'code' => 'VIT-B12-001', 'price' => 100],
            ['name' => 'Iron Profile', 'code' => 'IRN-001', 'price' => 75],
        ];

        foreach ($tests as $testData) {
            Test::firstOrCreate(
                ['slug' => \Illuminate\Support\Str::slug($testData['name'])],
                [
                    'name' => $testData['name'],
                    'code' => $testData['code'],
                    'price' => $testData['price'],
                    'is_active' => true,
                ]
            );
        }

        // Create packages
        $packages = [
            [
                'name' => 'Basic Health Checkup',
                'short_description' => 'Essential tests for a basic health assessment including CBC, blood sugar, and lipid profile.',
                'description' => '<p>Our Basic Health Checkup package includes essential tests to assess your overall health status. This package is perfect for routine health monitoring.</p>',
                'price' => 199,
                'sale_price' => 149,
                'is_featured' => true,
                'badge_text' => 'الأكثر مبيعاً',
                'features' => [
                    ['feature' => 'Complete Blood Count (CBC)'],
                    ['feature' => 'Blood Sugar (Fasting)'],
                    ['feature' => 'Lipid Profile'],
                    ['feature' => 'Free Home Collection'],
                ],
                'tests' => ['Complete Blood Count (CBC)', 'Blood Sugar (Fasting)', 'Lipid Profile'],
            ],
            [
                'name' => 'Comprehensive Health Panel',
                'short_description' => 'Complete health assessment with liver, kidney, thyroid, and vitamin tests.',
                'description' => '<p>The Comprehensive Health Panel provides a detailed analysis of your health, covering all major organ functions and essential vitamins.</p>',
                'price' => 499,
                'sale_price' => 399,
                'is_featured' => true,
                'features' => [
                    ['feature' => 'Complete Blood Count (CBC)'],
                    ['feature' => 'Liver Function Test'],
                    ['feature' => 'Kidney Function Test'],
                    ['feature' => 'Thyroid Profile'],
                    ['feature' => 'Lipid Profile'],
                    ['feature' => 'Free Home Collection'],
                    ['feature' => 'Free Diet Consultation'],
                ],
                'tests' => ['Complete Blood Count (CBC)', 'Liver Function Test', 'Kidney Function Test', 'Thyroid Profile', 'Lipid Profile'],
            ],
            [
                'name' => 'Diabetes Screening',
                'short_description' => 'Complete diabetes screening package including HbA1c and blood sugar tests.',
                'description' => '<p>Early detection of diabetes is crucial. This package includes all essential tests for diabetes screening and monitoring.</p>',
                'price' => 150,
                'sale_price' => null,
                'is_featured' => false,
                'features' => [
                    ['feature' => 'Blood Sugar (Fasting)'],
                    ['feature' => 'HbA1c'],
                    ['feature' => 'Complete Blood Count (CBC)'],
                ],
                'tests' => ['Blood Sugar (Fasting)', 'HbA1c', 'Complete Blood Count (CBC)'],
            ],
            [
                'name' => 'Vitamin Profile',
                'short_description' => 'Complete vitamin assessment including Vitamin D and B12 levels.',
                'description' => '<p>Check your vitamin levels with our comprehensive vitamin profile. Essential for those experiencing fatigue or weakness.</p>',
                'price' => 280,
                'sale_price' => 220,
                'is_featured' => true,
                'features' => [
                    ['feature' => 'Vitamin D Level'],
                    ['feature' => 'Vitamin B12 Level'],
                    ['feature' => 'Iron Profile'],
                    ['feature' => 'Complete Blood Count (CBC)'],
                ],
                'tests' => ['Vitamin D', 'Vitamin B12', 'Iron Profile', 'Complete Blood Count (CBC)'],
            ],
            [
                'name' => 'Women\'s Health Package',
                'short_description' => 'Comprehensive health screening designed specifically for women.',
                'description' => '<p>A specialized package designed for women\'s health needs, including thyroid, iron, and vitamin assessments.</p>',
                'price' => 450,
                'sale_price' => 349,
                'is_featured' => true,
                'features' => [
                    ['feature' => 'Thyroid Profile'],
                    ['feature' => 'Iron Profile'],
                    ['feature' => 'Vitamin D & B12'],
                    ['feature' => 'Complete Blood Count'],
                    ['feature' => 'Free Consultation'],
                ],
                'tests' => ['Thyroid Profile', 'Iron Profile', 'Vitamin D', 'Vitamin B12', 'Complete Blood Count (CBC)'],
            ],
            [
                'name' => 'Men\'s Health Package',
                'short_description' => 'Comprehensive health screening designed specifically for men.',
                'description' => '<p>A specialized package designed for men\'s health needs, focusing on cardiovascular and metabolic health.</p>',
                'price' => 450,
                'sale_price' => 349,
                'is_featured' => false,
                'features' => [
                    ['feature' => 'Lipid Profile'],
                    ['feature' => 'Liver Function Test'],
                    ['feature' => 'Kidney Function Test'],
                    ['feature' => 'Complete Blood Count'],
                    ['feature' => 'Free Consultation'],
                ],
                'tests' => ['Lipid Profile', 'Liver Function Test', 'Kidney Function Test', 'Complete Blood Count (CBC)'],
            ],
        ];

        foreach ($packages as $index => $packageData) {
            $testNames = $packageData['tests'] ?? [];
            unset($packageData['tests']);
            
            $packageData['slug'] = \Illuminate\Support\Str::slug($packageData['name']);
            $packageData['is_active'] = true;
            $packageData['sort_order'] = $index;
            
            $package = Package::firstOrCreate(
                ['slug' => $packageData['slug']],
                $packageData
            );
            
            // Attach tests
            $testIds = Test::whereIn('name', $testNames)->pluck('id');
            $package->tests()->sync($testIds);
        }

        $this->command->info('Packages seeded successfully!');
    }
}
