@props([
    'data' => []
])

@php

    $title = $data['title'] ?? "";
    $description = $data['description'] ?? "";
    $customFormId = $data['custom_form_id'] ?? null;
@endphp

@if($customFormId)
    <section class="py-16 bg-gray-50/50">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            @if($title || $description)
                <div class="text-center max-w-2xl mx-auto mb-12">
                    @if($title)
                        <h2 class="text-3xl font-extrabold text-gray-900 tracking-tight sm:text-4xl mb-4">
                            {{ $title }}
                        </h2>
                    @endif
                    @if($description)
                        <p class="text-lg text-gray-600">
                            {{ $description }}
                        </p>
                    @endif
                </div>
            @endif

            <div class="mt-8">
                @livewire('custom-form-widget', ['formId' => $customFormId])
            </div>
        </div>
    </section>
@endif
