<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}" dir="{{ $siteSettings->direction ?? 'rtl' }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    {{-- Dynamic Meta Tags --}}
    <title>@yield('title', $siteSettings->meta_title)</title>
    <meta name="description" content="@yield('description', $siteSettings->meta_description)">
    <meta name="keywords" content="@yield('keywords', is_array($siteSettings->meta_keywords) ? implode(', ', $siteSettings->meta_keywords) : $siteSettings->meta_keywords)">
    <meta name="robots" content="index, follow">
    <meta name="author" content="{{ $siteSettings->site_name }}">
    
    {{-- Open Graph --}}
    <meta property="og:title" content="@yield('title', $siteSettings->meta_title)">
    <meta property="og:description" content="@yield('description', $siteSettings->meta_description)">
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ url()->current() }}">
    <meta property="og:image" content="{{ $siteSettings->logo_light ? asset('storage/' . $siteSettings->logo_light) : '' }}">
    
    {{-- Twitter Card --}}
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="@yield('title', $siteSettings->meta_title)">
    <meta name="twitter:description" content="@yield('description', $siteSettings->meta_description)">
    
    {{-- Favicon --}}
    @if($siteSettings->favicon)
        <link rel="icon" type="image/x-icon" href="{{ asset('storage/' . $siteSettings->favicon) }}">
    @endif
    
    {{-- Google Fonts --}}
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family={{ urlencode($siteSettings->font_family ?? 'Cairo') }}:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    
    {{-- Font Awesome --}}
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    {{-- Tailwind CSS --}}
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '{{ $siteSettings->color_primary ?? '#1A365D' }}',
                        secondary: '{{ $siteSettings->color_secondary ?? '#00A0B0' }}',
                        accent: '{{ $siteSettings->color_accent ?? '#2D9CDB' }}',
                        light: '{{ $siteSettings->color_light ?? '#F8FAFC' }}',
                        text: '{{ $siteSettings->color_text ?? '#334155' }}',
                    },
                    fontFamily: {
                        sans: ['{{ $siteSettings->font_family ?? 'Cairo' }}', 'sans-serif'],
                        heading: ['{{ $siteSettings->font_heading ?? 'Cairo' }}', 'sans-serif'],
                    },
                },
            },
        }
    </script>
    
    {{-- Custom CSS Variables --}}
    <style>
        :root {
            --pr-primary: {{ $siteSettings->color_primary ?? '#1A365D' }};
            --pr-secondary: {{ $siteSettings->color_secondary ?? '#00A0B0' }};
            --pr-accent: {{ $siteSettings->color_accent ?? '#2D9CDB' }};
            --pr-light: {{ $siteSettings->color_light ?? '#F8FAFC' }};
            --pr-text: {{ $siteSettings->color_text ?? '#334155' }};
            --pr-white: #ffffff;
            --pr-gray: #E8ECF1;
            --pr-radius: 12px;
            --pr-radius-lg: 16px;
            --pr-shadow: 0 4px 20px rgba(26, 54, 93, 0.08);
            --pr-shadow-card: 0 8px 32px rgba(26, 54, 93, 0.08);
            --pr-gradient: linear-gradient(135deg, {{ $siteSettings->color_secondary ?? '#00A0B0' }} 0%, {{ $siteSettings->color_accent ?? '#2D9CDB' }} 100%);
            --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            --header-height: 70px;
        }
        
        * { 
            box-sizing: border-box; 
            margin: 0; 
            padding: 0; 
            outline: none; 
            scroll-behavior: smooth; 
        }
        
        body {
            font-family: '{{ $siteSettings->font_family ?? 'Cairo' }}', sans-serif;
            background: linear-gradient(180deg, #F8FAFC 0%, var(--pr-light) 20%, #EEF2F7 100%);
            background-attachment: fixed;
            color: var(--pr-text);
            overflow-x: hidden;
            padding-top: var(--header-height);
            font-size: {{ $siteSettings->base_size ?? 16 }}px;
        }
        
        h1, h2, h3, h4, h5, h6 {
            font-family: '{{ $siteSettings->font_heading ?? 'Cairo' }}', sans-serif;
        }
        
        .text-gradient {
            background: var(--pr-gradient);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .bg-gradient {
            background: var(--pr-gradient);
        }
        
        .btn-primary {
            background: var(--pr-gradient);
            color: white;
            padding: 12px 24px;
            border-radius: 50px;
            font-weight: 700;
            transition: var(--transition);
            border: none;
            cursor: pointer;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            text-decoration: none;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 24px rgba(0, 160, 176, 0.4);
            color: white;
        }
        
        .section-title {
            font-size: 1.5rem;
            font-weight: 800;
            color: var(--pr-primary);
            margin-bottom: 18px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .section-title i {
            color: var(--pr-secondary);
        }
    </style>
    
    {{-- Analytics --}}
    @if($siteSettings->google_analytics)
        {!! $siteSettings->google_analytics !!}
    @endif
    @if($siteSettings->facebook_pixel)
        {!! $siteSettings->facebook_pixel !!}
    @endif
    
    @stack('styles')
</head>
<body>
    {{-- Header --}}
    <x-layouts.partials.header />
    
    {{-- Main Content --}}
    <main>
        {{ $slot }}
    </main>
    
    {{-- Footer --}}
    <x-layouts.partials.footer />
    
    {{-- Scripts --}}
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    @stack('scripts')
</body>
</html>
