<x-layouts.app>
    @section('title', $siteSettings->hero_title ?? $siteSettings->site_name)
    @section('description', $siteSettings->hero_subtitle ?? $siteSettings->meta_description)

    {{-- Hero Section --}}
    @if($siteSettings->show_hero)
    <section class="hero" style="min-height: 550px; background: linear-gradient(180deg, #0a0a0a 0%, rgba(10,10,10,0.95) 100%); position: relative; display: flex; align-items: center; justify-content: center; text-align: center; padding: 40px 20px;">
        {{-- Background Pattern --}}
        <div style="position: absolute; inset: 0; opacity: 0.05; background-image: url('data:image/svg+xml,%3Csvg width=\"60\" height=\"60\" viewBox=\"0 0 60 60\" xmlns=\"http://www.w3.org/2000/svg\"%3E%3Cg fill=\"none\" fill-rule=\"evenodd\"%3E%3Cg fill=\"%23ffffff\" fill-opacity=\"0.4\"%3E%3Cpath d=\"M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z\"/%3E%3C/g%3E%3C/g%3E%3C/svg%3E');"></div>
        
        <div class="hero-content" style="max-width: 700px; z-index: 1;">
            <h1 style="font-size: 2.8rem; font-weight: 900; color: white; margin-bottom: 12px; font-family: 'Cairo', sans-serif; line-height: 1.3;">
                {{ $siteSettings->hero_title ?? 'صحتك تبدأ بفحص دقيق' }}
            </h1>
            <p style="color: rgba(255,255,255,0.85); font-size: 1.1rem; line-height: 1.8; margin-bottom: 30px; max-width: 600px;">
                {{ $siteSettings->hero_subtitle ?? 'نتائج موثوقة خلال 24 ساعة مع خدمة السحب المنزلي المجانية' }}
            </p>
            <a href="{{ $siteSettings->hero_cta_url ?? '#packages' }}" class="btn-primary" style="padding: 16px 40px; font-size: 1.1rem; box-shadow: 0 8px 32px rgba(0, 160, 176, 0.4);">
                <i class="fas fa-calendar-check"></i>
                {{ $siteSettings->hero_cta_text ?? 'احجز الآن' }}
            </a>
        </div>
        
        {{-- Decorative Elements --}}
        <div style="position: absolute; bottom: -1px; left: 0; right: 0; height: 100px; background: linear-gradient(to top, var(--pr-light), transparent);"></div>
    </section>
    @endif

    {{-- Categories Section --}}
    @if($siteSettings->show_categories && $categories->count() > 0)
    <section class="categories" style="padding: 30px 20px; max-width: 1000px; margin: -50px auto 0; position: relative; z-index: 10;">
        <div style="background: white; border-radius: var(--pr-radius-lg); box-shadow: var(--pr-shadow-card); padding: 24px 28px; display: grid; grid-template-columns: repeat(auto-fit, minmax(100px, 1fr)); gap: 16px; justify-items: center;">
            @foreach($categories as $category)
                <a href="{{ route('packages.index', ['category' => $category->slug]) }}" class="category-item" style="display: flex; flex-direction: column; align-items: center; gap: 10px; text-decoration: none; padding: 12px; transition: var(--transition); border-radius: 12px; min-width: 90px;">
                    <div style="width: 52px; height: 52px; border-radius: 50%; background: linear-gradient(135deg, {{ $siteSettings->color_secondary }} 0%, {{ $siteSettings->color_accent }} 100%); display: flex; align-items: center; justify-content: center; font-size: 1.3rem; color: white; box-shadow: 0 4px 15px rgba(0, 160, 176, 0.3); transition: var(--transition);">
                        <i class="{{ $category->icon ?? 'fas fa-flask' }}"></i>
                    </div>
                    <span style="font-size: 0.75rem; color: var(--pr-primary); font-weight: 700; text-align: center;">{{ $category->name }}</span>
                </a>
            @endforeach
        </div>
    </section>
    @endif

    {{-- Packages Section by Price Tiers --}}
    @if($siteSettings->show_packages_99)
    <section class="packages-section" style="max-width: 1200px; margin: 0 auto; padding: 50px 20px;" id="packages">
        {{-- Promo Header --}}
        <div style="text-align: center; margin-bottom: 30px;">
            <div style="display: inline-block; background: rgba(0, 160, 176, 0.1); color: var(--pr-secondary); padding: 6px 16px; border-radius: 50px; font-size: 0.9rem; font-weight: 700; margin-bottom: 12px;">
                <i class="fas fa-percentage" style="margin-left: 5px;"></i>
                {{ $siteSettings->promo_badge_text ?? 'عروض الموسم المميزة' }}
            </div>
            <h2 style="font-size: 1.8rem; font-weight: 900; color: var(--pr-primary); margin-bottom: 8px; font-family: 'Cairo', sans-serif;">
                {{ $siteSettings->promo_title ?? 'باقات مختبرات بريزما' }}
            </h2>
            <p style="color: var(--pr-text); font-size: 1rem;">{{ $siteSettings->promo_subtitle ?? 'استفد من عرض: اختر باقتين واحصل على الثالثة مجاناً!' }}</p>
        </div>
        
        {{-- Tabs for Price Tiers --}}
        <div class="price-tabs" x-data="{ activeTab: 'tier-99' }" style="margin-bottom: 30px;">
            <div style="display: flex; justify-content: center; gap: 12px; flex-wrap: wrap; margin-bottom: 30px;">
                @if($siteSettings->show_packages_99)
                <button @click="activeTab = 'tier-99'" 
                        :style="activeTab === 'tier-99' ? 'background: linear-gradient(135deg, ' + '{{ $siteSettings->color_secondary }}' + ' 0%, ' + '{{ $siteSettings->color_accent }}' + ' 100%); color: white; box-shadow: 0 8px 24px rgba(0, 160, 176, 0.4);' : 'background: white; color: var(--pr-primary); border: 2px solid var(--pr-gray);'"
                        style="padding: 12px 28px; border-radius: 50px; font-weight: 700; font-size: 0.95rem; transition: var(--transition); cursor: pointer; border: none;">
                    <i class="fas fa-star" style="margin-left: 8px;"></i>
                    باقات 99 ريال
                </button>
                @endif
                @if($siteSettings->show_packages_199)
                <button @click="activeTab = 'tier-199'" 
                        :style="activeTab === 'tier-199' ? 'background: linear-gradient(135deg, ' + '{{ $siteSettings->color_secondary }}' + ' 0%, ' + '{{ $siteSettings->color_accent }}' + ' 100%); color: white; box-shadow: 0 8px 24px rgba(0, 160, 176, 0.4);' : 'background: white; color: var(--pr-primary); border: 2px solid var(--pr-gray);'"
                        style="padding: 12px 28px; border-radius: 50px; font-weight: 700; font-size: 0.95rem; transition: var(--transition); cursor: pointer; border: none;">
                    <i class="fas fa-gem" style="margin-left: 8px;"></i>
                    باقات 199 ريال
                </button>
                @endif
                @if($siteSettings->show_packages_299)
                <button @click="activeTab = 'tier-299'" 
                        :style="activeTab === 'tier-299' ? 'background: linear-gradient(135deg, ' + '{{ $siteSettings->color_secondary }}' + ' 0%, ' + '{{ $siteSettings->color_accent }}' + ' 100%); color: white; box-shadow: 0 8px 24px rgba(0, 160, 176, 0.4);' : 'background: white; color: var(--pr-primary); border: 2px solid var(--pr-gray);'"
                        style="padding: 12px 28px; border-radius: 50px; font-weight: 700; font-size: 0.95rem; transition: var(--transition); cursor: pointer; border: none;">
                    <i class="fas fa-crown" style="margin-left: 8px;"></i>
                    باقات 299 ريال
                </button>
                @endif
            </div>
            
            {{-- Package Cards --}}
            @if($packages_99 && $packages_99->count() > 0)
            <div x-show="activeTab === 'tier-99'" x-transition style="display: grid; grid-template-columns: repeat(auto-fit, minmax(320px, 1fr)); gap: 24px;">
                @foreach($packages_99 as $package)
                    @include('partials.package-card', ['package' => $package])
                @endforeach
            </div>
            @endif
            
            @if($packages_199 && $packages_199->count() > 0)
            <div x-show="activeTab === 'tier-199'" x-transition style="display: none;">
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(320px, 1fr)); gap: 24px;">
                    @foreach($packages_199 as $package)
                        @include('partials.package-card', ['package' => $package])
                    @endforeach
                </div>
            </div>
            @endif
            
            @if($packages_299 && $packages_299->count() > 0)
            <div x-show="activeTab === 'tier-299'" x-transition style="display: none;">
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(320px, 1fr)); gap: 24px;">
                    @foreach($packages_299 as $package)
                        @include('partials.package-card', ['package' => $package])
                    @endforeach
                </div>
            </div>
            @endif
        </div>
    </section>
    @endif

    {{-- About Section --}}
    @if($siteSettings->show_about)
    <section class="about-section" id="about" style="background: linear-gradient(135deg, rgba(26, 54, 93, 0.03) 0%, rgba(0, 160, 176, 0.05) 100%); padding: 60px 20px;">
        <div style="max-width: 1200px; margin: 0 auto; display: grid; grid-template-columns: 1fr 1fr; gap: 50px; align-items: center;">
            <div class="about-content">
                <div style="font-size: 1.8rem; font-weight: 800; color: var(--pr-primary); margin-bottom: 18px; display: flex; align-items: center; gap: 10px;">
                    <i class="fas fa-info-circle" style="color: var(--pr-secondary);"></i>
                    {{ $siteSettings->about_title ?? 'مختبرات بريزما الطبية' }}
                </div>
                <p style="font-size: 1.1rem; line-height: 1.9; color: var(--pr-text); margin-bottom: 24px;">
                    {{ $siteSettings->about_description ?? 'مختبرات بريزما الطبية هي مختبر تحاليل معتمد يقدّم خدمات مخبرية متكاملة باستخدام أحدث الأجهزة الطبية، وبإشراف نخبة من المختصين، مع الالتزام بأعلى معايير الجودة والدقة.' }}
                </p>
                <div style="display: flex; gap: 20px; flex-wrap: wrap;">
                    <a href="{{ route('packages.index') }}" class="btn-primary" style="padding: 14px 32px;">
                        <i class="fas fa-flask"></i>
                        اكتشف الباقات
                    </a>
                    <a href="tel:{{ $siteSettings->contact_phone }}" style="padding: 14px 32px; border: 2px solid var(--pr-primary); color: var(--pr-primary); border-radius: 50px; font-weight: 700; transition: var(--transition); text-decoration: none; display: inline-flex; align-items: center; gap: 8px;">
                        <i class="fas fa-phone"></i>
                        اتصل بنا
                    </a>
                </div>
            </div>
            <div class="about-image" style="position: relative;">
                @if($siteSettings->about_image)
                    <img src="{{ asset('storage/' . $siteSettings->about_image) }}" alt="{{ $siteSettings->site_name }}" style="width: 100%; max-width: 500px; height: auto; border-radius: var(--pr-radius-lg); box-shadow: var(--pr-shadow-card);">
                @else
                    <div style="width: 100%; max-width: 500px; aspect-ratio: 4/3; background: linear-gradient(135deg, var(--pr-secondary) 0%, var(--pr-accent) 100%); border-radius: var(--pr-radius-lg); display: flex; align-items: center; justify-content: center; box-shadow: var(--pr-shadow-card);">
                        <i class="fas fa-microscope" style="font-size: 6rem; color: white; opacity: 0.9;"></i>
                    </div>
                @endif
                {{-- Stats Badge --}}
                @if($siteSettings->show_stats)
                <div style="position: absolute; bottom: -20px; left: -20px; background: white; padding: 20px 30px; border-radius: var(--pr-radius-lg); box-shadow: var(--pr-shadow-card); display: flex; gap: 30px;">
                    <div style="text-align: center;">
                        <div style="font-size: 1.8rem; font-weight: 800; background: var(--pr-gradient); -webkit-background-clip: text; -webkit-text-fill-color: transparent;">{{ $siteSettings->stat_1_value ?? '24' }}</div>
                        <div style="font-size: 0.85rem; color: var(--pr-text);">{{ $siteSettings->stat_1_label ?? 'ساعة نتائج' }}</div>
                    </div>
                    <div style="text-align: center;">
                        <div style="font-size: 1.8rem; font-weight: 800; background: var(--pr-gradient); -webkit-background-clip: text; -webkit-text-fill-color: transparent;">{{ $siteSettings->stat_2_value ?? '100%' }}</div>
                        <div style="font-size: 0.85rem; color: var(--pr-text);">{{ $siteSettings->stat_2_label ?? 'معتمد' }}</div>
                    </div>
                    <div style="text-align: center;">
                        <div style="font-size: 1.8rem; font-weight: 800; background: var(--pr-gradient); -webkit-background-clip: text; -webkit-text-fill-color: transparent;">{{ $siteSettings->stat_3_value ?? 'مجاناً' }}</div>
                        <div style="font-size: 0.85rem; color: var(--pr-text);">{{ $siteSettings->stat_3_label ?? 'السحب المنزلي' }}</div>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </section>
    @endif

    {{-- Services Section --}}
    @if($siteSettings->show_services)
    <section class="services-section" id="services" style="padding: 60px 20px; max-width: 1200px; margin: 0 auto;">
        <div style="text-align: center; margin-bottom: 40px;">
            <h2 class="section-title" style="justify-content: center; font-size: 1.8rem;">
                <i class="fas fa-hand-holding-heart"></i>
                خدماتنا المميزة
            </h2>
            <p style="color: var(--pr-text); max-width: 500px; margin: 0 auto;">نقدم لك مجموعة متكاملة من الخدمات المخبرية بأعلى معايير الجودة</p>
        </div>
        
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 24px;">
            {{-- Service 1 --}}
            <div class="service-card" style="background: white; padding: 30px; border-radius: var(--pr-radius-lg); text-align: center; transition: var(--transition); border: 1px solid rgba(0, 160, 176, 0.1);">
                <div style="width: 70px; height: 70px; margin: 0 auto 20px; border-radius: 50%; background: linear-gradient(135deg, {{ $siteSettings->color_secondary }} 0%, {{ $siteSettings->color_accent }} 100%); display: flex; align-items: center; justify-content: center; font-size: 1.5rem; color: white;">
                    <i class="fas fa-flask"></i>
                </div>
                <h3 style="font-size: 1.2rem; font-weight: 800; color: var(--pr-primary); margin-bottom: 12px;">تحاليل الدم الشاملة</h3>
                <p style="color: var(--pr-text); line-height: 1.7;">فحوصات دم دقيقة تشمل جميع المؤشرات الحيوية مع تقارير مفصلة</p>
            </div>
            
            {{-- Service 2 --}}
            <div class="service-card" style="background: white; padding: 30px; border-radius: var(--pr-radius-lg); text-align: center; transition: var(--transition); border: 1px solid rgba(0, 160, 176, 0.1);">
                <div style="width: 70px; height: 70px; margin: 0 auto 20px; border-radius: 50%; background: linear-gradient(135deg, {{ $siteSettings->color_secondary }} 0%, {{ $siteSettings->color_accent }} 100%); display: flex; align-items: center; justify-content: center; font-size: 1.5rem; color: white;">
                    <i class="fas fa-vial"></i>
                </div>
                <h3 style="font-size: 1.2rem; font-weight: 800; color: var(--pr-primary); margin-bottom: 12px;">تحاليل البول والبراز</h3>
                <p style="color: var(--pr-text); line-height: 1.7;">تحاليل دقيقة للكشف عن الأمراض والالتهابات والأملاح</p>
            </div>
            
            {{-- Service 3 --}}
            <div class="service-card" style="background: white; padding: 30px; border-radius: var(--pr-radius-lg); text-align: center; transition: var(--transition); border: 1px solid rgba(0, 160, 176, 0.1);">
                <div style="width: 70px; height: 70px; margin: 0 auto 20px; border-radius: 50%; background: linear-gradient(135deg, {{ $siteSettings->color_secondary }} 0%, {{ $siteSettings->color_accent }} 100%); display: flex; align-items: center; justify-content: center; font-size: 1.5rem; color: white;">
                    <i class="fas fa-baby"></i>
                </div>
                <h3 style="font-size: 1.2rem; font-weight: 800; color: var(--pr-primary); margin-bottom: 12px;">تحاليل الأجسام المضادة</h3>
                <p style="color: var(--pr-text); line-height: 1.7;">فحص شامل لمناعة الجسم والأجسام المضادة لمختلف الأمراض</p>
            </div>
            
            {{-- Service 4 --}}
            <div class="service-card" style="background: white; padding: 30px; border-radius: var(--pr-radius-lg); text-align: center; transition: var(--transition); border: 1px solid rgba(0, 160, 176, 0.1);">
                <div style="width: 70px; height: 70px; margin: 0 auto 20px; border-radius: 50%; background: linear-gradient(135deg, {{ $siteSettings->color_secondary }} 0%, {{ $siteSettings->color_accent }} 100%); display: flex; align-items: center; justify-content: center; font-size: 1.5rem; color: white;">
                    <i class="fas fa-home"></i>
                </div>
                <h3 style="font-size: 1.2rem; font-weight: 800; color: var(--pr-primary); margin-bottom: 12px;">سحب منزلي مجاني</h3>
                <p style="color: var(--pr-text); line-height: 1.7;">نأتيك أينما كنت داخل المدينة مع خدمة سحب عينات مجانية</p>
            </div>
        </div>
    </section>
    @endif

    {{-- FAQ Section --}}
    @if($siteSettings->show_faq)
    <section class="faq-section" id="faq" style="padding: 60px 20px; background: linear-gradient(135deg, rgba(26, 54, 93, 0.02) 0%, rgba(0, 160, 176, 0.03) 100%);">
        <div style="max-width: 800px; margin: 0 auto;">
            <div style="text-align: center; margin-bottom: 40px;">
                <h2 class="section-title" style="justify-content: center; font-size: 1.8rem;">
                    <i class="fas fa-question-circle"></i>
                    الأسئلة الشائعة
                </h2>
            </div>
            
            <div x-data="{ openFaq: 1 }" style="display: flex; flex-direction: column; gap: 16px;">
                {{-- FAQ 1 --}}
                <div class="faq-item" style="background: white; border-radius: var(--pr-radius-lg); box-shadow: var(--pr-shadow); overflow: hidden;">
                    <button @click="openFaq = openFaq === 1 ? null : 1" style="width: 100%; padding: 20px 24px; text-align: right; border: none; background: none; cursor: pointer; display: flex; align-items: center; justify-content: space-between;">
                        <span style="font-weight: 700; color: var(--pr-primary); font-size: 1.05rem;">هل هناك تحضيرات خاصة قبل إجراء التحليل؟</span>
                        <i class="fas fa-chevron-down" :style="openFaq === 1 ? 'transform: rotate(180deg);' : ''" style="color: var(--pr-secondary); transition: var(--transition);"></i>
                    </button>
                    <div x-show="openFaq === 1" x-transition style="padding: 0 24px 20px; color: var(--pr-text); line-height: 1.8;">
                        في حالة تحليل السكر التراكمي، لا يوجد تحضيرات خاصة. أما التحاليل الأخرى قد تحتاج إلى صيام حسب نوع التحليل، وسنقوم بإبلاغك بالتعليمات عند الحجز.
                    </div>
                </div>
                
                {{-- FAQ 2 --}}
                <div class="faq-item" style="background: white; border-radius: var(--pr-radius-lg); box-shadow: var(--pr-shadow); overflow: hidden;">
                    <button @click="openFaq = openFaq === 2 ? null : 2" style="width: 100%; padding: 20px 24px; text-align: right; border: none; background: none; cursor: pointer; display: flex; align-items: center; justify-content: space-between;">
                        <span style="font-weight: 700; color: var(--pr-primary); font-size: 1.05rem;">هل يمكن إجراء التحليل في المنزل؟</span>
                        <i class="fas fa-chevron-down" :style="openFaq === 2 ? 'transform: rotate(180deg);' : ''" style="color: var(--pr-secondary); transition: var(--transition);"></i>
                    </button>
                    <div x-show="openFaq === 2" x-transition style="display: none; padding: 0 24px 20px; color: var(--pr-text); line-height: 1.8;">
                        نعم، نقدم خدمة السحب المنزلي المجانية داخل المدينة. سيصلك فريقنا المتخصص في الوقت المناسب لك.
                    </div>
                </div>
                
                {{-- FAQ 3 --}}
                <div class="faq-item" style="background: white; border-radius: var(--pr-radius-lg); box-shadow: var(--pr-shadow); overflow: hidden;">
                    <button @click="openFaq = openFaq === 3 ? null : 3" style="width: 100%; padding: 20px 24px; text-align: right; border: none; background: none; cursor: pointer; display: flex; align-items: center; justify-content: space-between;">
                        <span style="font-weight: 700; color: var(--pr-primary); font-size: 1.05rem;">هل التقارير معتمدة؟</span>
                        <i class="fas fa-chevron-down" :style="openFaq === 3 ? 'transform: rotate(180deg);' : ''" style="color: var(--pr-secondary); transition: var(--transition);"></i>
                    </button>
                    <div x-show="openFaq === 3" x-transition style="display: none; padding: 0 24px 20px; color: var(--pr-text); line-height: 1.8;">
                        نعم، جميع التقارير معتمدة من وزارة الصحة السعودية وتُرسل إلكترونياً فور اكتمالها.
                    </div>
                </div>
            </div>
        </div>
    </section>
    @endif

    {{-- CTA Section --}}
    <section class="cta-section" style="padding: 80px 20px; background: linear-gradient(135deg, {{ $siteSettings->color_secondary }} 0%, {{ $siteSettings->color_accent }} 100%); margin: 40px 20px; border-radius: var(--pr-radius-lg); text-align: center;">
        <h2 style="font-size: 2rem; font-weight: 900; color: white; margin-bottom: 16px; font-family: 'Cairo', sans-serif;">جاهز للحجز؟</h2>
        <p style="color: rgba(255,255,255,0.9); font-size: 1.1rem; margin-bottom: 30px;">احجز الآن واحصل على خصم 10% على أول تحليل لك</p>
        <a href="{{ $siteSettings->contact_whatsapp ? 'https://wa.me/' . $siteSettings->contact_whatsapp : route('packages.index') }}" class="btn-primary" style="background: white; color: var(--pr-primary); padding: 16px 40px; font-size: 1.1rem;">
            <i class="fab fa-whatsapp"></i>
            احجز عبر الواتساب
        </a>
    </section>

    <style>
        .category-item:hover {
            transform: translateY(-4px);
        }
        .category-item:hover > div:first-child {
            transform: scale(1.1);
        }
        .service-card:hover {
            transform: translateY(-8px);
            box-shadow: var(--pr-shadow-card);
        }
        @media (max-width: 768px) {
            .about-section > div {
                grid-template-columns: 1fr !important;
            }
            .hero h1 {
                font-size: 2rem !important;
            }
        }
    </style>
</x-layouts.app>
