<x-layouts.app>
    @section('title', __('packages_page_title') . ' - ' . ($siteSettings->site_name ?? 'مختبرات بريزما'))
    @section('description', __('packages_page_desc'))

    <style>
        :root {
            --pi-primary: #1A365D;
            --pi-secondary: #00A0B0;
            --pi-accent: #2D9CDB;
            --pi-gradient: linear-gradient(135deg, #1A365D 0%, #2D3748 60%, #00A0B0 100%);
            --pi-radius: 14px;
            --pi-shadow: 0 4px 20px rgba(0,0,0,0.08);
            --pi-shadow-card: 0 8px 32px rgba(0,0,0,0.06);
            --pi-transition: all 0.35s cubic-bezier(0.4, 0, 0.2, 1);
        }

        /* Hero */
        .pkg-idx-hero {
            background: var(--pi-gradient);
            padding: 56px 20px 48px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }
        .pkg-idx-hero::before {
            content: '';
            position: absolute;
            top: -40%;
            right: -10%;
            width: 500px;
            height: 500px;
            background: radial-gradient(circle, rgba(0,160,176,0.15) 0%, transparent 70%);
            border-radius: 50%;
        }
        .pkg-idx-hero h1 {
            font-family: 'Cairo', sans-serif;
            font-size: 2.5rem;
            font-weight: 800;
            color: white;
            margin-bottom: 12px;
            position: relative;
        }
        .pkg-idx-hero p {
            font-size: 1.15rem;
            color: rgba(255,255,255,0.88);
            max-width: 600px;
            margin: 0 auto 24px;
            line-height: 1.7;
        }
        .pkg-idx-hero nav {
            font-size: 0.9rem;
            color: rgba(255,255,255,0.7);
        }
        .pkg-idx-hero nav a {
            color: rgba(255,255,255,0.7);
            text-decoration: none;
            transition: color 0.2s;
        }
        .pkg-idx-hero nav a:hover { color: white; }

        /* Price Tier Tabs */
        .tier-tabs {
            display: flex;
            justify-content: center;
            gap: 8px;
            flex-wrap: wrap;
            padding: 24px 20px 0;
            max-width: 900px;
            margin: 0 auto;
        }
        .tier-tab {
            padding: 10px 22px;
            background: rgba(255,255,255,0.12);
            border: 1px solid rgba(255,255,255,0.2);
            border-radius: 50px;
            color: rgba(255,255,255,0.85);
            font-family: 'Cairo', sans-serif;
            font-size: 0.92rem;
            font-weight: 600;
            cursor: pointer;
            transition: var(--pi-transition);
            white-space: nowrap;
        }
        .tier-tab:hover {
            background: rgba(255,255,255,0.2);
            color: white;
        }
        .tier-tab.active {
            background: white;
            color: var(--pi-primary);
            border-color: white;
            box-shadow: 0 4px 16px rgba(0,0,0,0.15);
        }

        /* Packages Grid */
        .pkg-section {
            padding: 40px 20px 60px;
            background: #f5f7fa;
            min-height: 400px;
        }
        .pkg-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(340px, 1fr));
            gap: 24px;
            max-width: 1280px;
            margin: 0 auto;
        }
        @media (max-width: 768px) {
            .pkg-grid { grid-template-columns: 1fr; }
        }

        /* Package Card */
        .pkg-card {
            background: white;
            border-radius: var(--pi-radius);
            overflow: hidden;
            box-shadow: var(--pi-shadow-card);
            border: 1px solid #e8ecf1;
            transition: var(--pi-transition);
            display: flex;
            flex-direction: column;
        }
        .pkg-card:hover {
            transform: translateY(-6px);
            box-shadow: 0 16px 48px rgba(0,0,0,0.12);
            border-color: var(--pi-secondary);
        }

        .pkg-card-img {
            position: relative;
            height: 200px;
            overflow: hidden;
            background: linear-gradient(135deg, #e2e8f0, #f1f5f9);
        }
        .pkg-card-img img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.5s ease;
        }
        .pkg-card:hover .pkg-card-img img {
            transform: scale(1.08);
        }
        .pkg-card-img .fallback-icon {
            width: 100%;
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, #e8f4f8 0%, #dbeafe 100%);
        }
        .pkg-card-img .fallback-icon i {
            font-size: 3.5rem;
            color: var(--pi-secondary);
            opacity: 0.35;
        }

        /* Badges */
        .pkg-badge-row {
            position: absolute;
            top: 12px;
            left: 12px;
            right: 12px;
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            z-index: 2;
        }
        .badge-discount {
            background: linear-gradient(135deg, #ef4444, #dc2626);
            color: white;
            padding: 5px 14px;
            border-radius: 50px;
            font-size: 0.82rem;
            font-weight: 700;
            font-family: 'Cairo', sans-serif;
            box-shadow: 0 2px 8px rgba(239,68,68,0.3);
        }
        .badge-featured {
            background: linear-gradient(135deg, #f59e0b, #d97706);
            color: white;
            padding: 5px 12px;
            border-radius: 50px;
            font-size: 0.78rem;
            font-weight: 700;
            display: flex;
            align-items: center;
            gap: 4px;
        }
        .badge-tests {
            position: absolute;
            bottom: 12px;
            right: 12px;
            background: rgba(26,54,93,0.88);
            backdrop-filter: blur(6px);
            color: white;
            padding: 6px 14px;
            border-radius: 50px;
            font-size: 0.8rem;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 6px;
        }

        /* Card Body */
        .pkg-card-body {
            padding: 20px 22px;
            flex: 1;
            display: flex;
            flex-direction: column;
        }
        .pkg-card-body h3 {
            font-family: 'Cairo', sans-serif;
            font-size: 1.15rem;
            font-weight: 700;
            color: var(--pi-primary);
            margin-bottom: 8px;
            line-height: 1.4;
            transition: color 0.2s;
        }
        .pkg-card:hover .pkg-card-body h3 {
            color: var(--pi-secondary);
        }
        .pkg-card-body .desc {
            font-size: 0.92rem;
            color: #64748B;
            line-height: 1.6;
            margin-bottom: 16px;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }
        .pkg-card-features {
            margin-bottom: 16px;
            flex: 1;
        }
        .pkg-card-features li {
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 0.88rem;
            color: #475569;
            padding: 3px 0;
        }
        .pkg-card-features li i {
            color: #22c55e;
            font-size: 0.8rem;
            flex-shrink: 0;
        }
        .pkg-card-features .more {
            font-size: 0.8rem;
            color: #94a3b8;
            padding-right: 20px;
        }

        /* Card Footer */
        .pkg-card-footer {
            padding: 16px 22px 20px;
            border-top: 1px solid #f1f5f9;
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 12px;
        }
        .pkg-price-wrap { display: flex; flex-direction: column; }
        .pkg-price-old {
            font-size: 0.82rem;
            color: #94a3b8;
            text-decoration: line-through;
            font-family: 'Cairo', sans-serif;
        }
        .pkg-price-current {
            font-size: 1.5rem;
            font-weight: 800;
            color: var(--pi-primary);
            font-family: 'Cairo', sans-serif;
            line-height: 1;
        }
        .pkg-price-current .sar {
            font-size: 0.75rem;
            font-weight: 600;
            color: #64748B;
            margin-right: 4px;
        }

        .pkg-card-actions {
            display: flex;
            gap: 8px;
            align-items: center;
        }
        .btn-details {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            padding: 10px 20px;
            background: var(--pi-primary);
            color: white;
            border-radius: 50px;
            font-size: 0.88rem;
            font-weight: 600;
            font-family: 'Cairo', sans-serif;
            text-decoration: none;
            transition: var(--pi-transition);
            white-space: nowrap;
        }
        .btn-details:hover {
            background: var(--pi-secondary);
            color: white;
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(0,160,176,0.3);
        }
        .btn-book-sm {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 42px;
            height: 42px;
            background: #f0fdf4;
            color: #16a34a;
            border-radius: 50%;
            font-size: 1.1rem;
            text-decoration: none;
            transition: var(--pi-transition);
            border: 1px solid #bbf7d0;
        }
        .btn-book-sm:hover {
            background: #25D366;
            color: white;
            border-color: #25D366;
        }

        /* Empty State */
        .pkg-empty {
            text-align: center;
            padding: 60px 20px;
            max-width: 400px;
            margin: 0 auto;
        }
        .pkg-empty i { font-size: 4rem; color: #cbd5e1; margin-bottom: 20px; }
        .pkg-empty h3 { font-family: 'Cairo', sans-serif; color: var(--pi-primary); font-size: 1.3rem; margin-bottom: 8px; }
        .pkg-empty p { color: #94a3b8; font-size: 0.95rem; }
    </style>

    @php
        $siteSettings = app(\App\Settings\SiteSettings::class);
        $currencyType = $siteSettings->currency_type ?? 'text';
        $currencyText = $siteSettings->currency_text ?? 'ريال';
        $currencySvg = $siteSettings->currency_svg ?? '';
        $currencyImage = $siteSettings->currency_image ?? '';
        $currencyPos = $siteSettings->currency_position ?? 'after';
        $currencyIconSize = $siteSettings->currency_icon_size ?? 18;
        $priceColor = $siteSettings->price_tag_color ?? '#000000';

        $currencyHtml = '';
        if ($currencyType === 'text') {
            $currencyHtml = '<span class="currency-text">' . e($currencyText) . '</span>';
        } elseif ($currencyType === 'svg') {
            $currencyHtml = '<span class="currency-icon svg">' . $currencySvg . '</span>';
        } elseif ($currencyType === 'image' && $currencyImage) {
            $currencyHtml = '<img src="' . asset('storage/' . $currencyImage) . '" class="currency-icon img" alt="currency">';
        }
    @endphp

    <style>
        .currency-icon { display: inline-block !important; vertical-align: middle; width: {{ $currencyIconSize }}px !important; height: {{ $currencyIconSize }}px !important; min-width: {{ $currencyIconSize }}px !important; object-fit: contain; }
        .currency-icon.svg svg { width: {{ $currencyIconSize }}px !important; height: {{ $currencyIconSize }}px !important; fill: currentColor; display: block; }
        .currency-text { font-size: 0.9rem; opacity: 0.85; font-weight: 600; }
        .price-row { display: flex; align-items: center; gap: 8px; }
        .price-row.reverse { flex-direction: row-reverse; }
    </style>

    <div dir="rtl" style="font-family: 'Tajawal', 'Cairo', sans-serif;">
        {{-- Hero Section --}}
        <section class="pkg-idx-hero">
            <h1>{{ __('hero_title') }}</h1>
            <p>{{ __('hero_subtitle') }}</p>
            <nav>
                <a href="{{ route('home') }}">{{ __('home') }}</a>
                <span style="margin: 0 8px;">/</span>
                <span style="color: white;">{{ __('packages') }}</span>
            </nav>

            {{-- Price Tier Tabs --}}
            @if($priceTiers->count() > 1)
                <div class="tier-tabs">
                    @foreach($priceTiers as $index => $tier)
                        <button class="tier-tab {{ $index === 0 ? 'active' : '' }}"
                                data-tier="{{ $index }}"
                                onclick="filterTier({{ $index }})">
                            {{ app()->getLocale() == 'en' ? ($tier['label_en'] ?? $tier['label']) : $tier['label'] }}
                        </button>
                    @endforeach
                </div>
            @endif
        </section>

        {{-- Packages Grid --}}
        <section class="pkg-section">
            @if($packages->count() > 0)
                <div class="pkg-grid" id="packages-grid">
                    @foreach($packages as $package)
                        <div class="pkg-card" data-price="{{ $package->final_price }}">
                            {{-- Image --}}
                            <div class="pkg-card-img">
                                @if($package->image)
                                    <img src="{{ asset('storage/' . $package->image) }}" alt="{{ $package->translated_name }}" loading="lazy">
                                @else
                                    <div class="fallback-icon">
                                        <i class="fas fa-microscope"></i>
                                    </div>
                                @endif

                                {{-- Badges --}}
                                <div class="pkg-badge-row">
                                    @if($package->discount_percentage > 0)
                                        <span class="badge-discount">{{ __('discount_badge') }} {{ $package->discount_percentage }}%</span>
                                    @else
                                        <span></span>
                                    @endif

                                    @if($package->is_featured)
                                        <span class="badge-featured"><i class="fas fa-star"></i> {{ __('featured_badge') }}</span>
                                    @endif
                                </div>

                                {{-- Tests Count Badge --}}
                                @if($package->tests_count > 0)
                                    <span class="badge-tests"><i class="fas fa-vial"></i> {{ $package->tests_count }} {{ $package->tests_count == 1 ? __('test_count_single') : __('test_count_suffix') }}</span>
                                @endif
                            </div>

                            {{-- Body --}}
                            <div class="pkg-card-body">
                                <h3>{{ $package->translated_name }}</h3>
                                <p class="desc">{{ $package->translated_short_description ?? Str::limit(strip_tags($package->translated_description), 100) }}</p>

                                {{-- Features Preview --}}
                                @if($package->features && count($package->features) > 0)
                                    <ul class="pkg-card-features" style="list-style: none; padding: 0; margin: 0;">
                                        @foreach(array_slice($package->features, 0, 3) as $feature)
                                            <li><i class="fas fa-check-circle"></i> {{ is_array($feature) ? ($feature['feature'] ?? '') : $feature }}</li>
                                        @endforeach
                                        @if(count($package->features) > 3)
                                            <li class="more">+{{ count($package->features) - 3 }} {{ __('more_features') }}</li>
                                        @endif
                                    </ul>
                                @endif
                            </div>

                            {{-- Footer: Price + Actions --}}
                            <div class="pkg-card-footer">
                                <div class="pkg-price-wrap">
                                    @if($package->sale_price)
                                        <div class="pkg-price-old price-row {{ $currencyPos === 'before' ? 'reverse' : '' }}">
                                            <span>{{ number_format($package->price) }}</span>
                                            {!! $currencyHtml !!}
                                        </div>
                                    @endif
                                    <div class="pkg-price-current price-row {{ $currencyPos === 'before' ? 'reverse' : '' }}" style="color: {{ $priceColor }};">
                                        <span>{{ number_format($package->final_price) }}</span>
                                        {!! $currencyHtml !!}
                                    </div>
                                </div>
                                <div class="pkg-card-actions">
                                    <a href="{{ route('package.show', $package->slug) }}" class="btn-details">
                                        {{ __('details_btn') }} <i class="fas fa-arrow-left"></i>
                                    </a>
                                    <a href="https://wa.me/966500000000?text={{ urlencode(__('whatsapp_inquiry') . $package->translated_name) }}"
                                       target="_blank" rel="noopener"
                                       class="btn-book-sm" title="واتساب">
                                        <i class="fab fa-whatsapp"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="pkg-empty">
                    <i class="fas fa-box-open"></i>
                    <h3>{{ __('no_packages') }}</h3>
                    <p>{{ __('no_packages_desc') }}</p>
                </div>
            @endif
        </section>
    </div>

    <script>
    // Price tier filtering
    const priceTiers = @json($priceTiers);

    function filterTier(tierIndex) {
        // Update active tab
        document.querySelectorAll('.tier-tab').forEach((tab, i) => {
            tab.classList.toggle('active', i === tierIndex);
        });

        const tier = priceTiers[tierIndex];
        const cards = document.querySelectorAll('.pkg-card');

        cards.forEach(card => {
            const price = parseFloat(card.dataset.price);
            if (tierIndex === 0) {
                card.style.display = '';
            } else if (price >= tier.min && price <= tier.max) {
                card.style.display = '';
            } else {
                card.style.display = 'none';
            }
        });
    }
    </script>

</x-layouts.app>
