<x-layouts.app>
    @section('title', $package->meta_title ?? $package->translated_name . ' | مختبرات بريزما الطبية')
    @section('description', $package->meta_description ?? $package->translated_short_description)

    <style>
        :root {
            --pr-primary: #1A365D;
            --pr-secondary: #00A0B0;
            --pr-accent: #2D9CDB;
            --pr-light: #F8FAFC;
            --pr-text: #334155;
            --pr-radius: 12px;
            --pr-radius-lg: 16px;
            --pr-shadow: 0 4px 20px rgba(0,0,0,0.08);
            --pr-shadow-card: 0 8px 32px rgba(0,0,0,0.06);
            --pr-gradient: linear-gradient(135deg, var(--pr-primary) 0%, #2D3748 100%);
            --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        .pkg-detail-page * { box-sizing: border-box; }
        .pkg-detail-page { font-family: 'Tajawal', 'Cairo', sans-serif; color: var(--pr-text); direction: rtl; }
        .pkg-detail-page h1, .pkg-detail-page h2, .pkg-detail-page h3, .pkg-detail-page h4 { font-family: 'Cairo', sans-serif; }

        /* Preview Banner */
        .preview-banner {
            background: linear-gradient(135deg, #f59e0b, #d97706);
            color: white;
            text-align: center;
            padding: 12px 20px;
            font-weight: 700;
            font-family: 'Cairo', sans-serif;
            font-size: 0.95rem;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }

        .page-layout { display: grid; grid-template-columns: 1fr 380px; gap: 32px; max-width: 1280px; margin: 0 auto; padding: 24px 20px 48px; align-items: start; }
        @media (max-width: 1024px) { .page-layout { grid-template-columns: 1fr; } }

        /* Hero */
        .pkg-hero-wrap { position: relative; width: 100%; border-radius: var(--pr-radius-lg); overflow: hidden; margin-bottom: 24px; box-shadow: var(--pr-shadow-card); min-height: 400px; display: flex; }
        .pkg-hero-wrap .hero-img { flex: 1; min-width: 0; min-height: 400px; object-fit: cover; display: block; background: #e2e8f0; }
        .pkg-hero-overlay { position: relative; width: 38%; min-width: 280px; background: var(--pr-gradient); display: flex; flex-direction: column; justify-content: center; padding: 40px; color: white; }
        .pkg-hero-overlay .promo { font-size: 1rem; font-weight: 700; margin-bottom: 12px; background: rgba(255,255,255,0.15); padding: 6px 16px; border-radius: 50px; width: fit-content; }
        .pkg-hero-overlay .price-hero { font-size: 3.5rem; font-weight: 900; font-family: 'Cairo'; line-height: 1.1; color: white; }
        .pkg-hero-overlay .currency { font-size: 1.2rem; opacity: 1; margin-top: 6px; color: white; }
        .hero-back { position: absolute; top: 16px; left: 16px; width: 44px; height: 44px; background: rgba(255,255,255,0.95); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: var(--pr-primary); text-decoration: none; font-size: 1.2rem; transition: var(--transition); z-index: 2; }
        .hero-back:hover { background: white; color: var(--pr-secondary); }
        .hero-share { position: absolute; top: 16px; right: 16px; width: 44px; height: 44px; background: rgba(255,255,255,0.95); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: var(--pr-primary); text-decoration: none; font-size: 1.1rem; transition: var(--transition); z-index: 2; border: none; cursor: pointer; }
        .hero-share:hover { background: white; color: var(--pr-secondary); }

        @media (max-width: 768px) {
            .pkg-hero-wrap { display: flex; flex-direction: column; }
            .pkg-hero-wrap .hero-img { width: 100%; flex: 0 0 auto; }
            .pkg-hero-overlay { position: static; width: 100%; min-width: 0; flex-direction: row; align-items: center; justify-content: space-between; gap: 16px; padding: 16px 20px; border-radius: 0 0 var(--pr-radius-lg) var(--pr-radius-lg); }
            .pkg-hero-overlay .promo { margin-bottom: 0; font-size: 0.9rem; }
            .pkg-hero-overlay .hero-price-block { display: flex; flex-direction: column; align-items: flex-end; gap: 2px; }
            .pkg-hero-overlay .price-hero { font-size: 1.75rem; line-height: 1; }
            .pkg-hero-overlay .currency { margin-top: 0; font-size: 0.9rem; }
        }

        /* Content Cards */
        .content-card { background: white; border-radius: var(--pr-radius-lg); padding: 32px 28px; margin-bottom: 24px; box-shadow: var(--pr-shadow-card); }
        .content-card h1 { font-size: 1.75rem; color: var(--pr-primary); font-weight: 800; margin-bottom: 14px; line-height: 1.35; }
        .content-card .pkg-desc { font-size: 1.05rem; color: #64748B; line-height: 1.7; margin-bottom: 28px; }
        .section-title { font-size: 1.15rem; font-weight: 700; color: var(--pr-primary); margin-bottom: 18px; display: flex; align-items: center; gap: 10px; }
        .section-title i { color: var(--pr-secondary); }

        /* Tags row */
        .pkg-tags { display: flex; gap: 8px; flex-wrap: wrap; margin-bottom: 16px; }
        .pkg-tag {
            display: inline-flex; align-items: center; gap: 5px;
            padding: 5px 14px; border-radius: 50px;
            font-size: 0.82rem; font-weight: 600;
            background: #f0fdf4; color: #16a34a; border: 1px solid #bbf7d0;
        }
        .pkg-tag.offer { background: #fef3c7; color: #d97706; border-color: #fde68a; }
        .pkg-tag.tests { background: #dbeafe; color: #2563eb; border-color: #bfdbfe; }

        /* Instructions Card */
        .instructions-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 12px;
            margin-bottom: 24px;
        }
        .instruction-item {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 14px 16px;
            background: #f8fafc;
            border: 1px solid #e2e8f0;
            border-radius: 10px;
            transition: var(--transition);
        }
        .instruction-item:hover {
            border-color: var(--pr-secondary);
            background: #f0fdf9;
        }
        .instruction-item .inst-icon {
            width: 40px; height: 40px;
            border-radius: 10px;
            background: linear-gradient(135deg, var(--pr-secondary), #0891b2);
            color: white;
            display: flex; align-items: center; justify-content: center;
            font-size: 1rem;
            flex-shrink: 0;
        }
        .instruction-item .inst-text { flex: 1; }
        .instruction-item .inst-label { font-size: 0.78rem; color: #94a3b8; font-weight: 600; }
        .instruction-item .inst-value { font-size: 0.92rem; color: var(--pr-primary); font-weight: 700; }

        /* Category-grouped Tests — Reference Image Style */
        .test-category-section { margin-bottom: 28px; }
        .test-category-header {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 0 0 12px 0;
            margin-bottom: 16px;
            border-bottom: 2px solid #e2e8f0;
            cursor: pointer;
            transition: var(--transition);
        }
        .test-category-header:hover {
            border-bottom-color: var(--pr-secondary);
        }
        .test-category-header h4 {
            flex: 1;
            font-size: 1.1rem;
            font-weight: 800;
            color: #6366f1;
            margin: 0;
            letter-spacing: -0.01em;
        }
        .test-category-header .cat-count {
            font-size: 0.82rem;
            color: #6366f1;
            font-weight: 600;
            background: #eef2ff;
            padding: 3px 10px;
            border-radius: 50px;
        }
        .test-category-header .toggle-icon {
            color: #6366f1;
            font-size: 0.8rem;
            transition: transform 0.3s;
        }
        .test-category-section.collapsed .toggle-icon {
            transform: rotate(-90deg);
        }
        .test-category-section.collapsed .test-items-grid {
            display: none;
        }

        .test-items-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 10px;
            padding: 0 8px;
        }
        @media (max-width: 640px) {
            .test-items-grid { grid-template-columns: 1fr; }
        }
        .test-item {
            display: flex;
            align-items: flex-start;
            gap: 10px;
            padding: 12px 14px;
            background: #fafbfc;
            border: 1px solid #f1f5f9;
            border-radius: 8px;
            transition: var(--transition);
        }
        .test-item:hover {
            background: white;
            border-color: #e2e8f0;
            box-shadow: 0 2px 8px rgba(0,0,0,0.04);
        }
        .test-item .test-check {
            width: 20px; height: 20px;
            border-radius: 50%;
            background: #dcfce7;
            color: #22c55e;
            display: flex; align-items: center; justify-content: center;
            font-size: 0.65rem;
            flex-shrink: 0;
            margin-top: 2px;
        }
        .test-item .test-info { flex: 1; }
        .test-item .test-name {
            font-size: 0.9rem;
            font-weight: 600;
            color: var(--pr-primary);
            line-height: 1.4;
        }
        .test-item .test-desc {
            font-size: 0.8rem;
            color: #94a3b8;
            line-height: 1.4;
            margin-top: 2px;
        }

        /* Uncategorized tests */
        .tests-flat-list {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 10px;
        }
        @media (max-width: 640px) {
            .tests-flat-list { grid-template-columns: 1fr; }
        }

        /* Accordions */
        .accordion-item { background: white; border: 1px solid #e2e8f0; border-radius: var(--pr-radius); margin-bottom: 10px; overflow: hidden; box-shadow: 0 1px 3px rgba(0,0,0,0.04); }
        .accordion-header { padding: 20px 24px; cursor: pointer; display: flex; justify-content: space-between; align-items: center; font-weight: 700; color: var(--pr-primary); font-size: 1rem; transition: var(--transition); }
        .accordion-header:hover { background: #f8fafc; }
        .accordion-icon { width: 28px; height: 28px; background: var(--pr-secondary); color: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; transition: 0.3s; flex-shrink: 0; margin-right: 12px; font-size: 0.75rem; }
        .accordion-content { max-height: 0; overflow: hidden; transition: max-height 0.35s ease; }
        .accordion-content-inner { padding: 18px 24px 22px; color: #64748B; line-height: 1.8; font-size: 0.98rem; border-top: 1px solid #e2e8f0; }
        .accordion-item.active .accordion-header { background: #f8fafc; }
        .accordion-item.active .accordion-icon { transform: rotate(180deg); background: var(--pr-primary); }
        .accordion-item.active .accordion-content { max-height: 600px; }

        /* Sidebar */
        .pkg-sidebar { position: sticky; top: 94px; }
        @media (max-width: 1024px) { .pkg-sidebar { position: static; order: -1; } }
        .order-card { background: white; border-radius: var(--pr-radius-lg); padding: 28px 24px; box-shadow: var(--pr-shadow-card); border: 1px solid #e2e8f0; }
        .order-price-main { font-size: 2.5rem; font-weight: 900; color: var(--pr-primary); font-family: 'Cairo'; line-height: 1; }
        .price-variants { margin: 18px 0; padding: 16px; background: #f8fafc; border-radius: var(--pr-radius); border: 1px solid #e2e8f0; }
        .price-variants .pv-row { display: flex; justify-content: space-between; align-items: center; padding: 8px 0; font-size: 1rem; }
        .price-variants .pv-row:not(:last-child) { border-bottom: 1px solid #e2e8f0; }
        .price-variants .pv-label { color: #64748B; font-weight: 600; }
        .price-variants .pv-value { font-weight: 800; color: var(--pr-primary); font-family: 'Cairo'; }
        .booking-summary-box { background: #f8fafc; border: 1px solid #e2e8f0; border-radius: var(--pr-radius); padding: 16px; margin-bottom: 20px; }
        .booking-summary-box h4 { font-size: 0.95rem; color: var(--pr-primary); margin-bottom: 6px; font-weight: 700; }
        .booking-summary-box p { font-size: 0.9rem; color: #64748B; line-height: 1.5; margin: 0; }
        .form-label { display: block; font-size: 0.9rem; font-weight: 700; color: var(--pr-primary); margin-bottom: 6px; }
        .form-input { width: 100%; padding: 12px 14px; border: 2px solid #e2e8f0; border-radius: 8px; font-size: 1rem; margin-bottom: 14px; font-family: inherit; direction: rtl; }
        .form-input:focus { border-color: var(--pr-secondary); outline: none; }
        .form-textarea { width: 100%; min-height: 80px; padding: 12px 14px; border: 2px solid #e2e8f0; border-radius: 8px; font-size: 1rem; margin-bottom: 18px; resize: vertical; font-family: inherit; direction: rtl; }
        .form-textarea:focus { border-color: var(--pr-secondary); outline: none; }
        .order-btn { display: block; width: 100%; padding: 16px 24px; font-size: 1.05rem; font-weight: 700; border-radius: var(--pr-radius); text-align: center; text-decoration: none; transition: var(--transition); font-family: 'Cairo'; margin-bottom: 12px; border: none; cursor: pointer; }
        .order-btn-book { background: var(--pr-primary); color: white; }
        .order-btn-book:hover { background: #2D3748; color: white; }
        .order-btn-whatsapp { background: #25D366; color: white; display: flex; align-items: center; justify-content: center; gap: 10px; }
        .order-btn-whatsapp:hover { background: #1da851; color: white; }
        .order-btn-pay { background: white; color: var(--pr-primary); border: 2px solid var(--pr-primary) !important; }
        .order-btn-pay:hover { background: var(--pr-primary); color: white; }

        /* Installment note */
        .installment-note {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 10px 14px;
            background: #fefce8;
            border: 1px solid #fde68a;
            border-radius: 8px;
            font-size: 0.82rem;
            color: #a16207;
            font-weight: 600;
            margin-top: 8px;
        }
        .installment-note i { font-size: 0.95rem; }

        /* Discover / Related */
        .discover { max-width: 1280px; margin: 0 auto; padding: 0 20px 56px; }
        .discover h2 { font-size: 1.5rem; color: var(--pr-primary); font-weight: 800; margin-bottom: 24px; text-align: center; }
        .discover-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 20px; }
        @media (max-width: 768px) { .discover-grid { grid-template-columns: 1fr; } }
        .discover-card { background: white; border-radius: var(--pr-radius); overflow: hidden; box-shadow: var(--pr-shadow); border: 1px solid #e2e8f0; transition: var(--transition); text-decoration: none; color: inherit; display: block; }
        .discover-card:hover { transform: translateY(-4px); box-shadow: 0 12px 28px rgba(0,0,0,0.1); border-color: var(--pr-secondary); }
        .discover-card img { width: 100%; height: 140px; object-fit: cover; background: #f1f5f9; }
        .discover-card .dc-body { padding: 16px; }
        .discover-card h4 { font-size: 1.1rem; color: var(--pr-primary); font-weight: 800; margin-bottom: 8px; line-height: 1.4; }
        .discover-card p { font-size: 0.9rem; color: #64748B; margin-bottom: 15px; line-height: 1.6; display: -webkit-box; -webkit-line-clamp: 2; line-clamp: 2; -webkit-box-orient: vertical; overflow: hidden; }
        .discover-card .dc-price { font-size: 1.25rem; font-weight: 900; color: var(--pr-secondary); margin-top: auto; }

        /* Mobile Footer Bar */
        .mobile-footer-bar { display: none; }
        @media (max-width: 768px) {
            .mobile-footer-bar {
                display: flex; position: fixed; bottom: 0; left: 0; right: 0; z-index: 200;
                background: white; box-shadow: 0 -4px 24px rgba(0,0,0,0.12);
                padding: 14px 16px; padding-bottom: max(14px, env(safe-area-inset-bottom));
                align-items: center; gap: 16px; border-top: 1px solid #e2e8f0;
            }
            .mobile-footer-bar .mfb-price-wrap { flex: 1; min-width: 0; }
            .mobile-footer-bar .mfb-price-label { font-size: 0.75rem; color: #64748B; font-weight: 600; margin-bottom: 2px; }
            .mobile-footer-bar .mfb-price { font-size: 1.5rem; font-weight: 900; color: var(--pr-primary); font-family: 'Cairo'; line-height: 1; }
            .mobile-footer-bar .mfb-currency { font-size: 0.8rem; color: #64748B; margin-top: 2px; }
            .mobile-footer-bar .mfb-btn {
                flex-shrink: 0; display: inline-flex; align-items: center; justify-content: center; gap: 8px;
                padding: 16px 24px; min-height: 52px; min-width: 140px;
                background: var(--pr-primary); color: white; border: none; border-radius: 50px;
                font-size: 1.05rem; font-weight: 700; font-family: 'Cairo', sans-serif;
                text-decoration: none; cursor: pointer; transition: var(--transition);
                box-shadow: 0 4px 16px rgba(26, 54, 93, 0.35);
            }
            .mobile-footer-bar .mfb-btn:hover { background: var(--pr-secondary); color: white; }
            .pkg-sidebar { display: none !important; }
            body { padding-bottom: 88px; }
        }

        /* Booking Modal */
        .booking-modal-overlay { display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.5); backdrop-filter: blur(4px); z-index: 300; justify-content: center; align-items: flex-end; padding: 0; }
        .booking-modal-overlay.active { display: flex; }
        .booking-modal-box { width: 100%; max-height: 90vh; background: white; border-radius: 16px 16px 0 0; overflow-y: auto; animation: slideUpModal 0.3s ease; box-shadow: 0 -8px 32px rgba(0,0,0,0.15); }
        @keyframes slideUpModal { from { transform: translateY(100%); } to { transform: translateY(0); } }
        .booking-modal-header { position: sticky; top: 0; background: white; padding: 16px 20px; border-bottom: 1px solid #e2e8f0; display: flex; justify-content: space-between; align-items: center; z-index: 1; }
        .booking-modal-header h3 { font-size: 1.25rem; color: var(--pr-primary); font-weight: 800; margin: 0; }
        .booking-modal-close { width: 44px; height: 44px; display: flex; align-items: center; justify-content: center; border-radius: 50%; background: #f1f5f9; color: var(--pr-primary); border: none; cursor: pointer; font-size: 1.5rem; transition: var(--transition); }
        .booking-modal-close:hover { background: #e2e8f0; color: var(--pr-secondary); }
        .booking-modal-body { padding: 20px; padding-bottom: max(20px, env(safe-area-inset-bottom)); }
    </style>

    @php
        $siteSettings = app(\App\Settings\SiteSettings::class);
        $currencyType = $siteSettings->currency_type ?? 'text';
        $currencyText = $siteSettings->currency_text ?? 'ريال';
        $currencySvg = $siteSettings->currency_svg ?? '';
        $currencyImage = $siteSettings->currency_image ?? '';
        $currencyPos = $siteSettings->currency_position ?? 'after';
        $currencyIconSize = $siteSettings->currency_icon_size ?? 18;
        $priceTagBg = $siteSettings->price_tag_bg ?? '#FFFFFF';
        $priceTagColor = $siteSettings->price_tag_color ?? '#000000';

        $currencyHtml = '';
        if ($currencyType === 'text') {
            $currencyHtml = '<span class="currency-text">' . e($currencyText) . '</span>';
        } elseif ($currencyType === 'svg') {
            $currencyHtml = '<span class="currency-icon svg">' . $currencySvg . '</span>';
        } elseif ($currencyType === 'image' && $currencyImage) {
            $currencyHtml = '<img src="' . asset('storage/' . $currencyImage) . '" class="currency-icon img" alt="currency">';
        }
    @endphp

    <style>
        .currency-icon { display: inline-block !important; vertical-align: middle; width: {{ $currencyIconSize }}px !important; height: {{ $currencyIconSize }}px !important; min-width: {{ $currencyIconSize }}px !important; object-fit: contain; }
        .currency-icon.svg svg { width: {{ $currencyIconSize }}px !important; height: {{ $currencyIconSize }}px !important; fill: currentColor; display: block; }
        .currency-icon.light { filter: brightness(0) invert(1); }
        .currency-icon.light.svg svg { fill: #FFFFFF !important; }
        .currency-text { font-size: 0.9rem; opacity: 0.85; font-weight: 600; }
        .price-inline { display: inline-flex; align-items: center; gap: 8px; }
        .price-inline.reverse { flex-direction: row-reverse; }
    </style>

    <div class="pkg-detail-page">
        {{-- Preview Banner --}}
        @if(isset($isPreview) && $isPreview)
            <div class="preview-banner">
                <i class="fas fa-eye"></i>
                {{ __('preview_banner') }}
            </div>
        @endif

        <div class="page-layout">
            {{-- Main Column --}}
            <div class="main-col">
                {{-- Hero Image + Price --}}
                <div class="pkg-hero-wrap">
                    <a href="{{ route('packages.index') }}" class="hero-back" title="{{ __('back_title') }}"><i class="fas fa-arrow-right"></i></a>
                    <button class="hero-share" onclick="sharePackage()" title="{{ __('share_title') }}"><i class="fas fa-share-alt"></i></button>
                    @if($package->image)
                        <img class="hero-img" src="{{ asset('storage/' . $package->image) }}" alt="{{ $package->translated_name }}">
                    @else
                        <div class="hero-img" style="background: linear-gradient(135deg, #e2e8f0 0%, #cbd5e1 100%); display: flex; align-items: center; justify-content: center;">
                            <i class="fas fa-microscope" style="font-size: 4rem; color: var(--pr-secondary); opacity: 0.5;"></i>
                        </div>
                    @endif
                    <div class="pkg-hero-overlay">
                        @if($package->discount_percentage > 0)
                            <span class="promo">{{ __('discount_off', ['percentage' => $package->discount_percentage]) }}</span>
                        @elseif($package->translated_badge_text)
                            <span class="promo">{{ $package->translated_badge_text }}</span>
                        @else
                            <span class="promo">{{ __('special_offer') }}</span>
                        @endif
                        <span class="hero-price-block">
                            <div class="price-hero price-inline {{ $currencyPos === 'before' ? 'reverse' : '' }}">
                                <span>{{ number_format($package->final_price) }}</span>
                                <span class="currency" style="font-size: 1rem; margin-top: 0;">
                                    @if($currencyType === 'text')
                                        <span class="currency-text">{{ $currencyText }}</span>
                                    @elseif($currencyType === 'svg')
                                        <span class="currency-icon svg light">{!! $currencySvg !!}</span>
                                    @elseif($currencyType === 'image' && $currencyImage)
                                        <img src="{{ asset('storage/' . $currencyImage) }}" class="currency-icon img light" alt="currency">
                                    @endif
                                </span>
                            </div>
                        </span>
                    </div>
                </div>

                {{-- Content Card: Title + Description + Instructions + Tests --}}
                <div class="content-card">
                    {{-- Tags --}}
                    <div class="pkg-tags">
                        @if($package->discount_percentage > 0)
                            <span class="pkg-tag offer"><i class="fas fa-fire"></i> {{ __('offers_badge') }}</span>
                        @endif
                        @if($package->tests_count > 0)
                            <span class="pkg-tag tests"><i class="fas fa-vial"></i> {{ $package->tests_count }} {{ $package->tests_count == 1 ? __('test_count_single') : __('test_count_suffix') }}</span>
                        @endif
                        @if($package->estimated_time)
                            <span class="pkg-tag"><i class="fas fa-clock"></i> {{ $package->estimated_time }}</span>
                        @endif
                    </div>

                    <h1>{{ $package->translated_name }}</h1>

                    @if($package->translated_description)
                        <p class="pkg-desc">{!! $package->translated_description !!}</p>
                    @elseif($package->translated_short_description)
                        <p class="pkg-desc">{{ $package->translated_short_description }}</p>
                    @endif

                    {{-- Instructions Grid (sample type, fasting, collection) --}}
                    @if($package->sample_type || $package->collection_method || $package->fasting_instructions)
                        <div class="instructions-grid">
                            @if($package->sample_type)
                                <div class="instruction-item">
                                    <div class="inst-icon"><i class="fas fa-syringe"></i></div>
                                    <div class="inst-text">
                                        <div class="inst-label">{{ __('sample_type') }}</div>
                                        <div class="inst-value">{{ $package->sample_type }}</div>
                                    </div>
                                </div>
                            @endif
                            @if($package->collection_method)
                                <div class="instruction-item">
                                    <div class="inst-icon"><i class="fas fa-hand-holding-medical"></i></div>
                                    <div class="inst-text">
                                        <div class="inst-label">{{ __('collection_method') }}</div>
                                        <div class="inst-value">{{ $package->collection_method }}</div>
                                    </div>
                                </div>
                            @endif
                            @if($package->fasting_instructions || $package->translated_fasting_instructions)
                                <div class="instruction-item">
                                    <div class="inst-icon"><i class="fas fa-utensils"></i></div>
                                    <div class="inst-text">
                                        <div class="inst-label">{{ __('fasting_instructions') }}</div>
                                        <div class="inst-value">{{ $package->translated_fasting_instructions ?? $package->fasting_instructions }}</div>
                                    </div>
                                </div>
                            @endif
                            @if($package->estimated_time)
                                <div class="instruction-item">
                                    <div class="inst-icon"><i class="fas fa-clock"></i></div>
                                    <div class="inst-text">
                                        <div class="inst-label">{{ __('results_duration') }}</div>
                                        <div class="inst-value">{{ $package->estimated_time }}</div>
                                    </div>
                                </div>
                            @endif
                        </div>
                    @endif

                    {{-- Tests Grouped by Category --}}
                    @if($groupedTests->count() > 0)
                        <h3 class="section-title"><i class="fas fa-list-check"></i> {{ __('whats_included') }} ({{ $package->tests_count }} {{ $package->tests_count == 1 ? __('test_count_single') : __('test_count_suffix') }})</h3>

                        @foreach($groupedTests as $group)
                            @if($group['category'])
                                {{-- Category with header --}}
                                <div class="test-category-section" data-cat>
                                    <div class="test-category-header" onclick="this.parentElement.classList.toggle('collapsed')">
                                        <i class="cat-icon {{ $group['category']->icon ?? 'fas fa-vial' }}"></i>
                                        <h4>{{ $group['category']->translated_name }}</h4>
                                        <span class="cat-count">{{ $group['tests']->count() }}</span>
                                        <i class="toggle-icon fas fa-chevron-down"></i>
                                    </div>
                                    <div class="test-items-grid">
                                        @foreach($group['tests'] as $test)
                                            <div class="test-item">
                                                <div class="test-check"><i class="fas fa-check"></i></div>
                                                <div class="test-info">
                                                    <div class="test-name">{{ $test->translated_name }}</div>
                                                    @if($test->translated_short_description)
                                                        <div class="test-desc">{{ $test->translated_short_description }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @else
                                {{-- Uncategorized tests --}}
                                <div class="test-category-section">
                                    @if($groupedTests->count() > 1)
                                        <div class="test-category-header" onclick="this.parentElement.classList.toggle('collapsed')">
                                            <i class="cat-icon fas fa-flask"></i>
                                            <h4>{{ __('other_tests') }}</h4>
                                            <span class="cat-count">{{ $group['tests']->count() }}</span>
                                            <i class="toggle-icon fas fa-chevron-down"></i>
                                        </div>
                                    @endif
                                    <div class="test-items-grid">
                                        @foreach($group['tests'] as $test)
                                            <div class="test-item">
                                                <div class="test-check"><i class="fas fa-check"></i></div>
                                                <div class="test-info">
                                                    <div class="test-name">{{ $test->translated_name }}</div>
                                                    @if($test->translated_short_description)
                                                        <div class="test-desc">{{ $test->translated_short_description }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    @elseif($package->features && count($package->features) > 0)
                        <h3 class="section-title"><i class="fas fa-list-check"></i> {{ __('whats_included') }}</h3>
                        <div class="tests-flat-list">
                            @foreach($package->features as $feature)
                                <div class="test-item">
                                    <div class="test-check"><i class="fas fa-check"></i></div>
                                    <div class="test-info">
                                        <div class="test-name">{{ is_array($feature) ? ($feature['feature'] ?? '') : $feature }}</div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    {{-- Additional Features (when package has both tests and features) --}}
                    @if($groupedTests->count() > 0 && $package->features && is_array($package->features) && count($package->features) > 0)
                        <h3 class="section-title" style="margin-top: 24px;"><i class="fas fa-star"></i> {{ __('additional_features') }}</h3>
                        <div class="tests-flat-list">
                            @foreach($package->features as $feature)
                                <div class="test-item">
                                    <div class="test-check"><i class="fas fa-check"></i></div>
                                    <div class="test-info">
                                        <div class="test-name">{{ is_array($feature) ? ($feature['feature'] ?? '') : $feature }}</div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>

                {{-- Content Card: Accordions --}}
                <div class="content-card">
                    <h3 class="section-title" style="margin-bottom: 16px;"><i class="fas fa-circle-info"></i> {{ __('additional_info') }}</h3>

                    {{-- Accordion: How it works --}}
                    <div class="accordion-item active">
                        <div class="accordion-header" onclick="this.parentElement.classList.toggle('active')">
                            {{ __('how_it_works') }}
                            <div class="accordion-icon"><i class="fas fa-chevron-down"></i></div>
                        </div>
                        <div class="accordion-content">
                            <div class="accordion-content-inner">
                                {{ __('how_it_works_content') }}
                            </div>
                        </div>
                    </div>

                    {{-- Accordion: Preparation --}}
                    <div class="accordion-item">
                        <div class="accordion-header" onclick="this.parentElement.classList.toggle('active')">
                            {{ __('pre_service_instructions') }}
                            <div class="accordion-icon"><i class="fas fa-chevron-down"></i></div>
                        </div>
                        <div class="accordion-content">
                            <div class="accordion-content-inner">
                                @if($package->translated_preparation_instructions)
                                    {!! $package->translated_preparation_instructions !!}
                                @else
                                    {{ __('pre_service_default') }}
                                @endif
                            </div>
                        </div>
                    </div>

                    {{-- Accordion: FAQ --}}
                    <div class="accordion-item">
                        <div class="accordion-header" onclick="this.parentElement.classList.toggle('active')">
                            {{ __('faq') }}
                            <div class="accordion-icon"><i class="fas fa-chevron-down"></i></div>
                        </div>
                        <div class="accordion-content">
                            <div class="accordion-content-inner">
                                <strong>{{ __('faq_q1') }}</strong> {{ __('faq_a1') }}<br>
                                <strong>{{ __('faq_q2') }}</strong> {{ __('faq_a2') }}<br>
                                <strong>{{ __('faq_q3') }}</strong> {{ __('faq_a3') }}<br>
                                <strong>{{ __('faq_q4') }}</strong> {{ __('faq_a4') }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Sidebar --}}
            <aside class="pkg-sidebar" id="booking-sidebar">
                <div class="order-card" id="order-form">
                    {{-- Price Label --}}
                    <div style="text-align: center; margin-bottom: 8px; font-size: 0.9rem; color: #64748B; font-weight: 600;">{{ __('package_price') }}</div>

                    {{-- Price Display --}}
                    <div style="text-align: center; margin-bottom: 20px;">
                        @if($package->sale_price && $package->price > $package->sale_price)
                            <div class="price-inline {{ $currencyPos === 'before' ? 'reverse' : '' }}" style="color: #94a3b8; text-decoration: line-through; font-weight: 600;">
                                <span>{{ number_format($package->price) }}</span>
                                <span style="font-size: 0.8em;">
                                    @if($currencyType === 'text')
                                        <span class="currency-text">{{ $currencyText }}</span>
                                    @elseif($currencyType === 'svg')
                                        <span class="currency-icon svg">{!! $currencySvg !!}</span>
                                    @elseif($currencyType === 'image' && $currencyImage)
                                        <img src="{{ asset('storage/' . $currencyImage) }}" class="currency-icon img" alt="currency" style="opacity: 0.5;">
                                    @endif
                                </span>
                            </div>
                            <br>
                        @endif
                        <div class="price-inline {{ $currencyPos === 'before' ? 'reverse' : '' }}" style="font-size: 2.8rem; font-weight: 900; color: {{ $priceTagColor }}; background: {{ $priceTagBg }}; padding: 10px 20px; border-radius: 15px; font-family: 'Cairo'; line-height: 1.1; display: inline-flex; box-shadow: 0 4px 12px rgba(0,0,0,0.05); border: 1px solid rgba(0,0,0,0.05);">
                            <span>{{ number_format($package->final_price) }}</span>
                            <span style="font-size: 0.35em;">
                                @if($currencyType === 'text')
                                    <span class="currency-text" style="color: {{ $priceTagColor }};">{{ $currencyText }}</span>
                                @elseif($currencyType === 'svg')
                                    <span class="currency-icon svg" style="color: {{ $priceTagColor }};">{!! $currencySvg !!}</span>
                                @elseif($currencyType === 'image' && $currencyImage)
                                    <img src="{{ asset('storage/' . $currencyImage) }}" class="currency-icon img" alt="currency">
                                @endif
                            </span>
                        </div>

                        @if($package->non_saudi_price)
                            <div style="font-size: 0.95rem; color: #64748B; margin-top: 15px; font-weight: 600; display: flex; justify-content: center; align-items: center; gap: 4px;">
                                {{ __('non_saudi_price') }}: 
                                <div class="price-inline {{ $currencyPos === 'before' ? 'reverse' : '' }}" style="color: {{ $priceTagColor }}; font-weight: 800;">
                                    <span>{{ number_format($package->non_saudi_price) }}</span>
                                    <span style="font-size: 0.8em;">{!! $currencyHtml !!}</span>
                                </div>
                            </div>
                        @endif
                    </div>

                    {{-- Booking Form (editable from dashboard or via Custom Form Builder) --}}
                    @if($siteSettings->show_booking_form)
                        @php
                            // Look for the specific custom form assigned to the package, or fallback to latest active form.
                            $assignedForm = $package->customForm && $package->customForm->is_active ? $package->customForm : null;
                            $bookingForm = $assignedForm ?? \App\Models\CustomForm::active()->latest()->first();
                        @endphp

                        @if($bookingForm)
                            <div class="custom-booking-form-wrapper">
                                @livewire('custom-form-widget', ['formId' => $bookingForm->id])
                            </div>
                        @else
                            <form id="booking-form">
                                <label class="form-label"><i class="fas fa-user" style="margin-left: 6px; color: var(--pr-secondary);"></i> {{ app()->getLocale() === 'en' ? __('name_label') : ($siteSettings->booking_form_name_label ?? __('name_label')) }}</label>
                                <input type="text" id="b-name" name="name" required placeholder="{{ app()->getLocale() === 'en' ? __('name_placeholder') : ($siteSettings->booking_form_name_placeholder ?? __('name_placeholder')) }}" class="form-input">

                                <label class="form-label"><i class="fas fa-phone" style="margin-left: 6px; color: var(--pr-secondary);"></i> {{ app()->getLocale() === 'en' ? __('phone_label') : ($siteSettings->booking_form_phone_label ?? __('phone_label')) }}</label>
                                <input type="tel" id="b-phone" name="phone" required placeholder="{{ app()->getLocale() === 'en' ? __('phone_placeholder') : ($siteSettings->booking_form_phone_placeholder ?? __('phone_placeholder')) }}" class="form-input">

                                <button type="submit" class="order-btn order-btn-book" style="background: #7c3aed; border-radius: 8px;">
                                    <i class="fas fa-paper-plane"></i> {{ app()->getLocale() === 'en' ? __('book_free_now') : ($siteSettings->booking_btn_text ?? __('book_free_now')) }}
                                </button>
                            </form>
                        @endif
                    @endif

                    {{-- WhatsApp Button (editable from dashboard) --}}
                    @if($siteSettings->show_whatsapp_booking)
                    <a id="whatsapp-btn" href="#" target="_blank" rel="noopener" class="order-btn order-btn-whatsapp" style="border-radius: 8px;">
                        <i class="fab fa-whatsapp"></i> {{ app()->getLocale() === 'en' ? __('book_via_whatsapp') : ($siteSettings->whatsapp_btn_text ?? __('book_via_whatsapp')) }}
                    </a>
                    @endif

                    {{-- Credit Payment Button (toggle from dashboard) --}}
                    @if($siteSettings->show_credit_payment)
                    <button type="button" class="order-btn order-btn-pay" style="border-radius: 8px;">
                        <i class="fas fa-credit-card"></i> {{ app()->getLocale() === 'en' ? __('book_via_credit') : ($siteSettings->credit_btn_text ?? __('book_via_credit')) }}
                    </button>
                    @endif

                    {{-- Installment Note: use English translation when locale is en --}}
                    @if($siteSettings->show_installment_note)
                    <div class="installment-note">
                        <i class="fas fa-info-circle"></i>
                        {{ app()->getLocale() === 'en' ? ($siteSettings->installment_note_text_en ?? __('installment_note_default')) : ($siteSettings->installment_note_text ?? __('installment_note_default')) }}
                    </div>
                    @endif
                </div>
            </aside>
        </div>

        {{-- Related Packages --}}
        @if($relatedPackages->count() > 0)
        <section class="discover">
            <h2>{{ __('discover_other_packages') }}</h2>
            <div class="discover-grid">
                @foreach($relatedPackages as $related)
                <a href="{{ route('package.show', $related->slug) }}" class="discover-card">
                    @if($related->image)
                        <img src="{{ asset('storage/' . $related->image) }}" alt="{{ $related->translated_name }}">
                    @else
                        <div style="width:100%;height:140px;background:linear-gradient(135deg,#e2e8f0,#cbd5e1);display:flex;align-items:center;justify-content:center;">
                            <i class="fas fa-microscope" style="font-size:2rem;color:var(--pr-secondary);opacity:0.4;"></i>
                        </div>
                    @endif
                    <div class="dc-body">
                        <h4>{{ $related->translated_name }}</h4>
                        <p>{{ $related->translated_short_description ?? Str::limit(strip_tags($related->translated_description), 80) }}</p>
                        <div class="dc-price price-inline {{ $currencyPos === 'before' ? 'reverse' : '' }}" style="color: {{ $priceTagColor }};">
                            <span>{{ number_format($related->final_price) }}</span>
                            <span style="font-size: 0.8em;">{!! $currencyHtml !!}</span>
                        </div>
                    </div>
                </a>
                @endforeach
            </div>
        </section>
        @endif

        {{-- Mobile Footer Bar --}}
        <div class="mobile-footer-bar" id="mobile-footer-bar">
            <div class="mfb-price-wrap">
                <div class="mfb-price-label">{{ __('from_label') }}</div>
                <div class="mfb-price price-inline {{ $currencyPos === 'before' ? 'reverse' : '' }}" style="color: {{ $priceTagColor }};">
                    <span>{{ number_format($package->final_price) }}</span>
                    <span class="mfb-currency" style="font-size: 0.5em; margin-top: 0;">{!! $currencyHtml !!}</span>
                </div>
            </div>
            <a href="#" id="mfb-book-btn" class="mfb-btn" role="button"><i class="fas fa-calendar-check"></i> {{ __('book_now_btn') }}</a>
        </div>

        {{-- Booking Modal (mobile) --}}
        <div id="booking-modal" class="booking-modal-overlay" aria-hidden="true">
            <div class="booking-modal-box">
                <div class="booking-modal-header">
                    <h3>{{ __('booking_modal_title') }}</h3>
                    <button type="button" class="booking-modal-close" id="booking-modal-close" aria-label="{{ __('close_modal_btn') }}"><i class="fas fa-times"></i></button>
                </div>
                <div id="booking-modal-body" class="booking-modal-body"></div>
            </div>
        </div>
    </div>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const WHATSAPP_NUMBER = @json($siteSettings->contact_whatsapp ?? '966500000000');
        const WHATSAPP_TEMPLATE = @json($siteSettings->whatsapp_message_template ?? "مرحباً، أود الحجز:\nالباقة: {package}\nالاسم: {name}\nالجوال: {phone}");
        const BOOKING_SUCCESS_MSG = @json($siteSettings->booking_success_message ?? 'تم إرسال طلبك بنجاح! سنتواصل معك قريباً.');
        const pkgTitle = @json($package->translated_name);

        // WhatsApp dynamic link
        function updateWhatsApp() {
            const waBtn = document.getElementById('whatsapp-btn');
            if (!waBtn) return;
            const nameEl = document.getElementById('b-name');
            const phoneEl = document.getElementById('b-phone');
            const name = nameEl ? nameEl.value.trim() : '';
            const phone = phoneEl ? phoneEl.value.trim() : '';
            let text = WHATSAPP_TEMPLATE
                .replace('{package}', pkgTitle)
                .replace('{name}', name || '—')
                .replace('{phone}', phone || '—');
            waBtn.href = 'https://wa.me/' + WHATSAPP_NUMBER + '?text=' + encodeURIComponent(text);
        }
        updateWhatsApp();

        const nameInput = document.getElementById('b-name');
        const phoneInput = document.getElementById('b-phone');
        if (nameInput) nameInput.addEventListener('input', updateWhatsApp);
        if (phoneInput) phoneInput.addEventListener('input', updateWhatsApp);

        // Booking form submit
        const bookingForm = document.getElementById('booking-form');
        if (bookingForm) {
            bookingForm.addEventListener('submit', function(e) {
                e.preventDefault();
                const name = document.getElementById('b-name').value.trim();
                const phone = document.getElementById('b-phone').value.trim();
                if (!name || !phone) { alert(@json(__('booking_required_alert'))); return; }
                alert(BOOKING_SUCCESS_MSG + '\n' + pkgTitle + ' — ' + name);
            });
        }

        // Share button
        window.sharePackage = function() {
            if (navigator.share) {
                navigator.share({ title: pkgTitle, url: window.location.href });
            } else {
                navigator.clipboard.writeText(window.location.href).then(() => {
                    alert(@json(__('booking_copied_alert')));
                });
            }
        };

        // Mobile modal
        var orderFormEl = document.getElementById('order-form');
        var sidebarEl = document.getElementById('booking-sidebar');
        var modalEl = document.getElementById('booking-modal');
        var modalBodyEl = document.getElementById('booking-modal-body');
        var mfbBookBtn = document.getElementById('mfb-book-btn');

        function openBookingModal() {
            if (!orderFormEl || !modalBodyEl || !modalEl) return;
            modalBodyEl.appendChild(orderFormEl);
            modalEl.classList.add('active');
            modalEl.setAttribute('aria-hidden', 'false');
            document.body.style.overflow = 'hidden';
        }

        function closeBookingModal() {
            if (!orderFormEl || !sidebarEl || !modalEl) return;
            sidebarEl.appendChild(orderFormEl);
            modalEl.classList.remove('active');
            modalEl.setAttribute('aria-hidden', 'true');
            document.body.style.overflow = '';
        }

        if (mfbBookBtn) {
            mfbBookBtn.addEventListener('click', function(e) {
                e.preventDefault();
                if (window.matchMedia('(max-width: 768px)').matches) openBookingModal();
                else window.location.hash = 'order-form';
            });
        }

        var closeBtn = document.getElementById('booking-modal-close');
        if (closeBtn) closeBtn.addEventListener('click', closeBookingModal);
        if (modalEl) modalEl.addEventListener('click', function(e) { if (e.target === modalEl) closeBookingModal(); });
    });
    </script>

</x-layouts.app>
