<?php

use App\Http\Controllers\DraftPreviewController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\PackageController;
use App\Http\Controllers\PageController;
use Illuminate\Support\Facades\Route;

Route::get('/', [HomeController::class, 'index'])->name('home');

// Language switcher — sets session locale and redirects back
Route::get('/set-locale/{locale}', function (string $locale) {
    if (in_array($locale, ['ar', 'en'])) {
        session(['locale' => $locale]);
    }
    return redirect(url()->previous(route('home')));
})->name('set-locale');

Route::get('/packages', [PackageController::class, 'index'])->name('packages.index');
Route::get('/packages/{package:slug}', [PackageController::class, 'show'])->name('package.show');
Route::get('/packages/{package:slug}/preview', [PackageController::class, 'preview'])
    ->middleware('auth')
    ->name('package.preview');

Route::get('/preview-draft/{token}', [DraftPreviewController::class, 'show'])
    ->name('preview-draft');

Route::get('/preview-draft/page/{page}', [DraftPreviewController::class, 'showForPage'])
    ->name('preview-draft.page');

Route::get('/{page:slug}', [PageController::class, 'show'])->name('page.show');

Route::get('/admin/visual-builder/{page}', \App\Livewire\LiveBuilder::class)
    ->middleware(['web', 'auth']) // Assuming standard auth for admin
    ->name('admin.visual-builder');
