<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>" dir="<?php echo e($siteSettings->direction ?? 'rtl'); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    
    <title><?php echo $__env->yieldContent('title', $siteSettings->meta_title); ?></title>
    <meta name="description" content="<?php echo $__env->yieldContent('description', $siteSettings->meta_description); ?>">
    <meta name="keywords" content="<?php echo $__env->yieldContent('keywords', is_array($siteSettings->meta_keywords) ? implode(', ', $siteSettings->meta_keywords) : $siteSettings->meta_keywords); ?>">
    <meta name="robots" content="index, follow">
    <meta name="author" content="<?php echo e($siteSettings->site_name); ?>">
    
    
    <meta property="og:title" content="<?php echo $__env->yieldContent('title', $siteSettings->meta_title); ?>">
    <meta property="og:description" content="<?php echo $__env->yieldContent('description', $siteSettings->meta_description); ?>">
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">
    <meta property="og:image" content="<?php echo e($siteSettings->logo_light ? asset('storage/' . $siteSettings->logo_light) : ''); ?>">
    
    
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo $__env->yieldContent('title', $siteSettings->meta_title); ?>">
    <meta name="twitter:description" content="<?php echo $__env->yieldContent('description', $siteSettings->meta_description); ?>">
    
    
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($siteSettings->favicon): ?>
        <link rel="icon" type="image/x-icon" href="<?php echo e(asset('storage/' . $siteSettings->favicon)); ?>">
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=<?php echo e(urlencode($siteSettings->font_family ?? 'Cairo')); ?>:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '<?php echo e($siteSettings->color_primary ?? '#1A365D'); ?>',
                        secondary: '<?php echo e($siteSettings->color_secondary ?? '#00A0B0'); ?>',
                        accent: '<?php echo e($siteSettings->color_accent ?? '#2D9CDB'); ?>',
                        light: '<?php echo e($siteSettings->color_light ?? '#F8FAFC'); ?>',
                        text: '<?php echo e($siteSettings->color_text ?? '#334155'); ?>',
                    },
                    fontFamily: {
                        sans: ['<?php echo e($siteSettings->font_family ?? 'Cairo'); ?>', 'sans-serif'],
                        heading: ['<?php echo e($siteSettings->font_heading ?? 'Cairo'); ?>', 'sans-serif'],
                    },
                },
            },
        }
    </script>
    
    
    <style>
        :root {
            --pr-primary: <?php echo e($siteSettings->color_primary ?? '#1A365D'); ?>;
            --pr-secondary: <?php echo e($siteSettings->color_secondary ?? '#00A0B0'); ?>;
            --pr-accent: <?php echo e($siteSettings->color_accent ?? '#2D9CDB'); ?>;
            --pr-light: <?php echo e($siteSettings->color_light ?? '#F8FAFC'); ?>;
            --pr-text: <?php echo e($siteSettings->color_text ?? '#334155'); ?>;
            --pr-white: #ffffff;
            --pr-gray: #E8ECF1;
            --pr-radius: 12px;
            --pr-radius-lg: 16px;
            --pr-shadow: 0 4px 20px rgba(26, 54, 93, 0.08);
            --pr-shadow-card: 0 8px 32px rgba(26, 54, 93, 0.08);
            --pr-gradient: linear-gradient(135deg, <?php echo e($siteSettings->color_secondary ?? '#00A0B0'); ?> 0%, <?php echo e($siteSettings->color_accent ?? '#2D9CDB'); ?> 100%);
            --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            --header-height: 70px;
        }
        
        * { 
            box-sizing: border-box; 
            margin: 0; 
            padding: 0; 
            outline: none; 
            scroll-behavior: smooth; 
        }
        
        body {
            font-family: '<?php echo e($siteSettings->font_family ?? 'Cairo'); ?>', sans-serif;
            background: linear-gradient(180deg, #F8FAFC 0%, var(--pr-light) 20%, #EEF2F7 100%);
            background-attachment: fixed;
            color: var(--pr-text);
            overflow-x: hidden;
            padding-top: var(--header-height);
            font-size: <?php echo e($siteSettings->base_size ?? 16); ?>px;
        }
        
        h1, h2, h3, h4, h5, h6 {
            font-family: '<?php echo e($siteSettings->font_heading ?? 'Cairo'); ?>', sans-serif;
        }
        
        .text-gradient {
            background: var(--pr-gradient);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .bg-gradient {
            background: var(--pr-gradient);
        }
        
        .btn-primary {
            background: var(--pr-gradient);
            color: white;
            padding: 12px 24px;
            border-radius: 50px;
            font-weight: 700;
            transition: var(--transition);
            border: none;
            cursor: pointer;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            text-decoration: none;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 24px rgba(0, 160, 176, 0.4);
            color: white;
        }
        
        .section-title {
            font-size: 1.5rem;
            font-weight: 800;
            color: var(--pr-primary);
            margin-bottom: 18px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .section-title i {
            color: var(--pr-secondary);
        }
    </style>
    
    
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($siteSettings->google_analytics): ?>
        <?php echo $siteSettings->google_analytics; ?>

    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($siteSettings->facebook_pixel): ?>
        <?php echo $siteSettings->facebook_pixel; ?>

    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
    
    <?php if (isset($component)) { $__componentOriginal07a90ab6ff353cc67cef9e6d27d14a6b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal07a90ab6ff353cc67cef9e6d27d14a6b = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.layouts.partials.header','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('layouts.partials.header'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal07a90ab6ff353cc67cef9e6d27d14a6b)): ?>
<?php $attributes = $__attributesOriginal07a90ab6ff353cc67cef9e6d27d14a6b; ?>
<?php unset($__attributesOriginal07a90ab6ff353cc67cef9e6d27d14a6b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal07a90ab6ff353cc67cef9e6d27d14a6b)): ?>
<?php $component = $__componentOriginal07a90ab6ff353cc67cef9e6d27d14a6b; ?>
<?php unset($__componentOriginal07a90ab6ff353cc67cef9e6d27d14a6b); ?>
<?php endif; ?>
    
    
    <main>
        <?php echo e($slot); ?>

    </main>
    
    
    <?php if (isset($component)) { $__componentOriginalff0febf07c7a9e05cdc70e369c825961 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalff0febf07c7a9e05cdc70e369c825961 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.layouts.partials.footer','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('layouts.partials.footer'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalff0febf07c7a9e05cdc70e369c825961)): ?>
<?php $attributes = $__attributesOriginalff0febf07c7a9e05cdc70e369c825961; ?>
<?php unset($__attributesOriginalff0febf07c7a9e05cdc70e369c825961); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalff0febf07c7a9e05cdc70e369c825961)): ?>
<?php $component = $__componentOriginalff0febf07c7a9e05cdc70e369c825961; ?>
<?php unset($__componentOriginalff0febf07c7a9e05cdc70e369c825961); ?>
<?php endif; ?>
    
    
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH /Users/test/Documents/prisma1/resources/views/components/layouts/app.blade.php ENDPATH**/ ?>