<?php

namespace App\Filament\Blocks;

use Filament\Forms\Components\Builder\Block;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\ColorPicker;
use Filament\Forms\Components\Select;

class CtaBlock
{
    public static function make(): Block
    {
        return Block::make('cta')
            ->label('بانر مع زر (دعوة لاتصال)')
            ->icon('heroicon-o-megaphone')
            ->schema([
                        TextInput::make('title')->label('عنوان البانر')->maxLength(255)->live(debounce: 700)->placeholder('مثال: تواصل معنا'),
                        Textarea::make('description')->label('وصف')->rows(3)->live(debounce: 700)->maxLength(1000),
                        TextInput::make('button_text')
                            ->label('نص الزر الرئيسي')
                            ->default('ابدأ الآن')
                            ->live(debounce: 700)
                            ->maxLength(100),
                        TextInput::make('button_url')
                            ->label('رابط الزر')
                            ->default('/contact')
                            ->live(debounce: 700)
                            ->maxLength(255),
                        TextInput::make('secondary_button_text')
                            ->label('نص الزر الثانوي (اختياري)')
                            ->live(debounce: 700)
                            ->maxLength(100),
                        TextInput::make('secondary_button_url')
                            ->label('رابط الزر الثانوي')
                            ->live(debounce: 700)
                            ->maxLength(255),

                
                FileUpload::make('background_image')
                    ->label('صورة الخلفية')
                    ->image()
                    ->directory('cta-backgrounds'),
                
                ColorPicker::make('background_color')
                    ->label('لون الخلفية')
                    ->default('#0ea5e9'),
                
                ColorPicker::make('text_color')
                    ->label('لون النص')
                    ->default('#ffffff'),
                
                Select::make('alignment')
                    ->label('محاذاة النص')
                    ->options([
                        'left' => 'يسار',
                        'center' => 'وسط',
                        'right' => 'يمين',
                    ])
                    ->default('center'),
            ]);
    }
}
