<?php

namespace App\Filament\Blocks;

use Filament\Forms\Components\Builder\Block;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\ColorPicker;

class FeaturesBlock
{
    protected static function heroiconOptions(): array
    {
        return [
            'heroicon-o-check-circle' => 'Check Circle',
            'heroicon-o-shield-check' => 'Shield Check',
            'heroicon-o-clock' => 'Clock',
            'heroicon-o-user-group' => 'User Group',
            'heroicon-o-heart' => 'Heart',
            'heroicon-o-beaker' => 'Beaker',
            'heroicon-o-cube' => 'Cube / Microscope',
            'heroicon-o-academic-cap' => 'Academic Cap',
            'heroicon-o-clipboard-document-check' => 'Clipboard Check',
            'heroicon-o-sparkles' => 'Sparkles',
            'heroicon-o-truck' => 'Truck',
            'heroicon-o-home' => 'Home',
            'heroicon-o-phone' => 'Phone',
            'heroicon-o-envelope' => 'Envelope',
            'heroicon-o-map-pin' => 'Map Pin',
            'heroicon-o-star' => 'Star',
            'heroicon-o-trophy' => 'Trophy',
        ];
    }

    public static function make(): Block
    {
        return Block::make('features')
            ->label('مزايا (قائمة مع أيقونات)')
            ->icon('heroicon-o-star')
            ->schema([
                        TextInput::make('title')->label('عنوان القسم')->maxLength(255)->live(debounce: 700)->placeholder('مثال: لماذا نحن؟'),
                        Textarea::make('description')->label('وصف القسم')->rows(3)->live(debounce: 700)->maxLength(500),
                        
                TextInput::make('title')->label('')->default('Why Choose Us')->maxLength(255)->dehydrated(true)->hidden(),
                Textarea::make('description')->label('')->rows(1)->maxLength(500)->dehydrated(true)->hidden(),
                
                Select::make('layout')
                    ->label('شكل العرض')
                    ->options([
                        'grid' => 'شبكة',
                        'list' => 'قائمة',
                        'cards' => 'بطاقات',
                    ])
                    ->default('grid')
                    ->required(),
                
                Select::make('icon_style')
                    ->label('نوع الأيقونة')
                    ->options([
                        'outline' => 'حدود',
                        'solid' => 'ملون',
                        'mini' => 'صغير',
                    ])
                    ->default('outline')
                    ->required(),
                
                ColorPicker::make('icon_color')
                    ->label('لون الأيقونة')
                    ->default('#0ea5e9'),
                
                Repeater::make('features')
                    ->label('عناصر المزايا')
                    ->schema([
                        Select::make('icon_type')
                            ->label('الأيقونة')
                            ->options([
                                'library' => 'من المكتبة',
                                'image'   => 'رفع صورة',
                            ])
                            ->default('library')
                            ->live(),
                        
                        Select::make('icon')
                            ->label('اختر أيقونة')
                            ->options(static::heroiconOptions())
                            ->searchable()
                            ->visible(fn ($get) => ($get('icon_type') ?? 'library') === 'library'),
                        
                        FileUpload::make('icon_image')
                            ->label('صورة الأيقونة')
                            ->image()
                            ->directory('block-icons')
                            ->visibility('public')
                            ->imageEditor()
                            ->maxSize(1024)
                            ->visible(fn ($get) => ($get('icon_type') ?? 'library') === 'image'),
                        
                                TextInput::make('title')
                                    ->label('عنوان العنصر')
                                    ->required()
                                    ->live(debounce: 700)
                                    ->maxLength(255),
                                Textarea::make('description')
                                    ->label('وصف العنصر')
                                    ->rows(2)
                                    ->live(debounce: 700)
                                    ->maxLength(500),
                    ])
                    ->collapsible()
                    ->itemLabel(fn (array $state): ?string => $state['title'] ?? 'New Feature')
                    ->defaultItems(3)
                    ->minItems(1)
                    ->maxItems(8)
                    ->columnSpanFull(),
            ]);
    }
}
