<?php

namespace App\Filament\Blocks;

use Filament\Forms\Components\Builder\Block;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\Section;

class PrismaFaqBlock
{
    public static function make(): Block
    {
        return Block::make('prisma_faq')
            ->label('أسئلة شائعة (Prisma)')
            ->icon('heroicon-o-question-mark-circle')
            ->schema([
                        TextInput::make('title')
                            ->label('العنوان الرئيسي')
                            ->default('الأسئلة الشائعة')
                            ->live(debounce: 700),
                Section::make('Header Config')
                    ->schema([
                        Toggle::make('show_icon')
                            ->label('Show Title Icon')
                            ->default(true),
                    ]),
                
                Section::make('Questions')
                    ->schema([
                        Repeater::make('faqs')
                            ->label('FAQ Items')
                            ->schema([
                                        TextInput::make('question')
                                            ->label('السؤال')
                                            ->required(),
                                        Textarea::make('answer')
                                            ->label('الإجابة')
                                            ->rows(3)
                                            ->required(),                            ])
                            ->default([
                                [
                                    'question' => 'هل هناك تحضيرات خاصة قبل إجراء التحليل؟',
                                    'answer' => 'في حالة تحليل السكر التراكمي، لا يوجد تحضيرات خاصة. أما التحاليل الأخرى قد تحتاج إلى صيام حسب نوع التحليل، وسنقوم بإبلاغك بالتعليمات عند الحجز.',
                                ],
                                [
                                    'question' => 'هل يمكن إجراء التحليل في المنزل؟',
                                    'answer' => 'نعم، نقدم خدمة السحب المنزلي المجانية داخل المدينة. سيصلك فريقنا المتخصص في الوقت المناسب لك.',
                                ],
                                [
                                    'question' => 'هل التقارير معتمدة؟',
                                    'answer' => 'نعم، جميع التقارير معتمدة من وزارة الصحة السعودية وتُرسل إلكترونياً فور اكتمالها.',
                                ],
                            ]),
                    ]),
                
                Section::make('Behavior')
                    ->schema([
                        Toggle::make('open_first')
                            ->label('Open First Item by Default')
                            ->default(true),
                        
                        Toggle::make('allow_multiple_open')
                            ->label('Allow Multiple Items Open')
                            ->default(false),
                        
                        Toggle::make('full_width')
                            ->label('Full Width Background')
                            ->default(true),
                    ])
                    ->columns(3),
            ]);
    }
}
