<?php

namespace App\Filament\Blocks;

use Filament\Forms\Components\Builder\Block;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\ColorPicker;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Grid;

class PrismaHeroGridBlock
{
    public static function make(): Block
    {
        return Block::make('prisma_hero_grid')
            ->label('شبكة صور (Prisma)')
            ->icon('heroicon-o-squares-plus')
            ->schema([
                Section::make('Layout')
                    ->schema([
                        Select::make('layout_type')
                            ->label('نوع التصميم')
                            ->options([
                                '4_images_grid' => '4 صور مع نص (Grid)',
                                '3_images_row' => '3 صور مع نص (Row)',
                                'images_only_grid' => 'صور فقط (بدون نص)',
                                'icons_grid' => 'أيقونات مع نص',
                                'mixed_grid' => 'صور وأيقونات مختلطة',
                            ])
                            ->default('4_images_grid')
                            ->live()
                            ->required(),
                        
                        Select::make('grid_columns')
                            ->label('عدد الأعمدة')
                            ->options([
                                '2' => 'عمودين',
                                '3' => '3 أعمدة',
                                '4' => '4 أعمدة',
                                '5' => '5 أعمدة',
                            ])
                            ->default('4'),
                        
                        Toggle::make('show_main_title')
                            ->label('إظهار عنوان رئيسي')
                            ->default(false),
                    ])
                    ->columns(3),
                
                        TextInput::make('main_title')
                            ->label('العنوان الرئيسي')
                            ->live(debounce: 700)
                            ->visible(fn ($get) => $get('show_main_title')),
                        
                        TextInput::make('main_subtitle')
                            ->label('العنوان الفرعي')
                            ->live(debounce: 700)
                            ->visible(fn ($get) => $get('show_main_title')),
                
                Section::make('العناصر')
                    ->schema([
                        Repeater::make('items')
                            ->label('العناصر')
                            ->schema([
                                Select::make('type')
                                    ->label('النوع')
                                    ->options([
                                        'image_text' => 'صورة + نص',
                                        'icon_text' => 'أيقونة + نص',
                                        'image_only' => 'صورة فقط',
                                        'icon_only' => 'أيقونة فقط',
                                    ])
                                    ->default('image_text')
                                    ->live(),
                                
                                FileUpload::make('image')
                                    ->label('الصورة')
                                    ->image()
                                    ->directory('hero-grid')
                                    ->visible(fn ($get) => inray($get('type'), ['image_text', 'image_only'])),
                                
                                Select::make('icon_type')
                                    ->label('مصدر الأيقونة')
                                    ->options([
                                        'library' => 'مكتبة أيقونات (FontAwesome)',
                                        'image'   => 'رفع صورة مخصصة',
                                    ])
                                    ->default('library')
                                    ->live()
                                    ->visible(fn ($get) => inray($get('type'), ['icon_text', 'icon_only'])),
                                
                                Select::make('icon')
                                    ->label('الأيقونة')
                                    ->searchable()
                                    ->options(\App\Support\IconOptions::fontAwesomeOptions())
                                    ->visible(fn ($get) => inray($get('type'), ['icon_text', 'icon_only']) && ($get('icon_type') ?? 'library') === 'library'),
                                
                                FileUpload::make('icon_image')
                                    ->label('صورة الأيقونة')
                                    ->image()
                                    ->directory('block-icons')
                                    ->visibility('public')
                                    ->imageEditor()
                                    ->maxSize(1024)
                                    ->visible(fn ($get) => inray($get('type'), ['icon_text', 'icon_only']) && ($get('icon_type') ?? 'library') === 'image'),
                                
                                ColorPicker::make('icon_bg_color')
                                    ->label('لون خلفية الأيقونة')
                                    ->default('#00A0B0')
                                    ->visible(fn ($get) => inray($get('type'), ['icon_text', 'icon_only'])),
                                
                                ColorPicker::make('icon_color')
                                    ->label('لون الأيقونة')
                                    ->default('#ffffff')
                                    ->visible(fn ($get) => inray($get('type'), ['icon_text', 'icon_only'])),
                                
                                        TextInput::make('title')
                                            ->label('العنوان')
                                            ->live(debounce: 700)
                                            ->visible(fn ($get) => inray($get('type'), ['image_text', 'icon_text'])),
                                        TextInput::make('subtitle')
                                            ->label('النص الفرعي')
                                            ->live(debounce: 700)
                                            ->visible(fn ($get) => inray($get('type'), ['image_text', 'icon_text'])),
                                
                                TextInput::make('url')
                                    ->label('الرابط')
                                    ->live(debounce: 700)
                                    ->placeholder('مثال: /packages/blood-tests'),
                                
                                Toggle::make('highlight')
                                    ->label('تمييز العنصر')
                                    ->visible(fn ($get) => inray($get('type'), ['image_text', 'icon_text'])),
                            ])
                            ->collapsible()
                            ->itemLabel(fn (array $state): ?string => $state['title'] ?? ($state['type'] === 'image_only' ? 'صورة' : 'عنصر'))
                            ->defaultItems(4)
                            ->minItems(1)
                            ->maxItems(8),
                    ]),
                
                Section::make('التصميم')
                    ->schema([
                        ColorPicker::make('bg_color')
                            ->label('لون الخلفية')
                            ->default('#F8FAFC'),
                        
                        Toggle::make('show_border')
                            ->label('إظهار حدود')
                            ->default(true),
                        
                        Toggle::make('rounded_corners')
                            ->label('زوايا دائرية')
                            ->default(true),
                        
                        Toggle::make('hover_effect')
                            ->label('تأثير التحويم')
                            ->default(true),
                        
                        TextInput::make('gap')
                            ->label('المسافة بين العناصر (px)')
                            ->numeric()
                            ->default(24),
                    ])
                    ->columns(3),
            ]);
    }
}
