<?php

namespace App\Filament\Blocks;

use Filament\Forms\Components\Builder\Block;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\ColorPicker;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Repeater;

class PrismaPackagesBlock
{
    public static function make(): Block
    {
        return Block::make('prisma_packages')
            ->label('باقات (Prisma)')
            ->icon('heroicon-o-credit-card')
            ->schema([
                        TextInput::make('badge_text')
                            ->label('نص الشارة')
                            ->default('عروض الموسم المميزة')
                            ->live(debounce: 700),
                        
                        TextInput::make('title')
                            ->label('العنوان الرئيسي')
                            ->default('باقات مختبرات بريزما')
                            ->live(debounce: 700),
                        
                        Textarea::make('subtitle')
                            ->label('العنوان الفرعي')
                            ->default('استفد من عرض: اختر باقتين واحصل على الثالثة مجاناً!')
                            ->rows(2)
                            ->live(debounce: 700),
                        
                        TextInput::make('button_text')
                            ->label('نص الزر')
                            ->default('تفاصيل الباقة')
                            ->live(debounce: 700),
                Section::make('فئات الأسعار / Price Categories')
                    ->schema([
                        Repeater::make('package_categories')
                            ->label('فئات الباقات / Categories')
                            ->schema([
                                        TextInput::make('category_name')
                                            ->label('اسم الفئة')
                                            ->required(),
                                Select::make('icon')
                                    ->label('أيقونة الفئة (التبويب)')
                                    ->options([
                                        'star' => '⭐ نجمة',
                                        'gem' => '💎 جوهرة',
                                        'crown' => '👑 تاج',
                                        'fire' => '🔥 نار',
                                        'tag' => '🏷️ تاق',
                                        'percent' => '% خصم',
                                        'check' => '✅ علامة صح',
                                    ])
                                    ->default('star')
                                    ->columnSpanFull(),
                                Select::make('packages')
                                    ->label('الباقات')
                                    ->multiple()
                                    ->options(\App\Models\Package::pluck('name', 'id'))
                                    ->searchable()
                                    ->columnSpanFull(),
                            ])
                            ->columns(2)
                            ->defaultItems(1)
                            ->reorderableWithButtons(),
                    ]),
                
                Section::make('إعدادات العرض')
                    ->schema([
                        Select::make('display_mode')
                            ->label('طريقة العرض')
                            ->options([
                                'grid' => 'شبكة (Grid) - عرض الكل',
                                'carousel' => 'كاروسيل (Carousel) - دوران تلقائي',
                            ])
                            ->default('grid')
                            ->live()
                            ->helperText('اختر كيف تريد عرض الباقات'),
                        
                        TextInput::make('carousel_speed')
                            ->label('سرعة الدوران (بالثواني)')
                            ->numeric()
                            ->default(5)
                            ->minValue(2)
                            ->maxValue(15)
                            ->visible(fn ($get) => $get('display_mode') === 'carousel')
                            ->helperText('كم ثانية قبل الانتقال للباقة التالية'),
                        
                        TextInput::make('packages_per_slide')
                            ->label('عدد الباقات في كل شريحة')
                            ->numeric()
                            ->default(4)
                            ->minValue(1)
                            ->maxValue(6)
                            ->visible(fn ($get) => $get('display_mode') === 'carousel')
                            ->helperText('كم باقة تظهر في نفس الوقت'),
                        
                        Toggle::make('show_carousel_dots')
                            ->label('إظهار النقاط (Dots)')
                            ->default(true)
                            ->visible(fn ($get) => $get('display_mode') === 'carousel'),
                        
                        Toggle::make('show_carouselrows')
                            ->label('إظهار الأسهم')
                            ->default(true)
                            ->visible(fn ($get) => $get('display_mode') === 'carousel'),
                    ])
                    ->columns(2),
                
                Section::make('إعدادات البطاقات')
                    ->schema([
                        Toggle::make('show_description')
                            ->label('إظهار الوصف')
                            ->default(true),
                        
                        Toggle::make('show_features')
                            ->label('إظهار المميزات')
                            ->default(true),
                        
                        Toggle::make('show_tests_count')
                            ->label('إظهار عدد التحاليل')
                            ->default(true),
                        
                        Toggle::make('show_old_price')
                            ->label('إظهار السعر القديم (التخفيض)')
                            ->default(true),
                        
                        Toggle::make('show_badge')
                            ->label('إظهار شارة "مميز"')
                            ->default(true),
                        
                        Toggle::make('card_hover_effect')
                            ->label('تأثير رفع البطاقة')
                            ->default(true),
                        
                        Select::make('image_aspect_ratio')
                            ->label('نسبة أبعاد الصورة')
                            ->options([
                                'video' => 'أفقي (16:10)',
                                'square' => 'مربع (1:1)',
                                'auto' => 'تلقائي',
                            ])
                            ->default('video'),
                        
                        Select::make('features_icon')
                            ->label('أيقونة المميزات')
                            ->options([
                                'check' => '✅ علامة صح',
                                'star' => '⭐ نجمة',
                                'dot' => '• نقطة',
                                'arrow' => '➝ سهم',
                            ])
                            ->default('check'),
                    ])
                    ->columns(3),

                Section::make('إعدادات الأزرار (Buttons)')
                    ->schema([
                        Repeater::make('buttons')
                            ->label('الأزرار')
                            ->schema([
                                TextInput::make('text')
                                    ->label('نص الزر')
                                    ->required(),
                                Select::make('action')
                                    ->label('إجراء الزر')
                                    ->options([
                                        'details' => 'فتح صفحة التفاصيل',
                                        'url' => 'رابط مخصص',
                                    ])
                                    ->default('details')
                                    ->live(),
                                TextInput::make('url')
                                    ->label('الرابط')
                                    ->required(fn($get) => $get('action') === 'url')
                                    ->visible(fn($get) => $get('action') === 'url'),
                                Select::make('style')
                                    ->label('ستايل الزر')
                                    ->options([
                                        'primary' => 'أساسي (Gradient)',
                                        'outline' => 'إطار (Outline)',
                                    ])
                                    ->default('primary'),
                                ColorPicker::make('color')
                                    ->label('لون الزر')
                                    ->helperText('اتركه فارغاً لاستخدام الألوان الافتراضية'),
                            ])
                            ->maxItems(2)
                            ->defaultItems(2)
                            ->columns(2)
                            ->itemLabel(fn (array $state): ?string => $state['text'] ?? 'زر جديد'),
                    ]),
                
                Section::make('الألوان')
                    ->schema([
                        ColorPicker::make('badge_bg_color')
                            ->label('لون خلفية الشارة')
                            ->default('#00A0B0'),
                        
                        ColorPicker::make('featured_badge_color')
                            ->label('لون شارة "مميز"')
                            ->default('#F59E0B'),
                        
                        ColorPicker::make('price_color')
                            ->label('لون السعر')
                            ->default('#1A365D'),
                        
                        ColorPicker::make('old_price_color')
                            ->label('لون السعر القديم')
                            ->default('#999999'),
                        
                        ColorPicker::make('button_bg_color')
                            ->label('لون خلفية الزر')
                            ->default('#00A0B0'),
                        
                        ColorPicker::make('button_text_color')
                            ->label('لون نص الزر')
                            ->default('#FFFFFF'),
                    ])
                    ->columns(3)
                    ->collapsed(),
            ]);
    }
}
