<?php

namespace App\Filament\Widgets;

use App\Filament\Resources\PackageResource;
use App\Filament\Resources\TestCategoryResource;
use App\Filament\Resources\TestResource;
use App\Models\Package;
use App\Models\Test;
use App\Models\TestCategory;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class PrismaStatsWidget extends BaseWidget
{
    protected static ?int $sort = 1;

    protected function getStats(): array
    {
        return [
            Stat::make('Packages', Package::count())
                ->description('Total packages')
                ->descriptionIcon('heroicon-o-beaker')
                ->color('success')
                ->url(PackageResource::getUrl('index')),

            Stat::make('Tests', Test::count())
                ->description('Medical tests')
                ->descriptionIcon('heroicon-o-clipboard-document-list')
                ->color('info')
                ->url(TestResource::getUrl('index')),

            Stat::make('Test Categories', TestCategory::count())
                ->description('Categories')
                ->descriptionIcon('heroicon-o-tag')
                ->color('warning')
                ->url(TestCategoryResource::getUrl('index')),
        ];
    }
}
