<?php

namespace App\Filament\Widgets;

use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class StatsOverviewWidget extends BaseWidget
{
    protected function getStats(): array
    {
        return [
            Stat::make('إجمالي الباقات النشطة', \App\Models\Package::where('is_active', true)->count())
                ->description('الباقات المتاحة للزوار')
                ->descriptionIcon('heroicon-m-briefcase')
                ->color('primary'),
            Stat::make('إجمالي الصفحات المنشورة', \App\Models\Page::where('is_published', true)->count())
                ->description('صفحات الموقع النشطة')
                ->descriptionIcon('heroicon-m-document-text')
                ->color('success'),
            Stat::make('إجمالي النماذج المستلمة', \App\Models\CustomFormSubmission::count())
                ->description('طلبات واستفسارات العملاء')
                ->descriptionIcon('heroicon-m-inbox-arrow-down')
                ->color('info'),
        ];
    }
}
