<?php

namespace App\Models;

use App\Traits\HasTranslations;
use Illuminate\Database\Eloquent\Model;

class CustomForm extends Model
{
    use HasTranslations;

    protected $fillable = [
        'name',
        'name_translations',
        'fields',
        'fields_translations',
        'send_email',
        'email_to',
        'email_subject',
        'send_whatsapp',
        'whatsapp_number',
        'whatsapp_message_template',
        'send_webhook',
        'webhook_url',
        'success_message',
        'success_message_translations',
        'submit_button_text',
        'submit_button_text_translations',
        'is_active',
    ];

    protected $casts = [
        'fields' => 'array',
        'fields_translations' => 'array',
        'name_translations' => 'array',
        'success_message_translations' => 'array',
        'submit_button_text_translations' => 'array',
        'send_email' => 'boolean',
        'send_whatsapp' => 'boolean',
        'send_webhook' => 'boolean',
        'is_active' => 'boolean',
    ];

    public function submissions()
    {
        return $this->hasMany(CustomFormSubmission::class);
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }
}
