<?php

namespace App\Providers;

use Filament\Support\Facades\FilamentView;
use Filament\View\PanelsRenderHook;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Page edit: form ~48% / preview ~52%, full width layout, no empty space
        FilamentView::registerRenderHook(PanelsRenderHook::STYLES_AFTER, function (): string {
            return '<style>
.page-edit-split { display: flex !important; gap: 1.5rem; width: 100%; }
.page-edit-split > div:first-child { flex: 0 0 48% !important; min-width: 360px; max-width: 640px; }
.page-edit-split > div:last-child { flex: 1 1 52% !important; min-width: 0; width: 100%; }
.page-edit-split .fi-fo-section-content { min-width: 0; }
.page-edit-preview-wrap { width: 100%; min-width: 0; }
</style>';
        });
    }
}
