<?php

namespace App\Providers;

use App\Settings\SiteSettings;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class ThemeServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Share site settings with all views
        View::composer('*', function ($view) {
            $settings = app(SiteSettings::class);
            $view->with('siteSettings', $settings);
        });

        // Share navigation with all views
        View::composer(['components.layouts.app', 'components.layouts.partials.header', 'components.layouts.partials.footer'], function ($view) {
            $headerMenu = \App\Models\Navigation::where('location', 'header')
                ->where('is_active', true)
                ->with(['children' => function ($query) {
                    $query->where('is_active', true)->orderBy('sort_order');
                }])
                ->whereNull('parent_id')
                ->orderBy('sort_order')
                ->get();

            $footerMenu = \App\Models\Navigation::where('location', 'footer')
                ->where('is_active', true)
                ->with(['children' => function ($query) {
                    $query->where('is_active', true)->orderBy('sort_order');
                }])
                ->whereNull('parent_id')
                ->orderBy('sort_order')
                ->get();

            $view->with('headerMenu', $headerMenu);
            $view->with('footerMenu', $footerMenu);
        });
    }
}
