<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Kalnoy\Nestedset\NestedSet;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('navigations', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('url')->nullable();
            $table->enum('location', ['header', 'footer'])->default('header');
            $table->enum('type', ['custom', 'page', 'package'])->default('custom');
            $table->enum('target', ['_self', '_blank'])->default('_self');
            $table->foreignId('parent_id')->nullable()->constrained('navigations')->onDelete('cascade');
            $table->foreignId('page_id')->nullable()->constrained('pages')->onDelete('cascade');
            $table->unsignedBigInteger('package_id')->nullable();
            $table->integer('sort_order')->default(0);
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            // Nested set columns
            $table->unsignedInteger('_lft')->default(0);
            $table->unsignedInteger('_rgt')->default(0);

            $table->index(['location', 'is_active']);
            $table->index('parent_id');
            $table->index(['_lft', '_rgt']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('navigations');
    }
};
