<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('tests', function (Blueprint $table) {
            // Bilingual translation columns
            $table->json('name_translations')->nullable()->after('name');
            $table->json('description_translations')->nullable()->after('description');
            $table->json('short_description_translations')->nullable()->after('short_description');

            // Category FK
            $table->foreignId('test_category_id')
                ->nullable()
                ->after('is_active')
                ->constrained('test_categories')
                ->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::table('tests', function (Blueprint $table) {
            $table->dropConstrainedForeignId('test_category_id');
            $table->dropColumn([
                'name_translations',
                'description_translations',
                'short_description_translations',
            ]);
        });
    }
};
