<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('package_sections', function (Blueprint $table) {
            $table->foreignId('test_category_id')->nullable()->after('package_id')->constrained('test_categories')->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::table('package_sections', function (Blueprint $table) {
            $table->dropForeign(['test_category_id']);
        });
    }
};
