<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('custom_forms', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->json('fields')->nullable();
            
            // Email Settings
            $table->boolean('send_email')->default(false);
            $table->string('email_to')->nullable();
            $table->string('email_subject')->nullable();
            
            // WhatsApp Settings
            $table->boolean('send_whatsapp')->default(false);
            $table->string('whatsapp_number')->nullable();
            $table->text('whatsapp_message_template')->nullable();
            
            // Webhook / Google Sheets Settings
            $table->boolean('send_webhook')->default(false);
            $table->string('webhook_url')->nullable();
            
            // UI Settings
            $table->text('success_message')->nullable();
            $table->string('submit_button_text')->default('إرسال');
            $table->boolean('is_active')->default(true);
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('custom_forms');
    }
};
