<?php

namespace Database\Seeders;

use App\Models\Page;
use Illuminate\Database\Seeder;

class HomepageSeeder extends Seeder
{
    public function run(): void
    {
        // Create Homepage if not exists
        if (!Page::where('is_homepage', true)->exists()) {
            Page::create([
                'title' => 'مختبرات بريزما الطبية',
                'slug' => 'home',
                'meta_title' => 'مختبرات بريزما الطبية - فحوصات معتمدة ونتائج دقيقة',
                'meta_description' => 'مختبرات بريزما الطبية تقدم فحوصات معتمدة ونتائج دقيقة بأسعار تنافسية. خدمة السحب المنزلي مجاناً.',
                'content' => [
                    [
                        'type' => 'prisma_hero',
                        'data' => [
                            'title' => 'صحتك تبدأ بفحص دقيق',
                            'subtitle' => 'نتائج موثوقة خلال 24 ساعة مع خدمة السحب المنزلي المجانية',
                            'cta_text' => 'احجز الآن',
                            'cta_url' => '#packages',
                            'full_width' => true,
                            'show_pattern' => true,
                            'layout_design' => 'premium',
                            'categories' => [
                                [
                                    'name' => 'الفحص الشامل',
                                    'url' => '#packages',
                                    'use_image' => false,
                                    'icon' => 'fas fa-heartbeat',
                                    'text_position' => 'overlay',
                                    'overlay_style' => 'gradient',
                                ],
                                [
                                    'name' => 'تحاليل الدم',
                                    'url' => '#packages',
                                    'use_image' => false,
                                    'icon' => 'fas fa-vial',
                                    'text_position' => 'overlay',
                                    'overlay_style' => 'gradient',
                                ],
                                [
                                    'name' => 'الفحص الهرموني',
                                    'url' => '#packages',
                                    'use_image' => false,
                                    'icon' => 'fas fa-dna',
                                    'text_position' => 'overlay',
                                    'overlay_style' => 'gradient',
                                ],
                                [
                                    'name' => 'فحص الفيتامينات',
                                    'url' => '#packages',
                                    'use_image' => false,
                                    'icon' => 'fas fa-pills',
                                    'text_position' => 'overlay',
                                    'overlay_style' => 'gradient',
                                ],
                            ],
                        ],
                    ],
                    [
                        'type' => 'prisma_categories',
                        'data' => [
                            'show_from_database' => true,
                            'limit' => 8,
                            'show_names' => true,
                            'card_style' => true,
                        ],
                    ],
                    [
                        'type' => 'prisma_packages',
                        'data' => [
                            'badge_text' => 'عروض الموسم المميزة',
                            'title' => 'باقات مختبرات بريزما',
                            'subtitle' => 'استفد من عرض: اختر باقتين واحصل على الثالثة مجاناً!',
                            'show_tier_99' => true,
                            'show_tier_199' => true,
                            'show_tier_299' => true,
                            'tier_99_label' => 'باقات 99 ريال',
                            'tier_199_label' => 'باقات 199 ريال',
                            'tier_299_label' => 'باقات 299 ريال',
                            'show_description' => true,
                            'show_features' => true,
                            'show_badge' => true,
                            'show_tests_count' => true,
                            'show_old_price' => true,
                            'card_hover_effect' => true,
                        ],
                    ],
                    [
                        'type' => 'prisma_about',
                        'data' => [
                            'title' => 'مختبرات بريزما الطبية – شريكك الصحي الموثوق',
                            'description' => 'مختبرات بريزما الطبية هي مختبر تحاليل معتمد يقدّم خدمات مخبرية متكاملة باستخدام أحدث الأجهزة الطبية، وبإشراف نخبة من المختصين، مع الالتزام بأعلى معايير الجودة والدقة.',
                            'button_text' => 'اكتشف الباقات',
                            'button_url' => '/packages',
                            'show_call_button' => true,
                            'show_default_icon' => true,
                            'show_stats' => true,
                            'stats' => [
                                ['value' => '24', 'label' => 'ساعة نتائج'],
                                ['value' => '100%', 'label' => 'معتمد'],
                                ['value' => 'مجاناً', 'label' => 'السحب المنزلي'],
                            ],
                            'image_on_right' => false,
                            'full_width' => true,
                        ],
                    ],
                    [
                        'type' => 'prisma_services',
                        'data' => [
                            'title' => 'خدماتنا المميزة',
                            'subtitle' => 'نقدم لك مجموعة متكاملة من الخدمات المخبرية بأعلى معايير الجودة',
                            'services' => [
                                ['title' => 'تحاليل الدم الشاملة', 'description' => 'فحوصات دم دقيقة تشمل جميع المؤشرات الحيوية مع تقارير مفصلة', 'icon' => 'fas fa-flask'],
                                ['title' => 'تحاليل البول والبراز', 'description' => 'تحاليل دقيقة للكشف عن الأمراض والالتهابات والأملاح', 'icon' => 'fas fa-vial'],
                                ['title' => 'تحاليل هرمونية', 'description' => 'فحص شامل لمناعة الجسم والأجسام المضادة لمختلف الأمراض', 'icon' => 'fas fa-dna'],
                                ['title' => 'سحب منزلي مجاني', 'description' => 'نأتيك أينما كنت داخل المدينة مع خدمة سحب عينات مجانية', 'icon' => 'fas fa-home'],
                            ],
                            'show_icon_background' => true,
                            'card_border' => true,
                            'center_align' => true,
                        ],
                    ],
                    [
                        'type' => 'prisma_faq',
                        'data' => [
                            'title' => 'الأسئلة الشائعة',
                            'show_icon' => true,
                            'faqs' => [
                                [
                                    'question' => 'هل هناك تحضيرات خاصة قبل إجراء التحليل؟',
                                    'answer' => 'في حالة تحليل السكر التراكمي، لا يوجد تحضيرات خاصة. أما التحاليل الأخرى قد تحتاج إلى صيام حسب نوع التحليل، وسنقوم بإبلاغك بالتعليمات عند الحجز.'
                                ],
                                [
                                    'question' => 'هل يمكن إجراء التحليل في المنزل؟',
                                    'answer' => 'نعم، نقدم خدمة السحب المنزلي المجانية داخل المدينة. سيصلك فريقنا المتخصص في الوقت المناسب لك.'
                                ],
                                [
                                    'question' => 'هل التقارير معتمدة؟',
                                    'answer' => 'نعم، جميع التقارير معتمدة من وزارة الصحة السعودية وتُرسل إلكترونياً فور اكتمالها.'
                                ],
                            ],
                            'open_first' => true,
                            'allow_multiple_open' => false,
                            'full_width' => true,
                        ],
                    ],
                    [
                        'type' => 'prisma_cta',
                        'data' => [
                            'title' => 'جاهز للحجز؟',
                            'subtitle' => 'احجز الآن واحصل على خصم 10% على أول تحليل لك',
                            'button_text' => 'احجز عبر الواتساب',
                            'button_url' => '#',
                            'button_icon' => 'whatsapp',
                            'bg_color_start' => '#00A0B0',
                            'bg_color_end' => '#2D9CDB',
                            'rounded_corners' => true,
                            'full_width' => false,
                            'margin_top' => true,
                        ],
                    ],
                ],
                'is_published' => true,
                'is_homepage' => true,
                'sort_order' => 0,
            ]);
            
            $this->command->info('Homepage created successfully with Page Builder blocks!');
        }
    }
}
