<?php

use Spatie\LaravelSettings\Migrations\SettingsBlueprint;
use Spatie\LaravelSettings\Migrations\SettingsMigration;

return new class extends SettingsMigration
{
    public function up(): void
    {
        $this->migrator->inGroup('site', function (SettingsBlueprint $blueprint): void {
            $blueprint->add('site_name', 'مختبرات بريزما الطبية');
            $blueprint->addEncrypted('logo_light', null);
            $blueprint->addEncrypted('logo_dark', null);
            $blueprint->addEncrypted('favicon', null);
            
            $blueprint->add('color_primary', '#1A365D');
            $blueprint->add('color_secondary', '#00A0B0');
            $blueprint->add('color_accent', '#2D9CDB');
            $blueprint->add('color_light', '#F8FAFC');
            $blueprint->add('color_text', '#334155');
            $blueprint->add('footer_bg', '#1A365D');
            
            $blueprint->add('font_family', 'Cairo');
            $blueprint->add('font_heading', 'Cairo');
            $blueprint->add('base_size', 16);
            $blueprint->add('direction', 'rtl');
            
            $blueprint->addEncrypted('contact_phone', '920000000');
            $blueprint->addEncrypted('contact_email', 'info@prisma.sa');
            $blueprint->addEncrypted('contact_address', 'جدة، المملكة العربية السعودية');
            $blueprint->addEncrypted('contact_whatsapp', '966500000000');
            $blueprint->addEncrypted('working_hours', '24 ساعة');
            $blueprint->addEncrypted('copyright_text', null);
            
            $blueprint->addEncrypted('social_facebook', null);
            $blueprint->addEncrypted('social_twitter', null);
            $blueprint->addEncrypted('social_instagram', null);
            $blueprint->addEncrypted('social_linkedin', null);
            $blueprint->addEncrypted('social_youtube', null);
            $blueprint->addEncrypted('social_snapchat', null);
            $blueprint->addEncrypted('social_tiktok', null);
            
            $blueprint->add('meta_title', 'مختبرات بريزما الطبية - فحوصات معتمدة ونتائج دقيقة');
            $blueprint->add('meta_description', 'مختبرات بريزما الطبية تقدم فحوصات معتمدة ونتائج دقيقة بأسعار تنافسية. خدمة السحب المنزلي مجاناً.');
            $blueprint->add('meta_keywords', 'مختبر, تحاليل, فحوصات طبية, بريزما, الرياض');
            $blueprint->addEncrypted('google_analytics', null);
            $blueprint->addEncrypted('facebook_pixel', null);
            
            $blueprint->add('show_hero', true);
            $blueprint->add('show_categories', true);
            $blueprint->add('show_packages_99', true);
            $blueprint->add('show_packages_199', true);
            $blueprint->add('show_packages_299', true);
            $blueprint->add('show_about', true);
            $blueprint->add('show_services', true);
            $blueprint->add('show_faq', true);
            $blueprint->add('show_stats', true);
            
            $blueprint->add('hero_title', 'صحتك تبدأ بفحص دقيق');
            $blueprint->add('hero_subtitle', 'نتائج موثوقة خلال 24 ساعة مع خدمة السحب المنزلي المجانية');
            $blueprint->add('hero_cta_text', 'احجز الآن');
            $blueprint->add('hero_cta_url', '#packages');
            $blueprint->addEncrypted('hero_background', null);
            
            $blueprint->add('stat_1_value', '24');
            $blueprint->add('stat_1_label', 'ساعة نتائج');
            $blueprint->add('stat_2_value', '100%');
            $blueprint->add('stat_2_label', 'معتمد');
            $blueprint->add('stat_3_value', 'مجاناً');
            $blueprint->add('stat_3_label', 'السحب المنزلي');
            
            $blueprint->add('about_title', 'مختبرات بريزما الطبية – شريكك الصحي الموثوق');
            $blueprint->add('about_description', 'مختبرات بريزما الطبية هي مختبر تحاليل معتمد يقدّم خدمات مخبرية متكاملة باستخدام أحدث الأجهزة الطبية، وبإشراف نخبة من المختصين، مع الالتزام بأعلى معايير الجودة والدقة.');
            $blueprint->addEncrypted('about_image', null);
            
            $blueprint->add('promo_badge_text', 'عروض الموسم المميزة');
            $blueprint->add('promo_title', 'باقات مختبرات بريزما');
            $blueprint->add('promo_subtitle', 'استفد من عرض: اختر باقتين واحصل على الثالثة مجاناً!');
        });
    }
};
