<?php

use Spatie\LaravelSettings\Migrations\SettingsMigration;

return new class extends SettingsMigration
{
    public function up(): void
    {
        // Booking sidebar visibility toggles
        $this->migrator->add('site.show_booking_form', true);
        $this->migrator->add('site.show_whatsapp_booking', true);
        $this->migrator->add('site.show_credit_payment', false); // Hidden by default since not implemented
        $this->migrator->add('site.show_installment_note', true);

        // Booking button texts
        $this->migrator->add('site.booking_btn_text', 'احجز مجاناً الآن');
        $this->migrator->add('site.whatsapp_btn_text', 'احجز عبر واتساب');
        $this->migrator->add('site.credit_btn_text', 'احجز بالدفع (تمارا / تابي / بطاقة)');

        // Form labels
        $this->migrator->add('site.booking_form_name_label', 'الاسم (مطلوب)');
        $this->migrator->add('site.booking_form_name_placeholder', 'أدخل اسمك');
        $this->migrator->add('site.booking_form_phone_label', 'رقم الجوال (مطلوب)');
        $this->migrator->add('site.booking_form_phone_placeholder', '05xxxxxxxx');
        $this->migrator->add('site.booking_form_note_label', 'ملاحظة (اختياري)');
        $this->migrator->add('site.booking_form_note_placeholder', 'أي ملاحظات إضافية...');

        // WhatsApp message template
        $this->migrator->add('site.whatsapp_message_template', 'مرحباً، أود الحجز:\nالباقة: {package}\nالاسم: {name}\nالجوال: {phone}');

        // Installment note
        $this->migrator->add('site.installment_note_text', 'قسّط مبلغ الباقة على 4 أقساط بدون فوائد عبر تمارا أو تابي');

        // Booking success message
        $this->migrator->add('site.booking_success_message', 'تم إرسال طلبك بنجاح! سنتواصل معك قريباً.');

        // Package page settings
        $this->migrator->add('site.package_page_title', 'باقات الفحوصات الطبية');
        $this->migrator->add('site.package_page_subtitle', 'باقات فحص شاملة بأفضل الأسعار — نتائج دقيقة ومعتمدة من وزارة الصحة مع خدمة السحب المنزلي المجانية');
    }
};
