@props(['data' => []])

@php

    $title = $data['title'] ?? "";
    $description = $data['description'] ?? "";
    $background_image = $data['background_image'] ?? '';
    $background_color = $data['background_color'] ?? '#0ea5e9';
    $text_color = $data['text_color'] ?? '#ffffff';
    $button_text = $data['button_text'] ?? "";
    $button_url = $data['button_url'] ?? "";
    $secondary_button_text = $data['secondary_button_text'] ?? "";
    $secondary_button_url = $data['secondary_button_url'] ?? "";
    $alignment = $data['alignment'] ?? 'center';
    $alignmentClass = match($alignment) {
        'left' => 'text-left items-start',
        'right' => 'text-right items-end',
        default => 'text-center items-center',
    };

    $resolveUploadValue = function (mixed $value) use (&$resolveUploadValue): ?string {
        if (is_string($value) && $value !== '') {
            return $value;
        }

        if (! is_array($value)) {
            return null;
        }

        foreach (['path', 'url', 'temporaryUrl', 'preview_url'] as $key) {
            if (! empty($value[$key]) && is_string($value[$key])) {
                return $value[$key];
            }
        }

        foreach ($value as $item) {
            $resolved = $resolveUploadValue($item);
            if ($resolved) {
                return $resolved;
            }
        }

        return null;
    };

    $resolvedBackgroundImage = $resolveUploadValue($background_image);
    $backgroundImageUrl = null;
    if (is_string($resolvedBackgroundImage) && $resolvedBackgroundImage !== '') {
        if (str_starts_with($resolvedBackgroundImage, 'http://') || str_starts_with($resolvedBackgroundImage, 'https://') || str_starts_with($resolvedBackgroundImage, 'data:')) {
            $backgroundImageUrl = $resolvedBackgroundImage;
        } elseif (str_starts_with($resolvedBackgroundImage, '/storage/')) {
            $backgroundImageUrl = url($resolvedBackgroundImage);
        } else {
            $backgroundImageUrl = asset('storage/' . ltrim($resolvedBackgroundImage, '/'));
        }
    }
@endphp

<section class="relative py-24 overflow-hidden">
    {{-- Background --}}
    @if($backgroundImageUrl)
        <div class="absolute inset-0">
            <img src="{{ $backgroundImageUrl }}" 
                 alt=""
                 class="w-full h-full object-cover">
            <div class="absolute inset-0" style="background-color: {{ $background_color }}; opacity: 0.9"></div>
        </div>
    @else
        <div class="absolute inset-0" style="background-color: {{ $background_color }}"></div>
    @endif
    
    {{-- Content --}}
    <div class="relative max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex flex-col {{ $alignmentClass }}">
            <h2 class="text-3xl md:text-4xl lg:text-5xl font-bold mb-6" style="color: {{ $text_color }}">
                {{ $title }}
            </h2>
            @if($description)
                <p class="text-lg md:text-xl opacity-90 mb-8 max-w-2xl" style="color: {{ $text_color }}">
                    {!! $description !!}
                </p>
            @endif
            <div class="flex flex-wrap gap-4 {{ $alignment === 'center' ? 'justify-center' : ($alignment === 'right' ? 'justify-end' : 'justify-start') }}">
                @if($button_text && $button_url)
                    <a href="{{ $button_url }}" 
                       class="inline-flex items-center px-8 py-4 bg-white font-semibold rounded-lg hover:bg-gray-100 transition-all transform hover:scale-105 shadow-lg"
                       style="color: {{ $background_color }}">
                        {{ $button_text }}
                        <svg class="w-5 h-5 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path>
                        </svg>
                    </a>
                @endif
                @if($secondary_button_text && $secondary_button_url)
                    <a href="{{ $secondary_button_url }}" 
                       class="inline-flex items-center px-8 py-4 border-2 border-white font-semibold rounded-lg hover:bg-white hover:bg-opacity-10 transition-all"
                       style="color: {{ $text_color }}; border-color: {{ $text_color }}">
                        {{ $secondary_button_text }}
                    </a>
                @endif
            </div>
        </div>
    </div>
</section>
