@props(['data' => []])

@php

    $html_content = $data['html_content'] ?? "";
    $full_width = $data['full_width'] ?? false;
    $add_container = $data['add_container'] ?? true;
@endphp

@if($full_width)
    <div @class(['py-8' => $add_container])>
        {!! $html_content !!}
    </div>
@else
    <div @class(['py-8' => $add_container])>
        <div class="{{ $add_container ? 'max-w-7xl mx-auto px-4 sm:px-6 lg:px-8' : '' }}">
            {!! $html_content !!}
        </div>
    </div>
@endif
