@php

$title = $data['title'] ?? "";
$subtitle = $data['subtitle'] ?? "";
$buttonText = $data['button_text'] ?? "";
$buttonUrl = $data['button_url'] ?? '#';
$buttonIcon = $data['button_icon'] ?? 'whatsapp';
$bgColorStart = $data['bg_color_start'] ?? '#1A365D';
$rounded = $data['rounded_corners'] ?? true;
$fullWidth = $data['full_width'] ?? true;
$marginTop = $data['margin_top'] ?? true;

$iconClass = match($buttonIcon) {
    'whatsapp' => 'fab fa-whatsapp',
    'phone' => 'fas fa-phone',
    'arrow' => 'fas fa-arrow-left',
    'calendar' => 'fas fa-calendar-check',
    default => 'fab fa-whatsapp',
};
@endphp

<section class="cta-section" style="padding: 100px 20px; background: linear-gradient(135deg, {{ $bgColorStart }} 0%, {{ $bgColorEnd }} 100%); position: relative; overflow: hidden; {{ $rounded ? 'border-radius: 30px;' : '' }} {{ $fullWidth ? '' : 'margin: ' . ($marginTop ? '60px 20px' : '0 20px') . ';' }} text-align: center;">
    {{-- High-Fidelity Background Effect --}}
    <div style="position: absolute; inset: 0; opacity: 0.1; background-image: radial-gradient(white 1px, transparent 1px); background-size: 20px 20px;"></div>
    <div style="position: absolute; top: -50%; left: -50%; width: 200%; height: 200%; background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 60%); pointer-events: none;"></div>

    <div style="position: relative; z-index: 1; max-width: 800px; margin: 0 auto;">
        <h2 style="font-size: 3rem; font-weight: 800; color: white; margin-bottom: 20px; font-family: 'Cairo', sans-serif; text-shadow: 0 2px 10px rgba(0,0,0,0.1);">
            {{ $title }}
        </h2>
        <p style="color: rgba(255,255,255,0.95); font-size: 1.3rem; margin-bottom: 40px; font-weight: 500; line-height: 1.6;">
            {{ $subtitle }}
        </p>
        <div style="display: flex; justify-content: center; gap: 20px; flex-wrap: wrap;">
            <a href="{{ $buttonUrl }}" style="padding: 18px 45px; background: white; color: #1A365D; border-radius: 50px; font-weight: 800; font-size: 1.15rem; text-decoration: none; display: inline-flex; align-items: center; gap: 12px; box-shadow: 0 15px 35px rgba(0,0,0,0.15); transition: all 0.3s;">
                <i class="{{ $iconClass }}" style="font-size: 1.3rem; color: #00A0B0;"></i>
                {{ $buttonText }}
            </a>
        </div>
    </div>
</section>

<style>
    .cta-section a:hover {
        transform: translateY(-5px);
        box-shadow: 0 20px 45px rgba(0,0,0,0.2);
        background: #f8fafc;
    }
</style>
