<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Prisma Visual Builder</title>
    
    @php
        $siteSettings = $siteSettings ?? app(\App\Settings\SiteSettings::class);
    @endphp

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family={{ urlencode($siteSettings->font_family ?? 'Cairo') }}:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    
    <!-- Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Tailwind CSS (needed by block components) -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '{{ $siteSettings->color_primary ?? '#1A365D' }}',
                        secondary: '{{ $siteSettings->color_secondary ?? '#00A0B0' }}',
                        accent: '{{ $siteSettings->color_accent ?? '#2D9CDB' }}',
                        light: '{{ $siteSettings->color_light ?? '#F8FAFC' }}',
                        text: '{{ $siteSettings->color_text ?? '#334155' }}',
                    },
                    fontFamily: {
                        sans: ['{{ $siteSettings->font_family ?? 'Cairo' }}', 'sans-serif'],
                        heading: ['{{ $siteSettings->font_heading ?? 'Cairo' }}', 'sans-serif'],
                    },
                },
            },
        }
    </script>

    <!-- Alpine.js & Livewire -->
    @livewireStyles
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    
    <!-- Site-wide CSS variables used by block components -->
    <style>
        :root {
            --pr-primary: {{ $siteSettings->color_primary ?? '#1A365D' }};
            --pr-secondary: {{ $siteSettings->color_secondary ?? '#00A0B0' }};
            --pr-accent: {{ $siteSettings->color_accent ?? '#2D9CDB' }};
            --pr-light: {{ $siteSettings->color_light ?? '#F8FAFC' }};
            --pr-text: {{ $siteSettings->color_text ?? '#334155' }};
            --pr-white: #ffffff;
            --pr-gray: #E8ECF1;
            --pr-radius: 12px;
            --pr-radius-lg: 16px;
            --pr-shadow: 0 4px 20px rgba(26, 54, 93, 0.08);
            --pr-shadow-card: 0 8px 32px rgba(26, 54, 93, 0.08);
            --pr-gradient: linear-gradient(135deg, {{ $siteSettings->color_secondary ?? '#00A0B0' }} 0%, {{ $siteSettings->color_accent ?? '#2D9CDB' }} 100%);
            --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        body {
            margin: 0;
            padding: 0;
            overflow: hidden;
            background: #f1f5f9;
            font-family: '{{ $siteSettings->font_family ?? 'Cairo' }}', sans-serif;
            color: #1e293b;
        }

        h1, h2, h3, h4, h5, h6 {
            font-family: '{{ $siteSettings->font_heading ?? 'Cairo' }}', sans-serif;
        }

        /* Tactile background feel */
        body::before {
            content: "";
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: url("data:image/svg+xml,%3Csvg viewBox='0 0 200 200' xmlns='http://www.w3.org/2000/svg'%3E%3Cfilter id='noiseFilter'%3E%3CfeTurbulence type='fractalNoise' baseFrequency='0.65' numOctaves='3' stitchTiles='stitch'/%3E%3C/filter%3E%3Crect width='100%25' height='100%25' filter='url(%23noiseFilter)'/%3E%3C/svg%3E");
            opacity: 0.03;
            pointer-events: none;
            z-index: 1000;
        }

        /* Button styles used by block components */
        .btn-primary {
            background: var(--pr-gradient);
            color: white;
            padding: 12px 24px;
            border-radius: 50px;
            font-weight: 700;
            transition: var(--transition);
            border: none;
            cursor: pointer;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            text-decoration: none;
        }
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 24px rgba(0, 160, 176, 0.4);
            color: white;
        }

        .text-gradient {
            background: var(--pr-gradient);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
    </style>
</head>
<body>
    {{ $slot }}

    @livewireScripts
</body>
</html>
