<footer style="background: #0a0a0a; color: rgba(255,255,255,0.85); padding: 40px 20px 25px; margin-top: 60px;">
    <div class="footer-container" style="max-width: 1300px; margin: 0 auto; display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 30px; align-items: start;">
        
        {{-- Contact Info --}}
        <div class="footer-section">
            <h3 class="footer-title" style="color: var(--pr-secondary); font-size: 1.1rem; font-weight: 800; margin-bottom: 15px; font-family: 'Cairo', sans-serif;">معلومات التواصل</h3>
            <p class="footer-item" style="display: flex; align-items: center; gap: 10px; margin-bottom: 12px; font-size: 0.95rem; color: rgba(255,255,255,0.85);">
                <i class="fas fa-map-marker-alt" style="color: var(--pr-secondary);"></i>
                {{ $siteSettings->contact_address ?? 'جدة، المملكة العربية السعودية' }}
            </p>
            @if($siteSettings->contact_phone)
                <p class="footer-item" style="display: flex; align-items: center; gap: 10px; margin-bottom: 12px; font-size: 0.95rem;">
                    <i class="fas fa-phone" style="color: var(--pr-secondary);"></i>
                    <a href="tel:{{ $siteSettings->contact_phone }}" style="color: rgba(255,255,255,0.85); text-decoration: none; transition: var(--transition);">
                        {{ $siteSettings->contact_phone }}
                    </a>
                </p>
            @endif
            @if($siteSettings->contact_whatsapp)
                <p class="footer-item" style="display: flex; align-items: center; gap: 10px; margin-bottom: 12px; font-size: 0.95rem;">
                    <i class="fab fa-whatsapp" style="color: var(--pr-secondary);"></i>
                    <a href="https://wa.me/{{ $siteSettings->contact_whatsapp }}" style="color: rgba(255,255,255,0.85); text-decoration: none; transition: var(--transition);" target="_blank">
                        {{ $siteSettings->contact_whatsapp }}
                    </a>
                </p>
            @endif
            @if($siteSettings->contact_email)
                <p class="footer-item" style="display: flex; align-items: center; gap: 10px; margin-bottom: 12px; font-size: 0.95rem;">
                    <i class="fas fa-envelope" style="color: var(--pr-secondary);"></i>
                    <a href="mailto:{{ $siteSettings->contact_email }}" style="color: rgba(255,255,255,0.85); text-decoration: none; transition: var(--transition);">
                        {{ $siteSettings->contact_email }}
                    </a>
                </p>
            @endif
            
            {{-- Social Links --}}
            <div class="social-links" style="display: flex; gap: 10px; margin-top: 20px;">
                @if($siteSettings->social_facebook)
                    <a href="{{ $siteSettings->social_facebook }}" style="width: 40px; height: 40px; border-radius: 50%; background: rgba(255,255,255,0.1); display: flex; align-items: center; justify-content: center; color: white; transition: var(--transition); text-decoration: none;" target="_blank">
                        <i class="fab fa-facebook-f"></i>
                    </a>
                @endif
                @if($siteSettings->social_twitter)
                    <a href="{{ $siteSettings->social_twitter }}" style="width: 40px; height: 40px; border-radius: 50%; background: rgba(255,255,255,0.1); display: flex; align-items: center; justify-content: center; color: white; transition: var(--transition); text-decoration: none;" target="_blank">
                        <i class="fab fa-twitter"></i>
                    </a>
                @endif
                @if($siteSettings->social_instagram)
                    <a href="{{ $siteSettings->social_instagram }}" style="width: 40px; height: 40px; border-radius: 50%; background: rgba(255,255,255,0.1); display: flex; align-items: center; justify-content: center; color: white; transition: var(--transition); text-decoration: none;" target="_blank">
                        <i class="fab fa-instagram"></i>
                    </a>
                @endif
                @if($siteSettings->social_youtube)
                    <a href="{{ $siteSettings->social_youtube }}" style="width: 40px; height: 40px; border-radius: 50%; background: rgba(255,255,255,0.1); display: flex; align-items: center; justify-content: center; color: white; transition: var(--transition); text-decoration: none;" target="_blank">
                        <i class="fab fa-youtube"></i>
                    </a>
                @endif
            </div>
        </div>
        
        {{-- Quick Links --}}
        <div class="footer-section">
            <h3 class="footer-title" style="color: var(--pr-secondary); font-size: 1.1rem; font-weight: 800; margin-bottom: 15px; font-family: 'Cairo', sans-serif;">{{ __('quick_links') }}</h3>
            <a href="{{ route('home') }}" style="display: block; margin-bottom: 10px; color: rgba(255,255,255,0.85); text-decoration: none; transition: var(--transition); font-size: 0.95rem;">{{ __('home') }}</a>
            <a href="{{ route('packages.index') }}" style="display: block; margin-bottom: 10px; color: rgba(255,255,255,0.85); text-decoration: none; transition: var(--transition); font-size: 0.95rem;">{{ __('packages') }}</a>
            @foreach($footerMenu as $item)
                <a href="{{ $item->url }}" style="display: block; margin-bottom: 10px; color: rgba(255,255,255,0.85); text-decoration: none; transition: var(--transition); font-size: 0.95rem;">
                    {{ $item->translated_title ?: __($item->title) }}
                </a>
            @endforeach
            @if($footerMenu->isEmpty())
                <a href="#about" style="display: block; margin-bottom: 10px; color: rgba(255,255,255,0.85); text-decoration: none; transition: var(--transition); font-size: 0.95rem;">{{ __('about_us') }}</a>
                <a href="#services" style="display: block; margin-bottom: 10px; color: rgba(255,255,255,0.85); text-decoration: none; transition: var(--transition); font-size: 0.95rem;">{{ __('our_services') }}</a>
            @endif
        </div>
        
        {{-- Opening Hours --}}
        <div class="footer-section">
            <h3 class="footer-title" style="color: var(--pr-secondary); font-size: 1.1rem; font-weight: 800; margin-bottom: 15px; font-family: 'Cairo', sans-serif;">ساعات العمل</h3>
            <p class="footer-item" style="display: flex; align-items: center; gap: 10px; margin-bottom: 10px; font-size: 0.95rem; color: rgba(255,255,255,0.85);">
                <i class="fas fa-clock" style="color: var(--pr-secondary);"></i>
                {{ $siteSettings->working_hours ?? 'الأحد - الخميس: 8 صباحاً - 10 مساءً' }}
            </p>
            <p class="footer-item" style="display: flex; align-items: center; gap: 10px; margin-bottom: 10px; font-size: 0.95rem; color: rgba(255,255,255,0.85);">
                <i class="fas fa-clock" style="color: var(--pr-secondary);"></i>
                الجمعة - السبت: 4 مساءً - 12 منتصف الليل
            </p>
        </div>
    </div>
    
    <div class="footer-bottom" style="text-align: center; padding-top: 25px; margin-top: 25px; border-top: 1px solid rgba(255,255,255,0.1); color: rgba(255,255,255,0.6); font-size: 0.85rem;">
        <p>{{ $siteSettings->copyright_text ?? '© ' . date('Y') . ' ' . $siteSettings->site_name . '. جميع الحقوق محفوظة.' }}</p>
    </div>
</footer>

<style>
    footer a:hover {
        color: var(--pr-secondary) !important;
    }
    
    .social-links a:hover {
        background: var(--pr-gradient) !important;
        transform: translateY(-3px);
    }
</style>
