{{-- Global Language Toggle for Filament Page Editor --}}
<style>
    /* Hide language content fields based on active lang */
    body.edit-ar .fi-fo-field-wrp[data-edit-lang="en"] { display: none !important; }
    body.edit-en .fi-fo-field-wrp[data-edit-lang="ar"] { display: none !important; }

    #page-lang-toggle {
        display: flex;
        align-items: center;
        gap: 12px;
        padding: 10px 16px;
        background: white;
        border-radius: 10px;
        border: 1.5px solid #e5e7eb;
        margin-bottom: 4px;
        box-shadow: 0 1px 4px rgba(0,0,0,0.06);
    }
    #page-lang-toggle .toggle-label {
        font-size: 0.75rem;
        font-weight: 700;
        color: #6B7280;
        white-space: nowrap;
    }
    #page-lang-toggle .lang-btns {
        display: flex;
        border-radius: 8px;
        overflow: hidden;
        border: 1.5px solid #e5e7eb;
        flex: 1;
    }
    .page-lang-btn {
        flex: 1;
        padding: 8px 0;
        border: none;
        font-weight: 800;
        font-size: 0.85rem;
        font-family: 'Cairo', sans-serif;
        cursor: pointer;
        transition: all 0.2s;
        background: #f9fafb;
        color: #9CA3AF;
    }
    .page-lang-btn.active {
        color: white;
    }
    .page-lang-btn[data-lang="ar"].active { background: #F59E0B; border-color: #F59E0B; }
    .page-lang-btn[data-lang="en"].active { background: #3B82F6; border-color: #3B82F6; }
</style>

<div id="page-lang-toggle">
    <span class="toggle-label">
        <svg xmlns="http://www.w3.org/2000/svg" style="width:14px;height:14px;display:inline;margin-left:4px;vertical-align:middle;" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5h12M9 3v2m1.048 9.5A18.022 18.022 0 016.412 9m6.088 9h7M11 21l5-10 5 10M12.751 5C11.783 10.77 8.07 15.61 3 18.129"/></svg>
        لغة التعديل
    </span>
    <div class="lang-btns">
        <button type="button" class="page-lang-btn" data-lang="ar" onclick="switchPageEditLang('ar')">🇸🇦 العربية</button>
        <button type="button" class="page-lang-btn" data-lang="en" onclick="switchPageEditLang('en')">🇬🇧 English</button>
    </div>
</div>

<script>
(function() {
    // Tag individual field wrappers based on field name (_ar or _en suffix)
    function tagFields() {
        document.querySelectorAll('.fi-fo-field-wrp').forEach(function(wrp) {
            if (wrp.dataset.editLang) return; // already tagged
            
            // Try finding label 'for' attribute, or input 'id' or 'wire:model'
            var key = null;
            var label = wrp.querySelector('label[for]');
            if (label && label.getAttribute('for')) {
                key = label.getAttribute('for');
            } else {
                var input = wrp.querySelector('[id], [wire\\:model]');
                if (input) {
                    key = input.id || input.getAttribute('wire:model');
                }
            }

            if (key && typeof key === 'string') {
                if (key.match(/_ar$/)) {
                    wrp.dataset.editLang = 'ar';
                } else if (key.match(/_en$/)) {
                    wrp.dataset.editLang = 'en';
                }
            }
        });
    }

    window.switchPageEditLang = function(lang) {
        localStorage.setItem('pageEditLang', lang);
        // Tag any new fields
        tagFields();
        // Switch body class
        document.body.classList.remove('edit-ar', 'edit-en');
        document.body.classList.add('edit-' + lang);
        // Update button states
        document.querySelectorAll('.page-lang-btn').forEach(function(btn) {
            btn.classList.toggle('active', btn.dataset.lang === lang);
        });
    };

    function init() {
        tagFields();
        var saved = localStorage.getItem('pageEditLang') || 'ar';
        switchPageEditLang(saved);
    }

    // Init after DOM is ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', function() { setTimeout(init, 500); });
    } else {
        setTimeout(init, 300);
    }

    // Re-tag after Livewire updates (new blocks or fields added)
    document.addEventListener('livewire:update', function() {
        setTimeout(function() {
            tagFields();
            var saved = localStorage.getItem('pageEditLang') || 'ar';
            switchPageEditLang(saved);
        }, 400);
    });
})();
</script>
