<div class="custom-form-widget bg-white rounded-2xl shadow-sm border border-gray-100 p-6 sm:p-8">
    @if(!$customForm->is_active)
        <div class="text-center text-gray-500 py-8">
            عذراً، هذا النموذج غير متاح حالياً.
        </div>
    @elseif($isSubmitted)
        <div class="text-center py-8">
            <div class="inline-flex items-center justify-center w-16 h-16 rounded-full bg-green-100 text-green-500 mb-6">
                <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
            </div>
            <h3 class="text-2xl font-bold text-gray-900 mb-2">شكراً لك!</h3>
            <p class="text-gray-600 mb-6">{{ $customForm->success_message ?? 'تم الإرسال بنجاح.' }}</p>
            
            @if($redirectUrl)
                <div class="animate-pulse text-sm text-gray-500 mb-4">جاري توجيهك إلى واتساب...</div>
                <script>
                    setTimeout(function() {
                        window.location.href = "{!! $redirectUrl !!}";
                    }, 1500);
                </script>
                <a href="{{ $redirectUrl }}" class="inline-flex items-center justify-center px-6 py-3 border border-transparent text-base font-medium rounded-xl text-white bg-green-500 hover:bg-green-600 transition-colors">
                    <svg class="w-5 h-5 ml-2" fill="currentColor" viewBox="0 0 24 24"><path d="M12.031 6.172c-3.181 0-5.767 2.586-5.768 5.766-.001 1.298.38 2.27 1.019 3.287l-.582 2.128 2.182-.573c.978.58 1.911.928 3.145.929 3.178 0 5.767-2.587 5.768-5.766.001-3.187-2.575-5.77-5.764-5.771zm3.392 8.244c-.144.405-.837.774-1.17.824-.299.045-.677.063-1.092-.069-.252-.08-.575-.187-.988-.365-2.062-.888-3.418-3.04-3.52-3.178-.103-.138-.84-1.121-.84-2.14 0-1.019.531-1.52.721-1.725.19-.205.412-.256.55-.256h.398c.144 0 .344-.054.538.414.205.5.66 1.62.721 1.745.061.125.103.272.017.444-.085.172-.128.28-.261.433-.138.154-.286.335-.41.465-.138.138-.282.288-.125.565.158.277.701 1.166 1.508 1.894.12.109.248.204.382.293.456.304.721.492 1.01.536.29.044.462-.023.633-.198.171-.176.66-1.019.839-1.373.18-.354.359-.296.68-.176.321.12 2.031.96 2.381 1.137.351.177.585.265.671.413.086.148.086.843-.058 1.248z"/></svg>
                    الانتقال لواتساب الآن
                </a>
            @endif
        </div>
    @else
        <form wire:submit.prevent="submit" class="space-y-6">
            @if(is_array($customForm->fields))
                @foreach($customForm->fields as $field)
                    @php
                        $key = $field['key'] ?? '';
                        if(empty($key)) continue;
                        $type = $field['type'] ?? 'text';
                        $isRequired = !empty($field['is_required']);
                        $errorClass = $errors->has('data.'.$key) ? 'border-red-300 focus:ring-red-500 focus:border-red-500' : 'border-gray-200 focus:ring-primary-500 focus:border-primary-500';
                    @endphp
                    
                    <div>
                        <label for="{{ $key }}" class="block text-sm font-medium text-gray-700 mb-2">
                            {{ $field['name'] ?? '' }}
                            @if($isRequired)
                                <span class="text-red-500">*</span>
                            @endif
                        </label>
                        
                        @if($type === 'textarea')
                            <textarea id="{{ $key }}" wire:model="data.{{ $key }}" rows="4" class="block w-full rounded-xl shadow-sm bg-gray-50 text-gray-900 {{ $errorClass }} transition-colors" {{ $isRequired ? 'required' : '' }}></textarea>
                            
                        @elseif($type === 'select')
                            <select id="{{ $key }}" wire:model="data.{{ $key }}" class="block w-full rounded-xl shadow-sm bg-gray-50 text-gray-900 {{ $errorClass }} transition-colors" {{ $isRequired ? 'required' : '' }}>
                                <option value="">اختر...</option>
                                @php
                                    $options = array_filter(array_map('trim', explode(',', $field['options'] ?? '')));
                                @endphp
                                @foreach($options as $opt)
                                    <option value="{{ $opt }}">{{ $opt }}</option>
                                @endforeach
                            </select>
                            
                        @else
                            <input type="{{ $type === 'tel' ? 'text' : $type }}" id="{{ $key }}" wire:model="data.{{ $key }}" class="block w-full rounded-xl shadow-sm bg-gray-50 text-gray-900 h-12 px-4 {{ $errorClass }} transition-colors" {{ $isRequired ? 'required' : '' }} dir="{{ $type === 'tel' || $type === 'email' ? 'ltr' : 'auto' }}">
                        @endif
                        
                        @error('data.'.$key)
                            <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>
                @endforeach
            @endif

            <div class="pt-4">
                <button type="submit" style="background-color: var(--pr-secondary, #00A0B0); color: white;" class="w-full flex justify-center py-3.5 px-4 border border-transparent rounded-xl shadow-sm text-base font-bold focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[#00A0B0] transition-colors disabled:opacity-50 disabled:cursor-not-allowed hover:opacity-90">
                    <span wire:loading.remove wire:target="submit">{{ $customForm->submit_button_text ?? 'إرسال' }}</span>
                    <span wire:loading wire:target="submit">جاري الإرسال...</span>
                </button>
            </div>
        </form>
    @endif
</div>
