<?php

$siteSettings = $siteSettings ?? (function () { try { return app(\App\Settings\SiteSettings::class); } catch (\Throwable $e) { return new \stdClass(); } })();
$title = $data['title'] ?? "";
$description = $data['description'] ?? "";
$buttonText = $data['button_text'] ?? "";
$buttonUrl = $data['button_url'] ?? '/packages';
$showCallButton = $data['show_call_button'] ?? true;
$image = $data['image'] ?? null;
$showDefaultIcon = $data['show_default_icon'] ?? true;
$showStats = $data['show_stats'] ?? true;
$stats = $data['stats'] ?? [
    ['value' => '24', 'label' => 'ساعة نتائج'],
    ['value' => '100%', 'label' => 'معتمد'],
    ['value' => 'مجاناً', 'label' => 'السحب المنزلي'],
];
$imageOnRight = $data['image_on_right'] ?? false;
$fullWidth = $data['full_width'] ?? true;

$resolveUploadValue = function (mixed $value) use (&$resolveUploadValue): ?string {
    if (is_string($value) && $value !== '') {
        return $value;
    }

    if (! is_array($value)) {
        return null;
    }

    foreach (['path', 'url', 'temporaryUrl', 'preview_url'] as $key) {
        if (! empty($value[$key]) && is_string($value[$key])) {
            return $value[$key];
        }
    }

    foreach ($value as $item) {
        $resolved = $resolveUploadValue($item);
        if ($resolved) {
            return $resolved;
        }
    }

    return null;
};

$toImageUrl = function (mixed $value) use ($resolveUploadValue): ?string {
    $resolved = $resolveUploadValue($value);
    if (! $resolved) {
        return null;
    }

    if (str_starts_with($resolved, 'http://') || str_starts_with($resolved, 'https://') || str_starts_with($resolved, 'data:')) {
        return $resolved;
    }

    if (str_starts_with($resolved, '/storage/')) {
        return url($resolved);
    }

    return asset('storage/' . ltrim($resolved, '/'));
};

$imageUrl = $toImageUrl($image);
?>

<section class="about-section" style="<?php echo e($fullWidth ? 'background: linear-gradient(135deg, rgba(26, 54, 93, 0.03) 0%, rgba(0, 160, 176, 0.05) 100%);' : ''); ?> padding: 60px 20px;">
    <div style="max-width: 1200px; margin: 0 auto; display: grid; grid-template-columns: 1fr 1fr; gap: 50px; align-items: center; direction: <?php echo e($imageOnRight ? 'ltr' : 'rtl'); ?>;">
        <div class="about-content" style="direction: rtl;">
            <div style="font-size: 1.8rem; font-weight: 800; color: var(--pr-primary); margin-bottom: 18px; display: flex; align-items: center; gap: 10px;">
                <i class="fas fa-info-circle" style="color: var(--pr-secondary);"></i>
                <?php echo e($title); ?>

            </div>
            <p style="font-size: 1.1rem; line-height: 1.9; color: var(--pr-text); margin-bottom: 24px;">
                <?php echo e($description); ?>

            </p>
            <div style="display: flex; gap: 20px; flex-wrap: wrap;">
                <a href="<?php echo e($buttonUrl); ?>" class="btn-primary" style="padding: 14px 32px;">
                    <i class="fas fa-flask"></i>
                    <?php echo e($buttonText); ?>

                </a>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($showCallButton): ?>
                <a href="tel:<?php echo e($siteSettings->contact_phone); ?>" style="padding: 14px 32px; border: 2px solid var(--pr-primary); color: var(--pr-primary); border-radius: 50px; font-weight: 700; transition: var(--transition); text-decoration: none; display: inline-flex; align-items: center; gap: 8px;">
                    <i class="fas fa-phone"></i>
                    اتصل بنا
                </a>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
        </div>
        <div class="about-image" style="position: relative; direction: rtl;">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($imageUrl): ?>
                <img src="<?php echo e($imageUrl); ?>" alt="<?php echo e($siteSettings->site_name); ?>" style="width: 100%; max-width: 500px; height: auto; border-radius: var(--pr-radius-lg); box-shadow: var(--pr-shadow-card);">
            <?php elseif($showDefaultIcon): ?>
                <div style="width: 100%; max-width: 500px; aspect-ratio: 4/3; background: linear-gradient(135deg, var(--pr-secondary) 0%, var(--pr-accent) 100%); border-radius: var(--pr-radius-lg); display: flex; align-items: center; justify-content: center; box-shadow: var(--pr-shadow-card);">
                    <i class="fas fa-microscope" style="font-size: 6rem; color: white; opacity: 0.9;"></i>
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($showStats && count($stats) > 0): ?>
            <div style="position: absolute; bottom: -20px; left: -20px; background: white; padding: 20px 30px; border-radius: var(--pr-radius-lg); box-shadow: var(--pr-shadow-card); display: flex; gap: 30px;">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $stats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div style="text-align: center;">
                    <div style="font-size: 1.8rem; font-weight: 800; background: var(--pr-gradient); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"><?php echo e($stat['value'] ?? ''); ?></div>
                    <div style="font-size: 0.85rem; color: var(--pr-text);"><?php echo e($stat['label'] ?? ''); ?></div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
    </div>
</section>

<style>
    @media (max-width: 768px) {
        .about-section > div {
            grid-template-columns: 1fr !important;
        }
    }
</style>
<?php /**PATH /Users/test/Documents/prisma1/resources/views/components/blocks/prisma-about.blade.php ENDPATH**/ ?>