<?php
$siteSettings = $siteSettings ?? (function () {
    try { return app(\App\Settings\SiteSettings::class); } catch (\Throwable $e) { return new \stdClass(); }
})();
$locale = function_exists('app') ? app()->getLocale() : 'ar';
$toString = function (mixed $value, string $default = '') use (&$toString): string {
    if (is_string($value) || is_numeric($value)) {
        return (string) $value;
    }

    if (is_array($value)) {
        foreach ($value as $item) {
            $resolved = $toString($item, '');
            if ($resolved !== '') {
                return $resolved;
            }
        }
    }

    return $default;
};
$blockTrans = function ($d, $key, $default = '') use ($locale, $toString) {
    $k = $key . '_' . $locale;
    if (!empty($d[$k])) return $toString($d[$k], $default);
    if (!empty($d[$key])) return $toString($d[$key], $default);
    return $default;
};
$layout = $data['layout_design'] ?? 'premium';
$premiumMode = $toString($data['premium_display_mode'] ?? null, 'full');
$showBackgroundImage = (bool) ($data['show_background_image'] ?? true);
$showHeroText = (bool) ($data['show_hero_text'] ?? true);
$showCtaButton = (bool) ($data['show_cta_button'] ?? true);
$showCategories = (bool) ($data['show_categories'] ?? true);
$title = $blockTrans($data, 'title', 'اختر باقتين والثالثة مجاناً');
$subtitle = $blockTrans($data, 'subtitle', 'تطمن على صحتك ولا يوقفك برد الشتاء');
$ctaText = $blockTrans($data, 'cta_text', 'احجز الآن');
$ctaUrl = $toString($data['cta_url'] ?? null, '#packages');
$buttonStyle = $toString($data['button_style'] ?? null, 'primary');
$ctaBgStart = $toString($data['cta_bg_start'] ?? null, '#0099FF');
$ctaBgEnd = $toString($data['cta_bg_end'] ?? null, '#7B00FF');
$ctaTextColor = $toString($data['cta_text_color'] ?? null, '#ffffff');
$fullWidth = $data['full_width'] ?? true;
$rounded = $data['rounded_corners'] ?? false;
$shadow = $data['add_shadow'] ?? false;
$bgImage = $data['background_image'] ?? null;
$imageHasText = $data['image_has_text'] ?? false;
$imagePosition = $toString($data['image_position'] ?? null, 'right');
$imageHeight = $toString($data['image_height'] ?? null, 'large');
$bgColor = $toString($data['bg_color'] ?? null, '#0a0a0a');
$overlayColor = $toString($data['overlay_color'] ?? null, '#000000');
$overlayOpacity = $data['overlay_opacity'] ?? 30;
$textColor = $toString($data['text_color'] ?? null, '#ffffff');
$showPattern = $data['show_pattern'] ?? true;
$categories = $data['categories'] ?? [];

$isCategoryItem = function (mixed $value): bool {
    if (! is_array($value)) {
        return false;
    }

    foreach (['name', 'url', 'icon', 'image', 'use_image', 'text_position', 'overlay_style'] as $key) {
        if (array_key_exists($key, $value)) {
            return true;
        }
    }

    return false;
};

if (! is_array($categories)) {
    $categories = [];
}
if (! array_is_list($categories)) {
    if ($isCategoryItem($categories)) {
        $categories = [$categories];
    } else {
        $allEntriesAreArrays = true;
        foreach ($categories as $entry) {
            if (! is_array($entry)) {
                $allEntriesAreArrays = false;
                break;
            }
        }

        $categories = $allEntriesAreArrays ? array_values($categories) : [];
    }
}

$resolveUploadValue = function (mixed $value) use (&$resolveUploadValue): ?string {
    if (is_string($value) && $value !== '') {
        return $value;
    }

    if (! is_array($value)) {
        return null;
    }

    if (array_is_list($value)) {
        foreach ($value as $item) {
            $resolved = $resolveUploadValue($item);
            if ($resolved) {
                return $resolved;
            }
        }

        return null;
    }

    foreach (['path', 'url', 'temporaryUrl', 'preview_url'] as $key) {
        if (! empty($value[$key]) && is_string($value[$key])) {
            return $value[$key];
        }
    }

    // Support keyed upload maps like [randomKey => "hero/file.jpg"].
    foreach ($value as $item) {
        $resolved = $resolveUploadValue($item);
        if ($resolved) {
            return $resolved;
        }
    }

    return null;
};

$toImageUrl = function (mixed $value) use ($resolveUploadValue): ?string {
    $resolved = $resolveUploadValue($value);
    if (! $resolved) {
        return null;
    }

    if (str_starts_with($resolved, 'http://') || str_starts_with($resolved, 'https://') || str_starts_with($resolved, 'data:')) {
        return $resolved;
    }

    if (str_starts_with($resolved, '/storage/')) {
        return url($resolved);
    }

    return asset('storage/' . ltrim($resolved, '/'));
};

$hasTextContent = $showHeroText
    && $layout !== 'image_only'
    && ! ($layout === 'premium' && $premiumMode === 'image_only');

$hasImageContent = $showBackgroundImage
    && $layout !== 'text_only'
    && ! ($layout === 'premium' && $premiumMode === 'text_only');

$bgImageUrl = $hasImageContent ? $toImageUrl($bgImage) : null;

// Height mapping
$heightMap = [
    'small' => '300px',
    'medium' => '450px',
    'large' => '600px',
    'fullscreen' => '100vh',
];
$containerHeight = $heightMap[$imageHeight] ?? '600px';

$primaryColor = $siteSettings->primary_color ?? '#00A0B0';

// Button styles
$buttonClasses = match($buttonStyle) {
    'primary' => 'btn-primary',
    'secondary' => 'inline-flex items-center gap-2 px-8 py-4 rounded-full font-bold border-2 border-current transition-all hover:bg-white hover:text-gray-900',
    'white' => 'inline-flex items-center gap-2 px-8 py-4 rounded-full font-bold bg-white text-gray-900 transition-all hover:bg-gray-100',
    'ghost' => 'inline-flex items-center gap-2 px-8 py-4 rounded-full font-bold border border-white/30 backdrop-blur transition-all hover:bg-white/10',
    default => 'btn-primary',
};
$premiumCtaStyle = 'background: linear-gradient(135deg,' . $ctaBgStart . ' 0%,' . $ctaBgEnd . ' 100%); color:' . $ctaTextColor . ';';
?>


<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($layout === 'premium'): ?>

<style>
    .prisma-hero-section {
        position: relative;
        width: 100%;
        height: 560px;
        max-height: 85vh;
        overflow: hidden;
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        display: flex;
        align-items: center;
        justify-content: center;
        text-align: center;
        font-family: 'Cairo', sans-serif;
    }
    /* Mobile full image — hidden on desktop */
    .prisma-hero-mobile-img {
        display: none;
    }
    .prisma-hero-overlay {
        position: absolute; inset: 0;
        background: linear-gradient(135deg, rgba(47,74,94,0.75) 0%, rgba(10,10,10,0.6) 50%, rgba(123,0,255,0.25) 100%);
        display: flex; flex-direction: column; align-items: center; justify-content: center; padding: 40px 24px;
    }
    .prisma-hero-headline { font-size: clamp(2rem,5vw,3.5rem); font-weight: 900; color: #fff; text-shadow: 0 2px 20px rgba(0,0,0,.3); margin-bottom: 12px; line-height: 1.25; font-family: 'Cairo',sans-serif; }
    .prisma-hero-sub { font-size: clamp(1rem,2.2vw,1.25rem); color: rgba(255,255,255,.92); font-weight: 500; margin-bottom: 28px; max-width: 520px; }
    .prisma-hero-cta { display: inline-flex; align-items: center; gap: 10px; padding: 16px 32px; background: linear-gradient(135deg,#0099FF 0%,#7B00FF 100%); color: #fff; border-radius: 50px; font-weight: 700; font-size: 1.1rem; text-decoration: none; box-shadow: 0 8px 24px rgba(0,153,255,.4); transition: all .3s; border: none; cursor: pointer; }
    .prisma-hero-cta:hover { transform: translateY(-2px); box-shadow: 0 12px 32px rgba(0,153,255,.5); color: #fff; }
    .quick-cats-container { max-width: 1300px; margin: -48px auto 64px; padding: 0 20px; position: relative; z-index: 5; }
    .quick-cats-grid { display: grid; grid-template-columns: repeat(4,1fr); gap: 24px; }
    .cat-card { background: #fff; border-radius: 20px; overflow: hidden; box-shadow: 0 10px 40px rgba(47,74,94,.12),0 4px 12px rgba(0,0,0,.06); transition: all .3s cubic-bezier(.4,0,.2,1); cursor: pointer; position: relative; aspect-ratio: 4/3; border: none; text-decoration: none; display: block; }
    .cat-card:hover { transform: translateY(-12px) scale(1.02); box-shadow: 0 20px 50px rgba(0,153,255,.2),0 8px 24px rgba(0,0,0,.1); }
    .cat-card img { width: 100%; height: 100%; object-fit: cover; transition: .6s; }
    .cat-card:hover img { transform: scale(1.12); }
    .cat-label { position: absolute; bottom: 0; left: 0; right: 0; background: linear-gradient(to top,rgba(47,74,94,.95),rgba(47,74,94,.6) 60%,transparent); color: #fff; padding: 24px 16px 14px; font-weight: 700; text-align: center; font-family: 'Cairo',sans-serif; font-size: 1.05rem; }
    .cat-card:hover .cat-label { background: linear-gradient(to top,rgba(0,153,255,.95),rgba(123,0,255,.5)); }
    .cat-icon-box { width: 100%; height: 100%; background: linear-gradient(135deg,#f1f5f9 0%,#e2e8f0 100%); display: flex; align-items: center; justify-content: center; }
    .cat-icon-box i { font-size: 2.5rem; color: #0099FF; }
    @media(max-width:1024px) {
        .quick-cats-grid { grid-template-columns: repeat(3,1fr); }
        .prisma-hero-section { height: 480px; }
    }
    @media(max-width:768px) {
        .quick-cats-grid { grid-template-columns: repeat(2,1fr); }
        .prisma-hero-section {
            height: auto !important;
            max-height: none !important;
            background-image: none !important;
            flex-direction: column !important;
            display: flex !important;
            background: #fff !important; /* Clean white background */
        }
        .prisma-hero-mobile-img {
            display: block;
            width: 100%;
            height: auto !important;
            max-height: none !important;
            object-fit: contain;
            position: relative;
            background: #f8fafc;
        }
        .prisma-hero-overlay {
            position: relative !important;
            inset: auto !important;
            padding: 32px 20px !important;
            background: #fff !important; /* Solid white for text area */
            width: 100%;
            text-align: center;
        }
        .prisma-hero-headline { 
            font-size: 1.6rem !important; 
            color: #1e293b !important; 
            text-shadow: none !important;
            margin-bottom: 12px !important;
        }
        .prisma-hero-sub {
            color: #64748b !important;
            font-size: 1rem !important;
            margin-bottom: 24px !important;
        }
    }
    @media(max-width:480px) {
        .quick-cats-grid { grid-template-columns: 1fr; }
    }
</style>

<section class="prisma-hero-section" style="<?php echo e($bgImageUrl ? "background-image: url('{$bgImageUrl}');" : "background: linear-gradient(135deg, {$bgColor} 0%, #2F4A5E 50%, #0099FF 100%);"); ?>">
    
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($bgImageUrl): ?>
    <img src="<?php echo e($bgImageUrl); ?>" alt="" class="prisma-hero-mobile-img" aria-hidden="true">
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    <div class="prisma-hero-overlay" style="<?php echo e($hasTextContent ? '' : 'background: transparent;'); ?>">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($hasTextContent): ?>
            <h1 class="prisma-hero-headline"><?php echo e($title); ?></h1>
            <p class="prisma-hero-sub"><?php echo e($subtitle); ?></p>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($showCtaButton): ?>
                <a href="<?php echo e($ctaUrl); ?>" class="prisma-hero-cta" style="<?php echo e($premiumCtaStyle); ?>">
                    <i class="fas fa-calendar-check"></i>
                    <?php echo e($ctaText); ?>

                </a>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>
</section>

<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($showCategories && count($categories) > 0): ?>
<div class="quick-cats-container">
    <div class="quick-cats-grid">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            if (! is_array($cat)) {
                continue;
            }

            $catData = $cat;
            $catName = $toString($catData['name'] ?? null, 'Category');
            $catUrl = $toString($catData['url'] ?? null, '#');
            $useImage = (bool) ($catData['use_image'] ?? false);
            $catImage = $catData['image'] ?? null;
            $catImageUrl = $toImageUrl($catImage);
            $catIcon = $toString($catData['icon'] ?? null, 'fas fa-vial');
        ?>
        <a href="<?php echo e($catUrl); ?>" class="cat-card">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($useImage && $catImageUrl): ?>
                <img src="<?php echo e($catImageUrl); ?>" alt="<?php echo e($catName); ?>" loading="lazy">
            <?php else: ?>
                <div class="cat-icon-box"><i class="<?php echo e($catIcon); ?>"></i></div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            <div class="cat-label"><?php echo e($catName); ?></div>
        </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>
</div>
<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>


<?php elseif($layout === 'center_text_on_image'): ?>
<section class="hero" style="min-height: <?php echo e($containerHeight); ?>; background: <?php echo e($bgImageUrl ? 'url(' . $bgImageUrl . ')' : $bgColor); ?>; background-size: cover; background-position: center; position: relative; display: flex; align-items: center; justify-content: center; text-align: center; padding: 40px 20px; <?php echo e($rounded ? 'border-radius: var(--pr-radius-lg);' : ''); ?> <?php echo e($shadow ? 'box-shadow: var(--pr-shadow-card);' : ''); ?> <?php echo e($fullWidth ? '' : 'margin: 20px; max-width: 1200px; margin-left: auto; margin-right: auto;'); ?>">
    
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!$imageHasText): ?>
    <div style="position: absolute; inset: 0; background: <?php echo e($overlayColor); ?>; opacity: <?php echo e($overlayOpacity / 100); ?>; <?php echo e($rounded ? 'border-radius: var(--pr-radius-lg);' : ''); ?>"></div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    
    
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($showPattern && !$imageHasText): ?>
    <div style="position: absolute; inset: 0; opacity: 0.05; background-image: url('data:image/svg+xml,%3Csvg width=\"60\" height=\"60\" viewBox=\"0 0 60 60\" xmlns=\"http://www.w3.org/2000/svg\"%3E%3Cg fill=\"none\" fill-rule=\"evenodd\"%3E%3Cg fill=\"%23ffffff\" fill-opacity=\"0.4\"%3E%3Cpath d=\"M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z\"/%3E%3C/g%3E%3C/g%3E%3C/svg%3E'); <?php echo e($rounded ? 'border-radius: var(--pr-radius-lg);' : ''); ?>"></div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($hasTextContent && !$imageHasText): ?>
    <div class="hero-content" style="max-width: 700px; z-index: 1;">
        <h1 style="font-size: 2.8rem; font-weight: 900; color: <?php echo e($textColor); ?>; margin-bottom: 12px; font-family: '<?php echo e($siteSettings->font_heading ?? 'Cairo'); ?>', sans-serif; line-height: 1.3;">
            <?php echo e($title); ?>

        </h1>
        <p style="color: <?php echo e($textColor); ?>CC; font-size: 1.1rem; line-height: 1.8; margin-bottom: 30px; max-width: 600px;">
            <?php echo e($subtitle); ?>

        </p>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($showCtaButton): ?>
            <a href="<?php echo e($ctaUrl); ?>" class="<?php echo e($buttonClasses); ?>" <?php if($buttonStyle === 'secondary'): ?> style="color: <?php echo e($textColor); ?>;" <?php endif; ?>>
                <i class="fas fa-calendar-check"></i>
                <?php echo e($ctaText); ?>

            </a>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!$fullWidth): ?>
    <div style="position: absolute; bottom: -1px; left: 0; right: 0; height: 100px; background: linear-gradient(to top, var(--pr-light), transparent);"></div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
</section>


<?php elseif($layout === 'text_beside_image'): ?>
<section class="hero" style="padding: 60px 20px; <?php echo e($fullWidth ? '' : 'max-width: 1200px; margin: 0 auto;'); ?>">
    <div style="display: grid; grid-template-columns: <?php echo e($hasTextContent ? '1fr 1fr' : '1fr'); ?>; gap: 40px; align-items: center; max-width: 1200px; margin: 0 auto; <?php echo e($imagePosition === 'left' ? 'direction: ltr;' : 'direction: rtl;'); ?>">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($hasTextContent): ?>
        <div style="direction: rtl;">
            <h1 style="font-size: 2.5rem; font-weight: 900; color: <?php echo e($textColor); ?>; margin-bottom: 16px; font-family: '<?php echo e($siteSettings->font_heading ?? 'Cairo'); ?>', sans-serif; line-height: 1.3;">
                <?php echo e($title); ?>

            </h1>
            <p style="color: <?php echo e($textColor); ?>99; font-size: 1.1rem; line-height: 1.8; margin-bottom: 30px;">
                <?php echo e($subtitle); ?>

            </p>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($showCtaButton): ?>
                <a href="<?php echo e($ctaUrl); ?>" class="<?php echo e($buttonClasses); ?>" <?php if($buttonStyle === 'secondary'): ?> style="color: <?php echo e($textColor); ?>; border-color: <?php echo e($textColor); ?>;" <?php endif; ?>>
                    <i class="fas fa-calendar-check"></i>
                    <?php echo e($ctaText); ?>

                </a>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        <div style="<?php echo e($rounded ? 'border-radius: var(--pr-radius-lg); overflow: hidden;' : ''); ?> <?php echo e($shadow ? 'box-shadow: var(--pr-shadow-card);' : ''); ?>">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($bgImageUrl): ?>
                <img src="<?php echo e($bgImageUrl); ?>" alt="<?php echo e($title); ?>" style="width: 100%; height: auto; display: block;">
            <?php else: ?>
                <div style="width: 100%; aspect-ratio: 4/3; background: linear-gradient(135deg, var(--pr-secondary) 0%, var(--pr-accent) 100%); display: flex; align-items: center; justify-content: center;">
                    <i class="fas fa-image" style="font-size: 4rem; color: white; opacity: 0.5;"></i>
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
    </div>
</section>


<?php elseif($layout === 'text_below_image'): ?>
<section class="hero" style="padding: 40px 20px; <?php echo e($fullWidth ? '' : 'max-width: 1200px; margin: 0 auto;'); ?> text-align: center;">
    <div style="max-width: 1200px; margin: 0 auto;">
        <div style="margin-bottom: 40px; <?php echo e($rounded ? 'border-radius: var(--pr-radius-lg); overflow: hidden;' : ''); ?> <?php echo e($shadow ? 'box-shadow: var(--pr-shadow-card);' : ''); ?>">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($bgImageUrl): ?>
                <img src="<?php echo e($bgImageUrl); ?>" alt="<?php echo e($title); ?>" style="width: 100%; height: auto; display: block;">
            <?php else: ?>
                <div style="width: 100%; aspect-ratio: 21/9; background: linear-gradient(135deg, var(--pr-secondary) 0%, var(--pr-accent) 100%); display: flex; align-items: center; justify-content: center;">
                    <i class="fas fa-image" style="font-size: 5rem; color: white; opacity: 0.5;"></i>
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($hasTextContent): ?>
        <div style="max-width: 700px; margin: 0 auto;">
            <h1 style="font-size: 2.5rem; font-weight: 900; color: <?php echo e($textColor); ?>; margin-bottom: 16px; font-family: '<?php echo e($siteSettings->font_heading ?? 'Cairo'); ?>', sans-serif; line-height: 1.3;">
                <?php echo e($title); ?>

            </h1>
            <p style="color: <?php echo e($textColor); ?>99; font-size: 1.1rem; line-height: 1.8; margin-bottom: 30px;">
                <?php echo e($subtitle); ?>

            </p>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($showCtaButton): ?>
                <a href="<?php echo e($ctaUrl); ?>" class="<?php echo e($buttonClasses); ?>" <?php if($buttonStyle === 'secondary'): ?> style="color: <?php echo e($textColor); ?>;" <?php endif; ?>>
                    <i class="fas fa-calendar-check"></i>
                    <?php echo e($ctaText); ?>

                </a>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>
</section>


<?php elseif($layout === 'image_only'): ?>
<section class="hero" style="<?php echo e($fullWidth ? '' : 'padding: 20px;'); ?>">
    <div style="<?php echo e($rounded ? 'border-radius: var(--pr-radius-lg); overflow: hidden;' : ''); ?> <?php echo e($shadow ? 'box-shadow: var(--pr-shadow-card);' : ''); ?> <?php echo e($fullWidth ? '' : 'max-width: 1200px; margin: 0 auto;'); ?>">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($bgImageUrl): ?>
            <img src="<?php echo e($bgImageUrl); ?>" alt="Hero" style="width: 100%; min-height: <?php echo e($containerHeight); ?>; max-height: <?php echo e($containerHeight); ?>; object-fit: cover; display: block; height: auto;">
        <?php else: ?>
            <div style="width: 100%; min-height: <?php echo e($containerHeight); ?>; background: linear-gradient(135deg, var(--pr-secondary) 0%, var(--pr-accent) 100%); display: flex; align-items: center; justify-content: center;">
                <i class="fas fa-image" style="font-size: 5rem; color: white; opacity: 0.5;"></i>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>
    <style>
    @media(max-width:768px){
        .hero img { min-height: 260px !important; max-height: none !important; }
    }
    </style>
</section>


<?php elseif($layout === 'text_only'): ?>
<section class="hero" style="padding: 80px 20px; text-align: center; background: <?php echo e($bgColor); ?>; <?php echo e($rounded ? 'border-radius: var(--pr-radius-lg);' : ''); ?> <?php echo e($shadow ? 'box-shadow: var(--pr-shadow-card);' : ''); ?> <?php echo e($fullWidth ? '' : 'max-width: 1200px; margin: 40px auto;'); ?>">
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($hasTextContent): ?>
    <div style="max-width: 700px; margin: 0 auto;">
        <h1 style="font-size: 2.8rem; font-weight: 900; color: <?php echo e($textColor); ?>; margin-bottom: 16px; font-family: '<?php echo e($siteSettings->font_heading ?? 'Cairo'); ?>', sans-serif; line-height: 1.3;">
            <?php echo e($title); ?>

        </h1>
        <p style="color: <?php echo e($textColor); ?>CC; font-size: 1.1rem; line-height: 1.8; margin-bottom: 30px;">
            <?php echo e($subtitle); ?>

        </p>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($showCtaButton): ?>
            <a href="<?php echo e($ctaUrl); ?>" class="<?php echo e($buttonClasses); ?>" <?php if($buttonStyle === 'secondary'): ?> style="color: <?php echo e($textColor); ?>;" <?php endif; ?>>
                <i class="fas fa-calendar-check"></i>
                <?php echo e($ctaText); ?>

            </a>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
</section>
<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
<?php /**PATH /Users/test/Documents/prisma1/resources/views/components/blocks/prisma-hero.blade.php ENDPATH**/ ?>