<?php if (isset($component)) { $__componentOriginal5863877a5171c196453bfa0bd807e410 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5863877a5171c196453bfa0bd807e410 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.layouts.app','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('layouts.app'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <?php $__env->startSection('title', $package->meta_title ?? $package->translated_name . ' | مختبرات بريزما الطبية'); ?>
    <?php $__env->startSection('description', $package->meta_description ?? $package->translated_short_description); ?>

    <style>
        :root {
            --pr-primary: #1A365D;
            --pr-secondary: #00A0B0;
            --pr-accent: #2D9CDB;
            --pr-light: #F8FAFC;
            --pr-text: #334155;
            --pr-radius: 12px;
            --pr-radius-lg: 16px;
            --pr-shadow: 0 4px 20px rgba(0,0,0,0.08);
            --pr-shadow-card: 0 8px 32px rgba(0,0,0,0.06);
            --pr-gradient: linear-gradient(135deg, var(--pr-primary) 0%, #2D3748 100%);
            --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        .pkg-detail-page * { box-sizing: border-box; }
        .pkg-detail-page { font-family: 'Tajawal', 'Cairo', sans-serif; color: var(--pr-text); direction: rtl; }
        .pkg-detail-page h1, .pkg-detail-page h2, .pkg-detail-page h3, .pkg-detail-page h4 { font-family: 'Cairo', sans-serif; }

        /* Preview Banner */
        .preview-banner {
            background: linear-gradient(135deg, #f59e0b, #d97706);
            color: white;
            text-align: center;
            padding: 12px 20px;
            font-weight: 700;
            font-family: 'Cairo', sans-serif;
            font-size: 0.95rem;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }

        .page-layout { display: grid; grid-template-columns: 1fr 380px; gap: 32px; max-width: 1280px; margin: 0 auto; padding: 24px 20px 48px; align-items: start; }
        @media (max-width: 1024px) { .page-layout { grid-template-columns: 1fr; } }

        /* Hero */
        .pkg-hero-wrap { position: relative; width: 100%; border-radius: var(--pr-radius-lg); overflow: hidden; margin-bottom: 24px; box-shadow: var(--pr-shadow-card); min-height: 280px; }
        .pkg-hero-wrap .hero-img { width: 100%; aspect-ratio: 1/1; max-height: 500px; min-height: 280px; object-fit: cover; display: block; background: #e2e8f0; }
        .pkg-hero-overlay { position: absolute; top: 0; right: 0; bottom: 0; width: 42%; min-width: 200px; background: var(--pr-gradient); display: flex; flex-direction: column; justify-content: center; padding: 28px; color: white; }
        .pkg-hero-overlay .promo { font-size: 0.95rem; font-weight: 600; margin-bottom: 8px; opacity: 0.95; }
        .pkg-hero-overlay .price-hero { font-size: 3rem; font-weight: 900; font-family: 'Cairo'; line-height: 1; }
        .pkg-hero-overlay .currency { font-size: 1rem; opacity: 0.9; margin-top: 4px; }
        .hero-back { position: absolute; top: 16px; left: 16px; width: 44px; height: 44px; background: rgba(255,255,255,0.95); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: var(--pr-primary); text-decoration: none; font-size: 1.2rem; transition: var(--transition); z-index: 2; }
        .hero-back:hover { background: white; color: var(--pr-secondary); }
        .hero-share { position: absolute; top: 16px; right: 16px; width: 44px; height: 44px; background: rgba(255,255,255,0.95); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: var(--pr-primary); text-decoration: none; font-size: 1.1rem; transition: var(--transition); z-index: 2; border: none; cursor: pointer; }
        .hero-share:hover { background: white; color: var(--pr-secondary); }

        @media (max-width: 768px) {
            .pkg-hero-wrap { display: flex; flex-direction: column; }
            .pkg-hero-wrap .hero-img { width: 100%; flex: 0 0 auto; }
            .pkg-hero-overlay { position: static; width: 100%; min-width: 0; flex-direction: row; align-items: center; justify-content: space-between; gap: 16px; padding: 16px 20px; border-radius: 0 0 var(--pr-radius-lg) var(--pr-radius-lg); }
            .pkg-hero-overlay .promo { margin-bottom: 0; font-size: 0.9rem; }
            .pkg-hero-overlay .hero-price-block { display: flex; flex-direction: column; align-items: flex-end; gap: 2px; }
            .pkg-hero-overlay .price-hero { font-size: 1.75rem; line-height: 1; }
            .pkg-hero-overlay .currency { margin-top: 0; font-size: 0.9rem; }
        }

        /* Content Cards */
        .content-card { background: white; border-radius: var(--pr-radius-lg); padding: 32px 28px; margin-bottom: 24px; box-shadow: var(--pr-shadow-card); }
        .content-card h1 { font-size: 1.75rem; color: var(--pr-primary); font-weight: 800; margin-bottom: 14px; line-height: 1.35; }
        .content-card .pkg-desc { font-size: 1.05rem; color: #64748B; line-height: 1.7; margin-bottom: 28px; }
        .section-title { font-size: 1.15rem; font-weight: 700; color: var(--pr-primary); margin-bottom: 18px; display: flex; align-items: center; gap: 10px; }
        .section-title i { color: var(--pr-secondary); }

        /* Tags row */
        .pkg-tags { display: flex; gap: 8px; flex-wrap: wrap; margin-bottom: 16px; }
        .pkg-tag {
            display: inline-flex; align-items: center; gap: 5px;
            padding: 5px 14px; border-radius: 50px;
            font-size: 0.82rem; font-weight: 600;
            background: #f0fdf4; color: #16a34a; border: 1px solid #bbf7d0;
        }
        .pkg-tag.offer { background: #fef3c7; color: #d97706; border-color: #fde68a; }
        .pkg-tag.tests { background: #dbeafe; color: #2563eb; border-color: #bfdbfe; }

        /* Instructions Card */
        .instructions-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 12px;
            margin-bottom: 24px;
        }
        .instruction-item {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 14px 16px;
            background: #f8fafc;
            border: 1px solid #e2e8f0;
            border-radius: 10px;
            transition: var(--transition);
        }
        .instruction-item:hover {
            border-color: var(--pr-secondary);
            background: #f0fdf9;
        }
        .instruction-item .inst-icon {
            width: 40px; height: 40px;
            border-radius: 10px;
            background: linear-gradient(135deg, var(--pr-secondary), #0891b2);
            color: white;
            display: flex; align-items: center; justify-content: center;
            font-size: 1rem;
            flex-shrink: 0;
        }
        .instruction-item .inst-text { flex: 1; }
        .instruction-item .inst-label { font-size: 0.78rem; color: #94a3b8; font-weight: 600; }
        .instruction-item .inst-value { font-size: 0.92rem; color: var(--pr-primary); font-weight: 700; }

        /* Category-grouped Tests — Reference Image Style */
        .test-category-section { margin-bottom: 28px; }
        .test-category-header {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 0 0 12px 0;
            margin-bottom: 16px;
            border-bottom: 2px solid #e2e8f0;
            cursor: pointer;
            transition: var(--transition);
        }
        .test-category-header:hover {
            border-bottom-color: var(--pr-secondary);
        }
        .test-category-header h4 {
            flex: 1;
            font-size: 1.1rem;
            font-weight: 800;
            color: #6366f1;
            margin: 0;
            letter-spacing: -0.01em;
        }
        .test-category-header .cat-count {
            font-size: 0.82rem;
            color: #6366f1;
            font-weight: 600;
            background: #eef2ff;
            padding: 3px 10px;
            border-radius: 50px;
        }
        .test-category-header .toggle-icon {
            color: #6366f1;
            font-size: 0.8rem;
            transition: transform 0.3s;
        }
        .test-category-section.collapsed .toggle-icon {
            transform: rotate(-90deg);
        }
        .test-category-section.collapsed .test-items-grid {
            display: none;
        }

        .test-items-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 10px;
            padding: 0 8px;
        }
        @media (max-width: 640px) {
            .test-items-grid { grid-template-columns: 1fr; }
        }
        .test-item {
            display: flex;
            align-items: flex-start;
            gap: 10px;
            padding: 12px 14px;
            background: #fafbfc;
            border: 1px solid #f1f5f9;
            border-radius: 8px;
            transition: var(--transition);
        }
        .test-item:hover {
            background: white;
            border-color: #e2e8f0;
            box-shadow: 0 2px 8px rgba(0,0,0,0.04);
        }
        .test-item .test-check {
            width: 20px; height: 20px;
            border-radius: 50%;
            background: #dcfce7;
            color: #22c55e;
            display: flex; align-items: center; justify-content: center;
            font-size: 0.65rem;
            flex-shrink: 0;
            margin-top: 2px;
        }
        .test-item .test-info { flex: 1; }
        .test-item .test-name {
            font-size: 0.9rem;
            font-weight: 600;
            color: var(--pr-primary);
            line-height: 1.4;
        }
        .test-item .test-desc {
            font-size: 0.8rem;
            color: #94a3b8;
            line-height: 1.4;
            margin-top: 2px;
        }

        /* Uncategorized tests */
        .tests-flat-list {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 10px;
        }
        @media (max-width: 640px) {
            .tests-flat-list { grid-template-columns: 1fr; }
        }

        /* Accordions */
        .accordion-item { background: white; border: 1px solid #e2e8f0; border-radius: var(--pr-radius); margin-bottom: 10px; overflow: hidden; box-shadow: 0 1px 3px rgba(0,0,0,0.04); }
        .accordion-header { padding: 20px 24px; cursor: pointer; display: flex; justify-content: space-between; align-items: center; font-weight: 700; color: var(--pr-primary); font-size: 1rem; transition: var(--transition); }
        .accordion-header:hover { background: #f8fafc; }
        .accordion-icon { width: 28px; height: 28px; background: var(--pr-secondary); color: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; transition: 0.3s; flex-shrink: 0; margin-right: 12px; font-size: 0.75rem; }
        .accordion-content { max-height: 0; overflow: hidden; transition: max-height 0.35s ease; }
        .accordion-content-inner { padding: 18px 24px 22px; color: #64748B; line-height: 1.8; font-size: 0.98rem; border-top: 1px solid #e2e8f0; }
        .accordion-item.active .accordion-header { background: #f8fafc; }
        .accordion-item.active .accordion-icon { transform: rotate(180deg); background: var(--pr-primary); }
        .accordion-item.active .accordion-content { max-height: 600px; }

        /* Sidebar */
        .pkg-sidebar { position: sticky; top: 94px; }
        @media (max-width: 1024px) { .pkg-sidebar { position: static; order: -1; } }
        .order-card { background: white; border-radius: var(--pr-radius-lg); padding: 28px 24px; box-shadow: var(--pr-shadow-card); border: 1px solid #e2e8f0; }
        .order-price-main { font-size: 2.5rem; font-weight: 900; color: var(--pr-primary); font-family: 'Cairo'; line-height: 1; }
        .price-variants { margin: 18px 0; padding: 16px; background: #f8fafc; border-radius: var(--pr-radius); border: 1px solid #e2e8f0; }
        .price-variants .pv-row { display: flex; justify-content: space-between; align-items: center; padding: 8px 0; font-size: 1rem; }
        .price-variants .pv-row:not(:last-child) { border-bottom: 1px solid #e2e8f0; }
        .price-variants .pv-label { color: #64748B; font-weight: 600; }
        .price-variants .pv-value { font-weight: 800; color: var(--pr-primary); font-family: 'Cairo'; }
        .booking-summary-box { background: #f8fafc; border: 1px solid #e2e8f0; border-radius: var(--pr-radius); padding: 16px; margin-bottom: 20px; }
        .booking-summary-box h4 { font-size: 0.95rem; color: var(--pr-primary); margin-bottom: 6px; font-weight: 700; }
        .booking-summary-box p { font-size: 0.9rem; color: #64748B; line-height: 1.5; margin: 0; }
        .form-label { display: block; font-size: 0.9rem; font-weight: 700; color: var(--pr-primary); margin-bottom: 6px; }
        .form-input { width: 100%; padding: 12px 14px; border: 2px solid #e2e8f0; border-radius: 8px; font-size: 1rem; margin-bottom: 14px; font-family: inherit; direction: rtl; }
        .form-input:focus { border-color: var(--pr-secondary); outline: none; }
        .form-textarea { width: 100%; min-height: 80px; padding: 12px 14px; border: 2px solid #e2e8f0; border-radius: 8px; font-size: 1rem; margin-bottom: 18px; resize: vertical; font-family: inherit; direction: rtl; }
        .form-textarea:focus { border-color: var(--pr-secondary); outline: none; }
        .order-btn { display: block; width: 100%; padding: 16px 24px; font-size: 1.05rem; font-weight: 700; border-radius: var(--pr-radius); text-align: center; text-decoration: none; transition: var(--transition); font-family: 'Cairo'; margin-bottom: 12px; border: none; cursor: pointer; }
        .order-btn-book { background: var(--pr-primary); color: white; }
        .order-btn-book:hover { background: #2D3748; color: white; }
        .order-btn-whatsapp { background: #25D366; color: white; display: flex; align-items: center; justify-content: center; gap: 10px; }
        .order-btn-whatsapp:hover { background: #1da851; color: white; }
        .order-btn-pay { background: white; color: var(--pr-primary); border: 2px solid var(--pr-primary) !important; }
        .order-btn-pay:hover { background: var(--pr-primary); color: white; }

        /* Installment note */
        .installment-note {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 10px 14px;
            background: #fefce8;
            border: 1px solid #fde68a;
            border-radius: 8px;
            font-size: 0.82rem;
            color: #a16207;
            font-weight: 600;
            margin-top: 8px;
        }
        .installment-note i { font-size: 0.95rem; }

        /* Discover / Related */
        .discover { max-width: 1280px; margin: 0 auto; padding: 0 20px 56px; }
        .discover h2 { font-size: 1.5rem; color: var(--pr-primary); font-weight: 800; margin-bottom: 24px; text-align: center; }
        .discover-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 20px; }
        @media (max-width: 768px) { .discover-grid { grid-template-columns: 1fr; } }
        .discover-card { background: white; border-radius: var(--pr-radius); overflow: hidden; box-shadow: var(--pr-shadow); border: 1px solid #e2e8f0; transition: var(--transition); text-decoration: none; color: inherit; display: block; }
        .discover-card:hover { transform: translateY(-4px); box-shadow: 0 12px 28px rgba(0,0,0,0.1); border-color: var(--pr-secondary); }
        .discover-card img { width: 100%; height: 140px; object-fit: cover; background: #f1f5f9; }
        .discover-card .dc-body { padding: 16px; }
        .discover-card h4 { font-size: 1rem; color: var(--pr-primary); font-weight: 700; margin-bottom: 6px; line-height: 1.35; }
        .discover-card p { font-size: 0.88rem; color: #64748B; margin-bottom: 10px; line-height: 1.5; display: -webkit-box; -webkit-line-clamp: 2; line-clamp: 2; -webkit-box-orient: vertical; overflow: hidden; }
        .discover-card .dc-price { font-size: 1.1rem; font-weight: 800; color: var(--pr-secondary); }

        /* Mobile Footer Bar */
        .mobile-footer-bar { display: none; }
        @media (max-width: 768px) {
            .mobile-footer-bar {
                display: flex; position: fixed; bottom: 0; left: 0; right: 0; z-index: 200;
                background: white; box-shadow: 0 -4px 24px rgba(0,0,0,0.12);
                padding: 14px 16px; padding-bottom: max(14px, env(safe-area-inset-bottom));
                align-items: center; gap: 16px; border-top: 1px solid #e2e8f0;
            }
            .mobile-footer-bar .mfb-price-wrap { flex: 1; min-width: 0; }
            .mobile-footer-bar .mfb-price-label { font-size: 0.75rem; color: #64748B; font-weight: 600; margin-bottom: 2px; }
            .mobile-footer-bar .mfb-price { font-size: 1.5rem; font-weight: 900; color: var(--pr-primary); font-family: 'Cairo'; line-height: 1; }
            .mobile-footer-bar .mfb-currency { font-size: 0.8rem; color: #64748B; margin-top: 2px; }
            .mobile-footer-bar .mfb-btn {
                flex-shrink: 0; display: inline-flex; align-items: center; justify-content: center; gap: 8px;
                padding: 16px 24px; min-height: 52px; min-width: 140px;
                background: var(--pr-primary); color: white; border: none; border-radius: 50px;
                font-size: 1.05rem; font-weight: 700; font-family: 'Cairo', sans-serif;
                text-decoration: none; cursor: pointer; transition: var(--transition);
                box-shadow: 0 4px 16px rgba(26, 54, 93, 0.35);
            }
            .mobile-footer-bar .mfb-btn:hover { background: var(--pr-secondary); color: white; }
            .pkg-sidebar { display: none !important; }
            body { padding-bottom: 88px; }
        }

        /* Booking Modal */
        .booking-modal-overlay { display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.5); backdrop-filter: blur(4px); z-index: 300; justify-content: center; align-items: flex-end; padding: 0; }
        .booking-modal-overlay.active { display: flex; }
        .booking-modal-box { width: 100%; max-height: 90vh; background: white; border-radius: 16px 16px 0 0; overflow-y: auto; animation: slideUpModal 0.3s ease; box-shadow: 0 -8px 32px rgba(0,0,0,0.15); }
        @keyframes slideUpModal { from { transform: translateY(100%); } to { transform: translateY(0); } }
        .booking-modal-header { position: sticky; top: 0; background: white; padding: 16px 20px; border-bottom: 1px solid #e2e8f0; display: flex; justify-content: space-between; align-items: center; z-index: 1; }
        .booking-modal-header h3 { font-size: 1.25rem; color: var(--pr-primary); font-weight: 800; margin: 0; }
        .booking-modal-close { width: 44px; height: 44px; display: flex; align-items: center; justify-content: center; border-radius: 50%; background: #f1f5f9; color: var(--pr-primary); border: none; cursor: pointer; font-size: 1.5rem; transition: var(--transition); }
        .booking-modal-close:hover { background: #e2e8f0; color: var(--pr-secondary); }
        .booking-modal-body { padding: 20px; padding-bottom: max(20px, env(safe-area-inset-bottom)); }
    </style>

    <div class="pkg-detail-page">
        
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($isPreview) && $isPreview): ?>
            <div class="preview-banner">
                <i class="fas fa-eye"></i>
                <?php echo e(__('preview_banner')); ?>

            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        <div class="page-layout">
            
            <div class="main-col">
                
                <div class="pkg-hero-wrap">
                    <a href="<?php echo e(route('packages.index')); ?>" class="hero-back" title="<?php echo e(__('back_title')); ?>"><i class="fas fa-arrow-right"></i></a>
                    <button class="hero-share" onclick="sharePackage()" title="<?php echo e(__('share_title')); ?>"><i class="fas fa-share-alt"></i></button>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($package->image): ?>
                        <img class="hero-img" src="<?php echo e(asset('storage/' . $package->image)); ?>" alt="<?php echo e($package->translated_name); ?>">
                    <?php else: ?>
                        <div class="hero-img" style="background: linear-gradient(135deg, #e2e8f0 0%, #cbd5e1 100%); display: flex; align-items: center; justify-content: center;">
                            <i class="fas fa-microscope" style="font-size: 4rem; color: var(--pr-secondary); opacity: 0.5;"></i>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <div class="pkg-hero-overlay">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($package->discount_percentage > 0): ?>
                            <span class="promo"><?php echo e(__('discount_off', ['percentage' => $package->discount_percentage])); ?></span>
                        <?php elseif($package->translated_badge_text): ?>
                            <span class="promo"><?php echo e($package->translated_badge_text); ?></span>
                        <?php else: ?>
                            <span class="promo"><?php echo e(__('special_offer')); ?></span>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <span class="hero-price-block">
                            <span class="price-hero"><?php echo e(number_format($package->final_price)); ?></span>
                            <span class="currency"><?php echo e(__('currency_sar')); ?></span>
                        </span>
                    </div>
                </div>

                
                <div class="content-card">
                    
                    <div class="pkg-tags">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($package->discount_percentage > 0): ?>
                            <span class="pkg-tag offer"><i class="fas fa-fire"></i> <?php echo e(__('offers_badge')); ?></span>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($package->tests_count > 0): ?>
                            <span class="pkg-tag tests"><i class="fas fa-vial"></i> <?php echo e($package->tests_count); ?> <?php echo e($package->tests_count == 1 ? __('test_count_single') : __('test_count_suffix')); ?></span>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($package->estimated_time): ?>
                            <span class="pkg-tag"><i class="fas fa-clock"></i> <?php echo e($package->estimated_time); ?></span>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>

                    <h1><?php echo e($package->translated_name); ?></h1>

                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($package->translated_description): ?>
                        <p class="pkg-desc"><?php echo $package->translated_description; ?></p>
                    <?php elseif($package->translated_short_description): ?>
                        <p class="pkg-desc"><?php echo e($package->translated_short_description); ?></p>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($package->sample_type || $package->collection_method || $package->fasting_instructions): ?>
                        <div class="instructions-grid">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($package->sample_type): ?>
                                <div class="instruction-item">
                                    <div class="inst-icon"><i class="fas fa-syringe"></i></div>
                                    <div class="inst-text">
                                        <div class="inst-label"><?php echo e(__('sample_type')); ?></div>
                                        <div class="inst-value"><?php echo e($package->sample_type); ?></div>
                                    </div>
                                </div>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($package->collection_method): ?>
                                <div class="instruction-item">
                                    <div class="inst-icon"><i class="fas fa-hand-holding-medical"></i></div>
                                    <div class="inst-text">
                                        <div class="inst-label"><?php echo e(__('collection_method')); ?></div>
                                        <div class="inst-value"><?php echo e($package->collection_method); ?></div>
                                    </div>
                                </div>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($package->fasting_instructions || $package->translated_fasting_instructions): ?>
                                <div class="instruction-item">
                                    <div class="inst-icon"><i class="fas fa-utensils"></i></div>
                                    <div class="inst-text">
                                        <div class="inst-label"><?php echo e(__('fasting_instructions')); ?></div>
                                        <div class="inst-value"><?php echo e($package->translated_fasting_instructions ?? $package->fasting_instructions); ?></div>
                                    </div>
                                </div>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($package->estimated_time): ?>
                                <div class="instruction-item">
                                    <div class="inst-icon"><i class="fas fa-clock"></i></div>
                                    <div class="inst-text">
                                        <div class="inst-label"><?php echo e(__('results_duration')); ?></div>
                                        <div class="inst-value"><?php echo e($package->estimated_time); ?></div>
                                    </div>
                                </div>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($groupedTests->count() > 0): ?>
                        <h3 class="section-title"><i class="fas fa-list-check"></i> <?php echo e(__('whats_included')); ?> (<?php echo e($package->tests_count); ?> <?php echo e($package->tests_count == 1 ? __('test_count_single') : __('test_count_suffix')); ?>)</h3>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $groupedTests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($group['category']): ?>
                                
                                <div class="test-category-section" data-cat>
                                    <div class="test-category-header" onclick="this.parentElement.classList.toggle('collapsed')">
                                        <i class="cat-icon <?php echo e($group['category']->icon ?? 'fas fa-vial'); ?>"></i>
                                        <h4><?php echo e($group['category']->translated_name); ?></h4>
                                        <span class="cat-count"><?php echo e($group['tests']->count()); ?></span>
                                        <i class="toggle-icon fas fa-chevron-down"></i>
                                    </div>
                                    <div class="test-items-grid">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $group['tests']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $test): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="test-item">
                                                <div class="test-check"><i class="fas fa-check"></i></div>
                                                <div class="test-info">
                                                    <div class="test-name"><?php echo e($test->translated_name); ?></div>
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($test->translated_short_description): ?>
                                                        <div class="test-desc"><?php echo e($test->translated_short_description); ?></div>
                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                            <?php else: ?>
                                
                                <div class="test-category-section">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($groupedTests->count() > 1): ?>
                                        <div class="test-category-header" onclick="this.parentElement.classList.toggle('collapsed')">
                                            <i class="cat-icon fas fa-flask"></i>
                                            <h4><?php echo e(__('other_tests')); ?></h4>
                                            <span class="cat-count"><?php echo e($group['tests']->count()); ?></span>
                                            <i class="toggle-icon fas fa-chevron-down"></i>
                                        </div>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    <div class="test-items-grid">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $group['tests']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $test): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="test-item">
                                                <div class="test-check"><i class="fas fa-check"></i></div>
                                                <div class="test-info">
                                                    <div class="test-name"><?php echo e($test->translated_name); ?></div>
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($test->translated_short_description): ?>
                                                        <div class="test-desc"><?php echo e($test->translated_short_description); ?></div>
                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <?php elseif($package->features && count($package->features) > 0): ?>
                        <h3 class="section-title"><i class="fas fa-list-check"></i> <?php echo e(__('whats_included')); ?></h3>
                        <div class="tests-flat-list">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $package->features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="test-item">
                                    <div class="test-check"><i class="fas fa-check"></i></div>
                                    <div class="test-info">
                                        <div class="test-name"><?php echo e(is_array($feature) ? ($feature['feature'] ?? '') : $feature); ?></div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($groupedTests->count() > 0 && $package->features && is_array($package->features) && count($package->features) > 0): ?>
                        <h3 class="section-title" style="margin-top: 24px;"><i class="fas fa-star"></i> <?php echo e(__('additional_features')); ?></h3>
                        <div class="tests-flat-list">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $package->features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="test-item">
                                    <div class="test-check"><i class="fas fa-check"></i></div>
                                    <div class="test-info">
                                        <div class="test-name"><?php echo e(is_array($feature) ? ($feature['feature'] ?? '') : $feature); ?></div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>

                
                <div class="content-card">
                    <h3 class="section-title" style="margin-bottom: 16px;"><i class="fas fa-circle-info"></i> <?php echo e(__('additional_info')); ?></h3>

                    
                    <div class="accordion-item active">
                        <div class="accordion-header" onclick="this.parentElement.classList.toggle('active')">
                            <?php echo e(__('how_it_works')); ?>

                            <div class="accordion-icon"><i class="fas fa-chevron-down"></i></div>
                        </div>
                        <div class="accordion-content">
                            <div class="accordion-content-inner">
                                <?php echo e(__('how_it_works_content')); ?>

                            </div>
                        </div>
                    </div>

                    
                    <div class="accordion-item">
                        <div class="accordion-header" onclick="this.parentElement.classList.toggle('active')">
                            <?php echo e(__('pre_service_instructions')); ?>

                            <div class="accordion-icon"><i class="fas fa-chevron-down"></i></div>
                        </div>
                        <div class="accordion-content">
                            <div class="accordion-content-inner">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($package->translated_preparation_instructions): ?>
                                    <?php echo $package->translated_preparation_instructions; ?>

                                <?php else: ?>
                                    <?php echo e(__('pre_service_default')); ?>

                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>
                    </div>

                    
                    <div class="accordion-item">
                        <div class="accordion-header" onclick="this.parentElement.classList.toggle('active')">
                            <?php echo e(__('faq')); ?>

                            <div class="accordion-icon"><i class="fas fa-chevron-down"></i></div>
                        </div>
                        <div class="accordion-content">
                            <div class="accordion-content-inner">
                                <strong><?php echo e(__('faq_q1')); ?></strong> <?php echo e(__('faq_a1')); ?><br>
                                <strong><?php echo e(__('faq_q2')); ?></strong> <?php echo e(__('faq_a2')); ?><br>
                                <strong><?php echo e(__('faq_q3')); ?></strong> <?php echo e(__('faq_a3')); ?><br>
                                <strong><?php echo e(__('faq_q4')); ?></strong> <?php echo e(__('faq_a4')); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <aside class="pkg-sidebar" id="booking-sidebar">
                <div class="order-card" id="order-form">
                    
                    <div style="text-align: center; margin-bottom: 8px; font-size: 0.9rem; color: #64748B; font-weight: 600;"><?php echo e(__('package_price')); ?></div>

                    
                    <div style="text-align: center; margin-bottom: 20px;">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($package->sale_price && $package->price > $package->sale_price): ?>
                            <span style="font-size: 1.1rem; color: #94a3b8; text-decoration: line-through; font-weight: 600;"><?php echo e(number_format($package->price)); ?></span>
                            <span style="font-size: 0.85rem; color: #94a3b8;"> <?php echo e(__('currency_symbol')); ?></span>
                            <br>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <span style="font-size: 2.8rem; font-weight: 900; color: var(--pr-secondary); font-family: 'Cairo'; line-height: 1.1;"><?php echo e(number_format($package->final_price)); ?></span>
                        <span style="font-size: 1rem; color: var(--pr-secondary); font-weight: 700;"> <?php echo e(__('currency_symbol')); ?></span>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($package->non_saudi_price): ?>
                            <div style="font-size: 0.95rem; color: #64748B; margin-top: 8px; font-weight: 600;">
                                <?php echo e(__('non_saudi_price')); ?>: <span style="color: var(--pr-primary); font-weight: 800;"><?php echo e(number_format($package->non_saudi_price)); ?></span> <?php echo e(__('currency_symbol')); ?>

                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>

                    
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($siteSettings->show_booking_form): ?>
                        <?php
                            // Look for the specific custom form assigned to the package, or fallback to latest active form.
                            $assignedForm = $package->customForm && $package->customForm->is_active ? $package->customForm : null;
                            $bookingForm = $assignedForm ?? \App\Models\CustomForm::active()->latest()->first();
                        ?>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($bookingForm): ?>
                            <div class="custom-booking-form-wrapper">
                                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('custom-form-widget', ['formId' => $bookingForm->id]);

$key = null;

$key ??= \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::generateKey('lw-4246498343-0', null);

$__html = app('livewire')->mount($__name, $__params, $key);

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                            </div>
                        <?php else: ?>
                            <form id="booking-form">
                                <label class="form-label"><i class="fas fa-user" style="margin-left: 6px; color: var(--pr-secondary);"></i> <?php echo e(app()->getLocale() === 'en' ? __('name_label') : ($siteSettings->booking_form_name_label ?? __('name_label'))); ?></label>
                                <input type="text" id="b-name" name="name" required placeholder="<?php echo e(app()->getLocale() === 'en' ? __('name_placeholder') : ($siteSettings->booking_form_name_placeholder ?? __('name_placeholder'))); ?>" class="form-input">

                                <label class="form-label"><i class="fas fa-phone" style="margin-left: 6px; color: var(--pr-secondary);"></i> <?php echo e(app()->getLocale() === 'en' ? __('phone_label') : ($siteSettings->booking_form_phone_label ?? __('phone_label'))); ?></label>
                                <input type="tel" id="b-phone" name="phone" required placeholder="<?php echo e(app()->getLocale() === 'en' ? __('phone_placeholder') : ($siteSettings->booking_form_phone_placeholder ?? __('phone_placeholder'))); ?>" class="form-input">

                                <button type="submit" class="order-btn order-btn-book" style="background: #7c3aed; border-radius: 8px;">
                                    <i class="fas fa-paper-plane"></i> <?php echo e(app()->getLocale() === 'en' ? __('book_free_now') : ($siteSettings->booking_btn_text ?? __('book_free_now'))); ?>

                                </button>
                            </form>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($siteSettings->show_whatsapp_booking): ?>
                    <a id="whatsapp-btn" href="#" target="_blank" rel="noopener" class="order-btn order-btn-whatsapp" style="border-radius: 8px;">
                        <i class="fab fa-whatsapp"></i> <?php echo e(app()->getLocale() === 'en' ? __('book_via_whatsapp') : ($siteSettings->whatsapp_btn_text ?? __('book_via_whatsapp'))); ?>

                    </a>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($siteSettings->show_credit_payment): ?>
                    <button type="button" class="order-btn order-btn-pay" style="border-radius: 8px;">
                        <i class="fas fa-credit-card"></i> <?php echo e(app()->getLocale() === 'en' ? __('book_via_credit') : ($siteSettings->credit_btn_text ?? __('book_via_credit'))); ?>

                    </button>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($siteSettings->show_installment_note): ?>
                    <div class="installment-note">
                        <i class="fas fa-info-circle"></i>
                        <?php echo e(app()->getLocale() === 'en' ? ($siteSettings->installment_note_text_en ?? __('installment_note_default')) : ($siteSettings->installment_note_text ?? __('installment_note_default'))); ?>

                    </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
            </aside>
        </div>

        
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($relatedPackages->count() > 0): ?>
        <section class="discover">
            <h2><?php echo e(__('discover_other_packages')); ?></h2>
            <div class="discover-grid">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $relatedPackages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $related): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="<?php echo e(route('package.show', $related->slug)); ?>" class="discover-card">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($related->image): ?>
                        <img src="<?php echo e(asset('storage/' . $related->image)); ?>" alt="<?php echo e($related->translated_name); ?>">
                    <?php else: ?>
                        <div style="width:100%;height:140px;background:linear-gradient(135deg,#e2e8f0,#cbd5e1);display:flex;align-items:center;justify-content:center;">
                            <i class="fas fa-microscope" style="font-size:2rem;color:var(--pr-secondary);opacity:0.4;"></i>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <div class="dc-body">
                        <h4><?php echo e($related->translated_name); ?></h4>
                        <p><?php echo e($related->translated_short_description ?? Str::limit(strip_tags($related->translated_description), 80)); ?></p>
                        <span class="dc-price"><?php echo e(number_format($related->final_price)); ?> <?php echo e(__('currency_symbol')); ?></span>
                    </div>
                </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
        </section>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        
        <div class="mobile-footer-bar" id="mobile-footer-bar">
            <div class="mfb-price-wrap">
                <div class="mfb-price-label"><?php echo e(__('from_label')); ?></div>
                <div class="mfb-price"><?php echo e(number_format($package->final_price)); ?></div>
                <div class="mfb-currency"><?php echo e(__('currency_sar')); ?></div>
            </div>
            <a href="#" id="mfb-book-btn" class="mfb-btn" role="button"><i class="fas fa-calendar-check"></i> <?php echo e(__('book_now_btn')); ?></a>
        </div>

        
        <div id="booking-modal" class="booking-modal-overlay" aria-hidden="true">
            <div class="booking-modal-box">
                <div class="booking-modal-header">
                    <h3><?php echo e(__('booking_modal_title')); ?></h3>
                    <button type="button" class="booking-modal-close" id="booking-modal-close" aria-label="<?php echo e(__('close_modal_btn')); ?>"><i class="fas fa-times"></i></button>
                </div>
                <div id="booking-modal-body" class="booking-modal-body"></div>
            </div>
        </div>
    </div>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const WHATSAPP_NUMBER = <?php echo json_encode($siteSettings->contact_whatsapp ?? '966500000000', 15, 512) ?>;
        const WHATSAPP_TEMPLATE = <?php echo json_encode($siteSettings->whatsapp_message_template ?? "مرحباً، أود الحجز:\nالباقة: {package}\nالاسم: {name}\nالجوال: {phone}", 15, 512) ?>;
        const BOOKING_SUCCESS_MSG = <?php echo json_encode($siteSettings->booking_success_message ?? 'تم إرسال طلبك بنجاح! سنتواصل معك قريباً.', 15, 512) ?>;
        const pkgTitle = <?php echo json_encode($package->translated_name, 15, 512) ?>;

        // WhatsApp dynamic link
        function updateWhatsApp() {
            const waBtn = document.getElementById('whatsapp-btn');
            if (!waBtn) return;
            const nameEl = document.getElementById('b-name');
            const phoneEl = document.getElementById('b-phone');
            const name = nameEl ? nameEl.value.trim() : '';
            const phone = phoneEl ? phoneEl.value.trim() : '';
            let text = WHATSAPP_TEMPLATE
                .replace('{package}', pkgTitle)
                .replace('{name}', name || '—')
                .replace('{phone}', phone || '—');
            waBtn.href = 'https://wa.me/' + WHATSAPP_NUMBER + '?text=' + encodeURIComponent(text);
        }
        updateWhatsApp();

        const nameInput = document.getElementById('b-name');
        const phoneInput = document.getElementById('b-phone');
        if (nameInput) nameInput.addEventListener('input', updateWhatsApp);
        if (phoneInput) phoneInput.addEventListener('input', updateWhatsApp);

        // Booking form submit
        const bookingForm = document.getElementById('booking-form');
        if (bookingForm) {
            bookingForm.addEventListener('submit', function(e) {
                e.preventDefault();
                const name = document.getElementById('b-name').value.trim();
                const phone = document.getElementById('b-phone').value.trim();
                if (!name || !phone) { alert(<?php echo json_encode(__('booking_required_alert'), 15, 512) ?>); return; }
                alert(BOOKING_SUCCESS_MSG + '\n' + pkgTitle + ' — ' + name);
            });
        }

        // Share button
        window.sharePackage = function() {
            if (navigator.share) {
                navigator.share({ title: pkgTitle, url: window.location.href });
            } else {
                navigator.clipboard.writeText(window.location.href).then(() => {
                    alert(<?php echo json_encode(__('booking_copied_alert'), 15, 512) ?>);
                });
            }
        };

        // Mobile modal
        var orderFormEl = document.getElementById('order-form');
        var sidebarEl = document.getElementById('booking-sidebar');
        var modalEl = document.getElementById('booking-modal');
        var modalBodyEl = document.getElementById('booking-modal-body');
        var mfbBookBtn = document.getElementById('mfb-book-btn');

        function openBookingModal() {
            if (!orderFormEl || !modalBodyEl || !modalEl) return;
            modalBodyEl.appendChild(orderFormEl);
            modalEl.classList.add('active');
            modalEl.setAttribute('aria-hidden', 'false');
            document.body.style.overflow = 'hidden';
        }

        function closeBookingModal() {
            if (!orderFormEl || !sidebarEl || !modalEl) return;
            sidebarEl.appendChild(orderFormEl);
            modalEl.classList.remove('active');
            modalEl.setAttribute('aria-hidden', 'true');
            document.body.style.overflow = '';
        }

        if (mfbBookBtn) {
            mfbBookBtn.addEventListener('click', function(e) {
                e.preventDefault();
                if (window.matchMedia('(max-width: 768px)').matches) openBookingModal();
                else window.location.hash = 'order-form';
            });
        }

        var closeBtn = document.getElementById('booking-modal-close');
        if (closeBtn) closeBtn.addEventListener('click', closeBookingModal);
        if (modalEl) modalEl.addEventListener('click', function(e) { if (e.target === modalEl) closeBookingModal(); });
    });
    </script>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5863877a5171c196453bfa0bd807e410)): ?>
<?php $attributes = $__attributesOriginal5863877a5171c196453bfa0bd807e410; ?>
<?php unset($__attributesOriginal5863877a5171c196453bfa0bd807e410); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5863877a5171c196453bfa0bd807e410)): ?>
<?php $component = $__componentOriginal5863877a5171c196453bfa0bd807e410; ?>
<?php unset($__componentOriginal5863877a5171c196453bfa0bd807e410); ?>
<?php endif; ?>
<?php /**PATH /Users/test/Documents/prisma1/resources/views/packages/show.blade.php ENDPATH**/ ?>