<?php

$siteSettings = $siteSettings ?? (function () { try { return app(\App\Settings\SiteSettings::class); } catch (\Throwable $e) { return new \stdClass(); } })();
$layoutType = $data['layout_type'] ?? '4_images_grid';
$gridColumns = $data['grid_columns'] ?? '4';
$showMainTitle = $data['show_main_title'] ?? false;

$mainTitle = $data['main_title'] ?? "";
$mainSubtitle = $data['main_subtitle'] ?? "";

$items = $data['items'] ?? [];
$bgColor = $data['bg_color'] ?? '#F8FAFC';
$showBorder = $data['show_border'] ?? true;
$roundedCorners = $data['rounded_corners'] ?? true;
$hoverEffect = $data['hover_effect'] ?? true;
$gap = $data['gap'] ?? 24;

// Columns grid mapping
$colClasses = [
    '2' => 'grid-cols-1 md:grid-cols-2',
    '3' => 'grid-cols-1 md:grid-cols-2 lg:grid-cols-3',
    '4' => 'grid-cols-1 md:grid-cols-2 lg:grid-cols-4',
    '5' => 'grid-cols-1 md:grid-cols-3 lg:grid-cols-5',
];
$colClass = $colClasses[$gridColumns] ?? $colClasses['4'];

$resolveUploadValue = function (mixed $value) use (&$resolveUploadValue): ?string {
    if (is_string($value) && $value !== '') {
        return $value;
    }

    if (! is_array($value)) {
        return null;
    }

    foreach (['path', 'url', 'temporaryUrl', 'preview_url'] as $key) {
        if (! empty($value[$key]) && is_string($value[$key])) {
            return $value[$key];
        }
    }

    foreach ($value as $item) {
        $resolved = $resolveUploadValue($item);
        if ($resolved) {
            return $resolved;
        }
    }

    return null;
};

$toImageUrl = function (mixed $value) use ($resolveUploadValue): ?string {
    $resolved = $resolveUploadValue($value);
    if (! $resolved) {
        return null;
    }

    if (str_starts_with($resolved, 'http://') || str_starts_with($resolved, 'https://') || str_starts_with($resolved, 'data:')) {
        return $resolved;
    }

    if (str_starts_with($resolved, '/storage/')) {
        return url($resolved);
    }

    return asset('storage/' . ltrim($resolved, '/'));
};
?>

<section class="hero-grid" style="background: <?php echo e($bgColor); ?>; padding: 60px 20px;">
    <div style="max-width: 1200px; margin: 0 auto;">
        
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($showMainTitle && ($mainTitle || $mainSubtitle)): ?>
        <div style="text-align: center; margin-bottom: 40px;">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($mainTitle): ?>
            <h2 style="font-size: 1.8rem; font-weight: 900; color: var(--pr-primary); margin-bottom: 12px; font-family: '<?php echo e($siteSettings->font_heading ?? 'Cairo'); ?>', sans-serif;">
                <?php echo e($mainTitle); ?>

            </h2>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($mainSubtitle): ?>
            <p style="color: var(--pr-text); font-size: 1rem;"><?php echo e($mainSubtitle); ?></p>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        
        
        <div class="grid <?php echo e($colClass); ?>" style="gap: <?php echo e($gap); ?>px;">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $type = $item['type'] ?? 'image_text';
                $title = $data['title'] ?? "";
                $subtitle = $data['subtitle'] ?? "";
                $url = $item['url'] ?? '#';
                $highlight = $item['highlight'] ?? false;
                $image = $item['image'] ?? null;
                $icon = $item['icon'] ?? 'fas fa-heartbeat';
                $iconType = $item['icon_type'] ?? 'library';
                $iconImage = $item['icon_image'] ?? null;
                $imageUrl = $toImageUrl($image);
                $iconImageUrl = $toImageUrl($iconImage);
                $iconBgColor = $item['icon_bg_color'] ?? '#00A0B0';
                $iconColor = $item['icon_color'] ?? '#ffffff';
            ?>
            
            <a href="<?php echo e($url); ?>" style="text-decoration: none; <?php echo e($highlight ? 'transform: scale(1.02);' : ''); ?> transition: var(--transition);">
                <div class="grid-item" style="
                    background: white; 
                    <?php echo e($roundedCorners ? 'border-radius: var(--pr-radius-lg);' : ''); ?> 
                    <?php echo e($showBorder ? 'border: 1px solid rgba(0, 160, 176, 0.1);' : ''); ?> 
                    overflow: hidden;
                    <?php echo e($highlight ? 'box-shadow: 0 8px 32px rgba(0, 160, 176, 0.15);' : 'box-shadow: var(--pr-shadow);'); ?>

                    height: 100%;
                    display: flex;
                    flex-direction: column;
                ">
                    
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(inray($type, ['image_text', 'image_only'])): ?>
                    <div style="height: 180px; overflow: hidden; position: relative;">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($imageUrl): ?>
                            <img src="<?php echo e($imageUrl); ?>" alt="<?php echo e($title); ?>" style="width: 100%; height: 100%; object-fit: cover; transition: var(--transition);">
                        <?php else: ?>
                            <div style="width: 100%; height: 100%; background: linear-gradient(135deg, #E8ECF1 0%, #F8FAFC 100%); display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-image" style="font-size: 2.5rem; color: var(--pr-secondary); opacity: 0.5;"></i>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($highlight): ?>
                            <div style="position: absolute; top: 10px; right: 10px; background: linear-gradient(135deg, #F59E0B 0%, #D97706 100%); color: white; padding: 4px 12px; border-radius: 50px; font-size: 0.75rem; font-weight: 700;">
                                <i class="fas fa-star" style="margin-left: 4px;"></i>
                                مميز
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    
                    
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(inray($type, ['icon_text', 'icon_only'])): ?>
                    <div style="padding: 30px 20px; text-align: center;">
                        <div style="
                            width: 80px; 
                            height: 80px; 
                            margin: 0 auto; 
                            border-radius: 50%; 
                            background: linear-gradient(135deg, <?php echo e($iconBgColor); ?> 0%, <?php echo e($iconBgColor); ?>dd 100%); 
                            display: flex; 
                            align-items: center; 
                            justify-content: center; 
                            font-size: 2rem; 
                            color: <?php echo e($iconColor); ?>;
                            box-shadow: 0 8px 24px <?php echo e($iconBgColor); ?>40;
                        ">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($iconType === 'image' && $iconImageUrl): ?>
                                <img src="<?php echo e($iconImageUrl); ?>" alt="" style="width: 40px; height: 40px; object-fit: contain;">
                            <?php else: ?>
                                <i class="<?php echo e($icon); ?>"></i>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    
                    
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(inray($type, ['image_text', 'icon_text'])): ?>
                    <div style="padding: 20px; text-align: center; flex: 1; display: flex; flex-direction: column; justify-content: center;">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($title): ?>
                        <h3 style="font-size: 1.1rem; font-weight: 800; color: var(--pr-primary); margin-bottom: 8px; line-height: 1.4;">
                            <?php echo e($title); ?>

                        </h3>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($subtitle): ?>
                        <p style="font-size: 0.9rem; color: var(--pr-text); line-height: 1.6; margin: 0;">
                            <?php echo e($subtitle); ?>

                        </p>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
            </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
    </div>
</section>

<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($hoverEffect): ?>
<style>
    .grid-item:hover {
        transform: translateY(-8px);
        box-shadow: 0 12px 40px rgba(26, 54, 93, 0.12) !important;
    }
    .grid-item:hover img {
        transform: scale(1.05);
    }
</style>
<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
<?php /**PATH /Users/test/Documents/prisma1/resources/views/components/blocks/prisma-hero-grid.blade.php ENDPATH**/ ?>